/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.primitves;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.benchmark.primitves.vo.Date20Field;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class Date20TreeWrite {
    static String str;
    static List array;
    static ObjectMapper mapper;

    public Date20TreeWrite() {
        try {
            InputStream is = Date20TreeWrite.class.getClassLoader().getResourceAsStream("data/date20.json");
            str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            Date20Field object = (Date20Field)JSON.parseObject((String)str, Date20Field.class);
            array = JSONArray.of((Object[])new Object[]{object.v0000, object.v0001, object.v0002, object.v0003, object.v0004, object.v0005, object.v0006, object.v0007, object.v0008, object.v0009, object.v0010, object.v0011, object.v0012, object.v0013, object.v0014, object.v0015, object.v0016, object.v0017, object.v0018, object.v0019});
            mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Benchmark
    public void fastjson1(Blackhole bh) {
        bh.consume((Object)com.alibaba.fastjson.JSON.toJSONString((Object)array));
    }

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume((Object)JSON.toJSONString((Object)array));
    }

    @Benchmark
    public void fastjson2_jsonb(Blackhole bh) {
        bh.consume((Object)JSONB.toBytes((Object)array));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume((Object)mapper.writeValueAsString((Object)array));
    }

    public void wastjson(Blackhole bh) throws Exception {
        bh.consume((Object)io.github.wycst.wast.json.JSON.toJsonString((Object)array));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(Date20TreeWrite.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
    }
}

