/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.jjb;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.benchmark.jjb.Clients;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.runtime.Settings;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class ClientsWriteUTF8Bytes {
    static Clients clients;
    static final ObjectMapper mapper;
    static final Gson gson;
    static final DslJson<Object> dslJson;
    static final ThreadLocal<ByteArrayOutputStream> bytesOutLocal;

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume((Object)JSON.toJSONBytes((Object)clients));
    }

    public void jsonb(Blackhole bh) {
        bh.consume((Object)JSONB.toBytes((Object)clients));
    }

    public void jsonb_beanToArray(Blackhole bh) {
        bh.consume((Object)JSONB.toBytes((Object)clients, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.BeanToArray, JSONWriter.Feature.FieldBased}));
    }

    public void fastjson2_str(Blackhole bh) {
        bh.consume((Object)JSON.toJSONString((Object)clients));
    }

    @Benchmark
    public void dsljson(Blackhole bh) throws IOException {
        ByteArrayOutputStream bytesOut = bytesOutLocal.get();
        bytesOut.reset();
        dslJson.serialize((Object)clients, (OutputStream)bytesOut);
        byte[] bytes = bytesOut.toByteArray();
        bh.consume((Object)bytes);
    }

    public void jackson(Blackhole bh) throws Exception {
        bh.consume((Object)mapper.writeValueAsBytes((Object)clients));
    }

    public void gson(Blackhole bh) throws Exception {
        bh.consume((Object)gson.toJson((Object)clients).getBytes(StandardCharsets.UTF_8));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(ClientsWriteUTF8Bytes.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(2).threads(16).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
        gson = new Gson();
        dslJson = new DslJson(Settings.withRuntime().includeServiceLoader());
        bytesOutLocal = ThreadLocal.withInitial(() -> new ByteArrayOutputStream());
        try {
            InputStream is = ClientsWriteUTF8Bytes.class.getClassLoader().getResourceAsStream("data/jjb/client.json");
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            clients = (Clients)JSONReader.of((String)str).read(Clients.class);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

