/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark;

import com.alibaba.fastjson2.util.UnsafeUtils;
import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class StringGetValueBenchmark {
    static String STR = "01234567890ABCDEFGHIJKLMNOPQRSTUVWZYZabcdefghijklmnopqrstuvwzyz\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341";
    static final char[] chars = new char[128];
    static Field valueField;
    static long valueFieldOffset;

    @Benchmark
    public char[] reflect() throws Exception {
        return (char[])valueField.get(STR);
    }

    @Benchmark
    public char[] unsafe() throws Exception {
        return (char[])UnsafeUtils.UNSAFE.getObject(STR, valueFieldOffset);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(StringGetValueBenchmark.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).forks(1).build();
        new Runner(options).run();
    }

    static {
        try {
            valueField = String.class.getDeclaredField("value");
            valueField.setAccessible(true);
            valueFieldOffset = UnsafeUtils.UNSAFE.objectFieldOffset(valueField);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

