/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark;

import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class DecodeUTF8BenchmarkJDK17 {
    static byte[] utf8Bytes = "01234567890ABCDEFGHIJKLMNOPQRSTUVWZYZabcdefghijklmnopqrstuvwzyz".getBytes(StandardCharsets.UTF_8);
    static long valueFieldOffset;
    static BiFunction<byte[], Charset, String> stringCreator;

    @Benchmark
    public String unsafeEncodeUTF8_17() throws Exception {
        byte[] buf = new byte[utf8Bytes.length * 2];
        int len = IOUtils.decodeUTF8((byte[])utf8Bytes, (int)0, (int)utf8Bytes.length, (byte[])buf);
        byte[] chars = Arrays.copyOf(buf, len);
        return stringCreator.apply(chars, StandardCharsets.US_ASCII);
    }

    @Benchmark
    public String newStringUTF8_17() throws Exception {
        return new String(utf8Bytes);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(DecodeUTF8BenchmarkJDK17.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).forks(1).build();
        new Runner(options).run();
    }

    static {
        try {
            Field valueField = String.class.getDeclaredField("value");
            valueFieldOffset = UnsafeUtils.UNSAFE.objectFieldOffset(valueField);
            stringCreator = JDKUtils.getStringCreatorJDK17();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

