/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.runner.RunnerException;

public class Issue210 {
    static final JSONPath jsonPath = JSONPath.of((String)"$.password");
    static final Sha256BiFunction callbackBiFunction = new Sha256BiFunction();
    static final JSONObject object;
    static final Bean bean;

    @Benchmark
    public void objectSet() {
        jsonPath.setCallback((Object)object, (BiFunction)callbackBiFunction);
    }

    @Benchmark
    public void beanSet() {
        jsonPath.setCallback((Object)bean, (BiFunction)callbackBiFunction);
    }

    public static void main(String[] args) throws RunnerException {
        new Issue210().beanSet();
    }

    static {
        bean = new Bean();
        bean.password = "12345678";
        object = JSONObject.of((String)"password", (Object)bean.password);
    }

    static final class Sha256BiFunction
    implements BiFunction {
        Sha256BiFunction() {
        }

        public Object apply(Object o, Object o2) {
            String str = (String)o2;
            return str;
        }
    }

    public static class Bean {
        private String password;

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    static final class Sha256
    implements Function {
        Sha256() {
        }

        public Object apply(Object val) {
            String str = (String)val;
            return str;
        }
    }
}

