/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.eishay;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.benchmark.eishay.vo.MediaContent;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class EishayWriteUTF8Bytes {
    static MediaContent mc;
    static final ObjectMapper mapper;
    static final Gson gson;

    @Benchmark
    public void fastjson1(Blackhole bh) {
        bh.consume((Object)com.alibaba.fastjson.JSON.toJSONBytes((Object)mc, (SerializerFeature[])new SerializerFeature[0]));
    }

    @Benchmark
    public void fastjson2(Blackhole bh) {
        bh.consume((Object)JSON.toJSONBytes((Object)mc));
    }

    @Benchmark
    public void jackson(Blackhole bh) throws Exception {
        bh.consume((Object)mapper.writeValueAsBytes((Object)mc));
    }

    @Benchmark
    public void gson(Blackhole bh) throws Exception {
        bh.consume((Object)gson.toJson((Object)mc).getBytes(StandardCharsets.UTF_8));
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(EishayWriteUTF8Bytes.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).threads(2).build();
        new Runner(options).run();
    }

    static {
        mapper = new ObjectMapper();
        gson = new Gson();
        try {
            InputStream is = EishayWriteUTF8Bytes.class.getClassLoader().getResourceAsStream("data/eishay.json");
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            mc = (MediaContent)JSONReader.of((String)str).read(MediaContent.class);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

