/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.benchmark.eishay;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.benchmark.eishay.EishayFuryCompatibleWrite;
import com.alibaba.fastjson2.benchmark.eishay.vo.MediaContent;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class EishayFuryCompatibleParse {
    static MediaContent mc;
    static JSONReader.Feature[] features;
    static JSONReader.Context context;
    static byte[] jsonbBytes;
    static byte[] furyCompatibleBytes;

    @Benchmark
    public void jsonb(Blackhole bh) {
        Object object = JSONB.parseObject((byte[])jsonbBytes, Object.class, (JSONReader.Context)context);
        bh.consume(object);
    }

    public void fury(Blackhole bh) {
    }

    public static void main(String[] args) throws Exception {
        Options options = new OptionsBuilder().include(EishayFuryCompatibleParse.class.getName()).mode(Mode.Throughput).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(3).forks(1).build();
        new Runner(options).run();
    }

    static {
        features = new JSONReader.Feature[]{JSONReader.Feature.SupportAutoType, JSONReader.Feature.IgnoreNoneSerializable, JSONReader.Feature.UseDefaultConstructorAsPossible, JSONReader.Feature.UseNativeObject, JSONReader.Feature.FieldBased};
        context = new JSONReader.Context(JSONFactory.getDefaultObjectReaderProvider(), features);
        try {
            InputStream is = EishayFuryCompatibleParse.class.getClassLoader().getResourceAsStream("data/eishay.json");
            String str = IOUtils.toString((InputStream)is, (String)"UTF-8");
            mc = (MediaContent)JSONReader.of((String)str).read(MediaContent.class);
            jsonbBytes = JSONB.toBytes((Object)mc, (JSONWriter.Feature[])EishayFuryCompatibleWrite.features);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

