/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;

public class JSONValidator {
    private JSONReader jsonReader;
    private Boolean validateResult;
    private Type type;
    private char firstChar;

    private JSONValidator(JSONReader jsonReader) {
        this.jsonReader = jsonReader;
    }

    public static JSONValidator fromUtf8(byte[] jsonBytes) {
        return new JSONValidator(JSONReader.of((byte[])jsonBytes));
    }

    public static JSONValidator from(String jsonStr) {
        return new JSONValidator(JSONReader.of((String)jsonStr));
    }

    public boolean validate() {
        if (this.validateResult != null) {
            return this.validateResult;
        }
        try {
            this.firstChar = this.jsonReader.current();
            this.jsonReader.skipValue();
        }
        catch (JSONException | ArrayIndexOutOfBoundsException error) {
            this.validateResult = false;
            boolean bl = this.validateResult;
            return bl;
        }
        finally {
            this.jsonReader.close();
        }
        this.type = this.firstChar == '{' ? Type.Object : (this.firstChar == '[' ? Type.Array : Type.Value);
        this.validateResult = this.jsonReader.isEnd();
        return this.validateResult;
    }

    public Type getType() {
        if (this.type == null) {
            this.validate();
        }
        return this.type;
    }

    public static enum Type {
        Object,
        Array,
        Value;

    }
}

