/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.DefaultFieldDeserializer;
import com.alibaba.fastjson.parser.EnumDeserializer;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JavaBeanDeserializer;
import com.alibaba.fastjson.parser.JavaBeanInfo;
import com.alibaba.fastjson.parser.JavaObjectDeserializer;
import com.alibaba.fastjson.parser.ListTypeFieldDeserializer;
import com.alibaba.fastjson.parser.MapDeserializer;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.parser.ThrowableDeserializer;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.ArrayCodec;
import com.alibaba.fastjson.serializer.BigDecimalCodec;
import com.alibaba.fastjson.serializer.BooleanCodec;
import com.alibaba.fastjson.serializer.CollectionCodec;
import com.alibaba.fastjson.serializer.DateCodec;
import com.alibaba.fastjson.serializer.IntegerCodec;
import com.alibaba.fastjson.serializer.MiscCodec;
import com.alibaba.fastjson.serializer.NumberCodec;
import com.alibaba.fastjson.serializer.StringCodec;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.IdentityHashMap;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserConfig {
    private static long[] denyList = new long[]{-9164606388214699518L, -8720046426850100497L, -8649961213709896794L, -8165637398350707645L, -8109300701639721088L, -7966123100503199569L, -7921218830998286408L, -7775351613326101303L, -7768608037458185275L, -7766605818834748097L, -6835437086156813536L, -6316154655839304624L, -6179589609550493385L, -6149130139291498841L, -6149093380703242441L, -6025144546313590215L, -5939269048541779808L, -5885964883385605994L, -5767141746063564198L, -5764804792063216819L, -5472097725414717105L, -5194641081268104286L, -5076846148177416215L, -4837536971810737970L, -4836620931940850535L, -4703320437989596122L, -4608341446948126581L, -4537258998789938600L, -4438775680185074100L, -4314457471973557243L, -4150995715611818742L, -4082057040235125754L, -3975378478825053783L, -3967588558552655563L, -3935185854875733362L, -3319207949486691020L, -3077205613010077203L, -3053747177772160511L, -2995060141064716555L, -2825378362173150292L, -2533039401923731906L, -2439930098895578154L, -2378990704010641148L, -2364987994247679115L, -2262244760619952081L, -2192804397019347313L, -2095516571388852610L, -1872417015366588117L, -1650485814983027158L, -1589194880214235129L, -965955008570215305L, -905177026366752536L, -831789045734283466L, -731978084025273882L, -666475508176557463L, -582813228520337988L, -254670111376247151L, -219577392946377768L, -190281065685395680L, -26639035867733124L, -9822483067882491L, 4750336058574309L, 33238344207745342L, 156405680656087946L, 218512992947536312L, 313864100207897507L, 386461436234701831L, 744602970950881621L, 823641066473609950L, 1073634739308289776L, 1153291637701043748L, 1203232727967308606L, 1214780596910349029L, 1459860845934817624L, 1502845958873959152L, 1534439610567445754L, 1698504441317515818L, 1818089308493370394L, 2078113382421334967L, 2164696723069287854L, 2622551729063269307L, 2653453629929770569L, 2660670623866180977L, 2731823439467737506L, 2836431254737891113L, 2930861374593775110L, 3085473968517218653L, 3089451460101527857L, 3114862868117605599L, 3129395579983849527L, 3256258368248066264L, 3452379460455804429L, 3547627781654598988L, 3637939656440441093L, 3688179072722109200L, 3718352661124136681L, 3730752432285826863L, 3794316665763266033L, 4000049462512838776L, 4046190361520671643L, 4147696707147271408L, 4193204392725694463L, 4241163808635564644L, 4254584350247334433L, 4814658433570175913L, 4841947709850912914L, 4904007817188630457L, 5100336081510080343L, 5274044858141538265L, 5347909877633654828L, 5450448828334921485L, 5474268165959054640L, 5545425291794704408L, 5596129856135573697L, 5688200883751798389L, 5751393439502795295L, 5944107969236155580L, 6007332606592876737L, 6280357960959217660L, 6456855723474196908L, 6511035576063254270L, 6534946468240507089L, 6584624952928234050L, 6734240326434096246L, 6742705432718011780L, 6800727078373023163L, 6854854816081053523L, 7045245923763966215L, 7123326897294507060L, 7179336928365889465L, 7240293012336844478L, 7347653049056829645L, 7375862386996623731L, 7442624256860549330L, 7617522210483516279L, 7658177784286215602L, 8055461369741094911L, 8064026652676081192L, 8389032537095247355L, 8409640769019589119L, 8488266005336625107L, 8537233257283452655L, 8838294710098435315L, 9140390920032557669L, 9140416208800006522L};
    public static ParserConfig global = new ParserConfig();
    private final IdentityHashMap<ObjectDeserializer> deserializers = new IdentityHashMap(1024);
    public final SymbolTable symbolTable = new SymbolTable(16384);
    public ClassLoader defaultClassLoader;
    public PropertyNamingStrategy propertyNamingStrategy;
    public boolean autoTypeSupport;

    public static ParserConfig getGlobalInstance() {
        return global;
    }

    public ParserConfig() {
        this.deserializers.put((Type)((Object)SimpleDateFormat.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)java.util.Date.class), DateCodec.instance);
        this.deserializers.put((Type)((Object)Calendar.class), DateCodec.instance);
        this.deserializers.put((Type)((Object)Map.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)HashMap.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)LinkedHashMap.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)TreeMap.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)ConcurrentMap.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)ConcurrentHashMap.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)Collection.class), CollectionCodec.instance);
        this.deserializers.put((Type)((Object)List.class), CollectionCodec.instance);
        this.deserializers.put((Type)((Object)ArrayList.class), CollectionCodec.instance);
        this.deserializers.put((Type)((Object)Object.class), JavaObjectDeserializer.instance);
        this.deserializers.put((Type)((Object)String.class), StringCodec.instance);
        this.deserializers.put(Character.TYPE, MiscCodec.instance);
        this.deserializers.put((Type)((Object)Character.class), MiscCodec.instance);
        this.deserializers.put(Byte.TYPE, NumberCodec.instance);
        this.deserializers.put((Type)((Object)Byte.class), NumberCodec.instance);
        this.deserializers.put(Short.TYPE, NumberCodec.instance);
        this.deserializers.put((Type)((Object)Short.class), NumberCodec.instance);
        this.deserializers.put(Integer.TYPE, IntegerCodec.instance);
        this.deserializers.put((Type)((Object)Integer.class), IntegerCodec.instance);
        this.deserializers.put(Long.TYPE, IntegerCodec.instance);
        this.deserializers.put((Type)((Object)Long.class), IntegerCodec.instance);
        this.deserializers.put((Type)((Object)BigInteger.class), BigDecimalCodec.instance);
        this.deserializers.put((Type)((Object)BigDecimal.class), BigDecimalCodec.instance);
        this.deserializers.put(Float.TYPE, NumberCodec.instance);
        this.deserializers.put((Type)((Object)Float.class), NumberCodec.instance);
        this.deserializers.put(Double.TYPE, NumberCodec.instance);
        this.deserializers.put((Type)((Object)Double.class), NumberCodec.instance);
        this.deserializers.put(Boolean.TYPE, BooleanCodec.instance);
        this.deserializers.put((Type)((Object)Boolean.class), BooleanCodec.instance);
        this.deserializers.put((Type)((Object)Class.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)char[].class), ArrayCodec.instance);
        this.deserializers.put((Type)((Object)Object[].class), ArrayCodec.instance);
        this.deserializers.put((Type)((Object)UUID.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)TimeZone.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Locale.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Currency.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)URI.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)URL.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Pattern.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Charset.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Number.class), NumberCodec.instance);
        this.deserializers.put((Type)((Object)StackTraceElement.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Serializable.class), JavaObjectDeserializer.instance);
        this.deserializers.put((Type)((Object)Cloneable.class), JavaObjectDeserializer.instance);
        this.deserializers.put((Type)((Object)Comparable.class), JavaObjectDeserializer.instance);
        this.deserializers.put((Type)((Object)Closeable.class), JavaObjectDeserializer.instance);
    }

    public ObjectDeserializer getDeserializer(Type type) {
        WildcardType wildcardType;
        Type[] upperBounds;
        ObjectDeserializer derializer = this.deserializers.get(type);
        if (derializer != null) {
            return derializer;
        }
        if (type instanceof Class) {
            return this.getDeserializer((Class)type, type);
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            if (rawType instanceof Class) {
                return this.getDeserializer((Class)rawType, type);
            }
            return this.getDeserializer(rawType);
        }
        if (type instanceof WildcardType && (upperBounds = (wildcardType = (WildcardType)type).getUpperBounds()).length == 1) {
            Type upperBoundType = upperBounds[0];
            return this.getDeserializer(upperBoundType);
        }
        return JavaObjectDeserializer.instance;
    }

    public ObjectDeserializer getDeserializer(Class<?> clazz, Type type) {
        String clazzName;
        Class<?> mappingTo;
        JSONType annotation;
        ObjectDeserializer deserializer = this.deserializers.get(type);
        if (deserializer != null) {
            return deserializer;
        }
        if (type == null) {
            type = clazz;
        }
        if ((deserializer = this.deserializers.get(type)) != null) {
            return deserializer;
        }
        if (!ParserConfig.isPrimitive(clazz) && (annotation = clazz.getAnnotation(JSONType.class)) != null && (mappingTo = annotation.mappingTo()) != Void.class) {
            return this.getDeserializer(mappingTo, mappingTo);
        }
        if (type instanceof WildcardType || type instanceof TypeVariable || type instanceof ParameterizedType) {
            deserializer = this.deserializers.get(clazz);
        }
        if (deserializer != null) {
            return deserializer;
        }
        deserializer = this.deserializers.get(type);
        if (deserializer != null) {
            return deserializer;
        }
        deserializer = clazz.isEnum() ? new EnumDeserializer(clazz) : (clazz.isArray() ? ArrayCodec.instance : (clazz == Set.class || clazz == HashSet.class || clazz == Collection.class || clazz == List.class || clazz == ArrayList.class ? CollectionCodec.instance : (Collection.class.isAssignableFrom(clazz) ? CollectionCodec.instance : (Map.class.isAssignableFrom(clazz) ? MapDeserializer.instance : (Throwable.class.isAssignableFrom(clazz) ? new ThrowableDeserializer(this, clazz) : ((clazzName = clazz.getName()).equals("android.net.Uri") ? MiscCodec.instance : new JavaBeanDeserializer(this, clazz, type)))))));
        this.putDeserializer(type, deserializer);
        return deserializer;
    }

    public ObjectDeserializer registerIfNotExists(Class<?> clazz) {
        return this.registerIfNotExists(clazz, clazz.getModifiers(), false, true, true, true);
    }

    public ObjectDeserializer registerIfNotExists(Class<?> clazz, int classModifiers, boolean fieldOnly, boolean jsonTypeSupport, boolean jsonFieldSupport, boolean fieldGenericSupport) {
        ObjectDeserializer deserializer = this.deserializers.get(clazz);
        if (deserializer != null) {
            return deserializer;
        }
        JavaBeanInfo beanInfo = JavaBeanInfo.build(clazz, classModifiers, clazz, fieldOnly, jsonTypeSupport, jsonFieldSupport, fieldGenericSupport, this.propertyNamingStrategy);
        deserializer = new JavaBeanDeserializer(this, clazz, clazz, beanInfo);
        this.putDeserializer(clazz, deserializer);
        return deserializer;
    }

    public boolean containsKey(Class clazz) {
        return this.deserializers.get(clazz) != null;
    }

    public FieldDeserializer createFieldDeserializer(ParserConfig mapping, Class<?> clazz, FieldInfo fieldInfo) {
        Class<?> fieldClass = fieldInfo.fieldClass;
        if (fieldClass == List.class || fieldClass == ArrayList.class || fieldClass.isArray() && !fieldClass.getComponentType().isPrimitive()) {
            return new ListTypeFieldDeserializer(mapping, clazz, fieldInfo);
        }
        return new DefaultFieldDeserializer(mapping, clazz, fieldInfo);
    }

    public void putDeserializer(Type type, ObjectDeserializer deserializer) {
        this.deserializers.put(type, deserializer);
    }

    public static boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == Boolean.class || clazz == Character.class || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == BigInteger.class || clazz == BigDecimal.class || clazz == String.class || clazz == java.util.Date.class || clazz == Date.class || clazz == Time.class || clazz == Timestamp.class;
    }

    public Class<?> checkAutoType(String typeName, Class<?> expectClass, int features) {
        long h3;
        if (typeName == null) {
            return null;
        }
        if (typeName.length() >= 128 || typeName.length() < 3) {
            throw new JSONException("autoType is not support. " + typeName);
        }
        long BASIC = -3750763034362895579L;
        long PRIME = 1099511628211L;
        long h1 = (0xCBF29CE484222325L ^ (long)typeName.charAt(0)) * 1099511628211L;
        if (h1 == -5808493101479473382L) {
            throw new JSONException("autoType is not support. " + typeName);
        }
        if ((h1 ^ (long)typeName.charAt(typeName.length() - 1)) * 1099511628211L == 655701488918567152L) {
            throw new JSONException("autoType is not support. " + typeName);
        }
        long hash = h3 = (((0xCBF29CE484222325L ^ (long)typeName.charAt(0)) * 1099511628211L ^ (long)typeName.charAt(1)) * 1099511628211L ^ (long)typeName.charAt(2)) * 1099511628211L;
        for (int i = 3; i < typeName.length(); ++i) {
            hash ^= (long)typeName.charAt(i);
            if (Arrays.binarySearch(denyList, hash *= 1099511628211L) < 0 || TypeUtils.getClassFromMapping(typeName) != null) continue;
            throw new JSONException("autoType is not support. " + typeName);
        }
        Class<?> clazz = TypeUtils.getClassFromMapping(typeName);
        if (clazz != null) {
            return clazz;
        }
        int mask = Feature.SupportAutoType.mask;
        if (((features & mask) != 0 || (JSON.DEFAULT_PARSER_FEATURE & mask) != 0 || this.autoTypeSupport) && (clazz = this.deserializers.findClass(typeName)) != null) {
            return clazz;
        }
        clazz = TypeUtils.loadClass(typeName, this.defaultClassLoader, false);
        if (clazz != null && expectClass != null && clazz != HashMap.class) {
            if (expectClass.isAssignableFrom(clazz)) {
                TypeUtils.addMapping(typeName, clazz);
                return clazz;
            }
            throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
        }
        if (clazz.isAnnotationPresent(JSONType.class)) {
            TypeUtils.addMapping(typeName, clazz);
            return clazz;
        }
        if ((features & mask) == 0 && (JSON.DEFAULT_PARSER_FEATURE & mask) == 0 && !this.autoTypeSupport) {
            throw new JSONException("autoType is not support : " + typeName);
        }
        TypeUtils.addMapping(typeName, clazz);
        return clazz;
    }
}

