/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONAware;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONStreamAware;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ExtraProcessor;
import com.alibaba.fastjson.parser.deserializer.ExtraTypeProvider;
import com.alibaba.fastjson.parser.deserializer.FieldTypeResolver;
import com.alibaba.fastjson.parser.deserializer.ParseProcess;
import com.alibaba.fastjson.serializer.AfterFilter;
import com.alibaba.fastjson.serializer.BeforeFilter;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.JavaBeanSerializer;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSON
implements JSONStreamAware,
JSONAware {
    public static TimeZone defaultTimeZone = TimeZone.getDefault();
    public static Locale defaultLocale = Locale.getDefault();
    public static final String DEFAULT_TYPE_KEY = "@type";
    public static int DEFAULT_PARSER_FEATURE;
    public static String DEFFAULT_DATE_FORMAT;
    public static int DEFAULT_GENERATE_FEATURE;
    public static final String VERSION = "1.1.66";

    public static final Object parse(String text) {
        return JSON.parse(text, DEFAULT_PARSER_FEATURE);
    }

    public static final Object parse(String text, int features) {
        if (text == null) {
            return null;
        }
        DefaultJSONParser parser = new DefaultJSONParser(text, ParserConfig.global, features);
        Object value = parser.parse(null);
        parser.handleResovleTask(value);
        parser.close();
        return value;
    }

    public static final Object parse(byte[] input, Feature ... features) {
        try {
            return JSON.parseObject(new String(input, "UTF-8"), features);
        }
        catch (UnsupportedEncodingException e) {
            throw new JSONException("UTF-8 not support", e);
        }
    }

    public static final Object parse(String text, Feature ... features) {
        int featureValues = DEFAULT_PARSER_FEATURE;
        for (Feature feature : features) {
            featureValues |= feature.mask;
        }
        return JSON.parse(text, featureValues);
    }

    public static final JSONObject parseObject(String text, Feature ... features) {
        boolean autoTypeSupport;
        Object obj = JSON.parse(text, features);
        if (obj instanceof JSONObject) {
            return (JSONObject)obj;
        }
        JSONObject jsonObject = (JSONObject)JSON.toJSON(obj);
        boolean bl = autoTypeSupport = (DEFAULT_PARSER_FEATURE & Feature.SupportAutoType.mask) != 0;
        if (!autoTypeSupport) {
            for (Feature feature : features) {
                if (feature != Feature.SupportAutoType) continue;
                autoTypeSupport = true;
            }
        }
        if (autoTypeSupport) {
            jsonObject.put(DEFAULT_TYPE_KEY, (Object)obj.getClass().getName());
        }
        return jsonObject;
    }

    public static final JSONObject parseObject(String text) {
        boolean autoTypeSupport;
        Object obj = JSON.parse(text);
        if (obj instanceof JSONObject || obj == null) {
            return (JSONObject)obj;
        }
        JSONObject jsonObject = (JSONObject)JSON.toJSON(obj);
        boolean bl = autoTypeSupport = (DEFAULT_PARSER_FEATURE & Feature.SupportAutoType.mask) != 0;
        if (autoTypeSupport) {
            jsonObject.put(DEFAULT_TYPE_KEY, (Object)obj.getClass().getName());
        }
        return jsonObject;
    }

    public static final <T> T parseObject(String text, TypeReference<T> type, Feature ... features) {
        return JSON.parseObject(text, type.type, ParserConfig.global, DEFAULT_PARSER_FEATURE, features);
    }

    public static final <T> T parseObject(String text, Class<T> clazz, Feature ... features) {
        return JSON.parseObject(text, clazz, ParserConfig.global, DEFAULT_PARSER_FEATURE, features);
    }

    public static final <T> T parseObject(String text, Class<T> clazz, ParseProcess processor, Feature ... features) {
        return JSON.parseObject(text, clazz, ParserConfig.global, processor, DEFAULT_PARSER_FEATURE, features);
    }

    public static final <T> T parseObject(String input, Type clazz, Feature ... features) {
        return JSON.parseObject(input, clazz, ParserConfig.global, DEFAULT_PARSER_FEATURE, features);
    }

    public static final <T> T parseObject(String input, Type clazz, ParseProcess processor, Feature ... features) {
        return JSON.parseObject(input, clazz, ParserConfig.global, processor, DEFAULT_PARSER_FEATURE, features);
    }

    public static final <T> T parseObject(String input, Type clazz, int featureValues, Feature ... features) {
        if (input == null) {
            return null;
        }
        for (Feature feature : features) {
            featureValues |= feature.mask;
        }
        DefaultJSONParser parser = new DefaultJSONParser(input, ParserConfig.global, featureValues);
        Object value = parser.parseObject(clazz);
        parser.handleResovleTask(value);
        parser.close();
        return value;
    }

    public static final <T> T parseObject(String input, Type clazz, ParserConfig config, int featureValues, Feature ... features) {
        return JSON.parseObject(input, clazz, config, null, featureValues, features);
    }

    public static final <T> T parseObject(String input, Type clazz, ParserConfig config, ParseProcess processor, int featureValues, Feature ... features) {
        if (input == null) {
            return null;
        }
        for (Feature feature : features) {
            featureValues |= feature.mask;
        }
        DefaultJSONParser parser = new DefaultJSONParser(input, config, featureValues);
        if (processor instanceof ExtraTypeProvider) {
            parser.getExtraTypeProviders().add((ExtraTypeProvider)processor);
        }
        if (processor instanceof ExtraProcessor) {
            parser.getExtraProcessors().add((ExtraProcessor)processor);
        }
        if (processor instanceof FieldTypeResolver) {
            parser.fieldTypeResolver = (FieldTypeResolver)processor;
        }
        Object value = parser.parseObject(clazz);
        parser.handleResovleTask(value);
        parser.close();
        return value;
    }

    public static final <T> T parseObject(byte[] input, Type clazz, Feature ... features) {
        try {
            return JSON.parseObject(new String(input, "UTF-8"), clazz, features);
        }
        catch (UnsupportedEncodingException e) {
            throw new JSONException("UTF-8 not support");
        }
    }

    public static final <T> T parseObject(char[] input, int length, Type clazz, Feature ... features) {
        if (input == null || input.length == 0) {
            return null;
        }
        int featureValues = DEFAULT_PARSER_FEATURE;
        for (Feature feature : features) {
            featureValues |= feature.mask;
        }
        DefaultJSONParser parser = new DefaultJSONParser(input, length, ParserConfig.global, featureValues);
        Object value = parser.parseObject(clazz);
        parser.handleResovleTask(value);
        parser.close();
        return value;
    }

    public static final <T> T parseObject(String text, Class<T> clazz) {
        return JSON.parseObject(text, clazz, new Feature[0]);
    }

    public static final JSONArray parseArray(String text) {
        return JSON.parseArray(text, new Feature[0]);
    }

    public static final JSONArray parseArray(String text, Feature ... features) {
        JSONArray array;
        if (text == null) {
            return null;
        }
        int featuresValue = DEFAULT_PARSER_FEATURE;
        for (int i = 0; i < features.length; ++i) {
            featuresValue |= features[i].mask;
        }
        DefaultJSONParser parser = new DefaultJSONParser(text, ParserConfig.global, featuresValue);
        JSONLexer lexer = parser.lexer;
        int token = lexer.token();
        if (token == 8) {
            lexer.nextToken();
            array = null;
        } else if (token == 20) {
            array = null;
        } else {
            array = new JSONArray();
            parser.parseArray(array);
            parser.handleResovleTask(array);
        }
        parser.close();
        return array;
    }

    public static final <T> List<T> parseArray(String text, Class<T> clazz) {
        ArrayList list;
        if (text == null) {
            return null;
        }
        DefaultJSONParser parser = new DefaultJSONParser(text, ParserConfig.global);
        JSONLexer lexer = parser.lexer;
        int token = lexer.token();
        if (token == 8) {
            lexer.nextToken();
            list = null;
        } else if (token == 20 && lexer.isBlankInput()) {
            list = null;
        } else {
            list = new ArrayList();
            parser.parseArray(clazz, list);
            parser.handleResovleTask(list);
        }
        parser.close();
        return list;
    }

    public static final List<Object> parseArray(String text, Type[] types) {
        if (text == null) {
            return null;
        }
        DefaultJSONParser parser = new DefaultJSONParser(text, ParserConfig.global);
        Object[] objectArray = parser.parseArray(types);
        List<Object> list = objectArray == null ? null : Arrays.asList(objectArray);
        parser.handleResovleTask(list);
        parser.close();
        return list;
    }

    public static Object parse(String text, ParserConfig config) {
        return JSON.parse(text, config, DEFAULT_PARSER_FEATURE);
    }

    public static Object parse(String text, ParserConfig config, Feature ... features) {
        int featuresValue = DEFAULT_PARSER_FEATURE;
        for (int i = 0; i < features.length; ++i) {
            featuresValue |= features[i].mask;
        }
        return JSON.parse(text, config, featuresValue);
    }

    public static Object parse(String text, ParserConfig config, int features) {
        if (text == null) {
            return null;
        }
        DefaultJSONParser parser = new DefaultJSONParser(text, config, features);
        Object value = parser.parse();
        parser.handleResovleTask(value);
        parser.close();
        return value;
    }

    public static final String toJSONString(Object object) {
        return JSON.toJSONString(object, SerializeConfig.globalInstance, null, null, DEFAULT_GENERATE_FEATURE, new SerializerFeature[0]);
    }

    public static final String toJSONString(Object object, SerializerFeature ... features) {
        return JSON.toJSONString(object, DEFAULT_GENERATE_FEATURE, features);
    }

    public static final String toJSONString(Object object, int defaultFeatures, SerializerFeature ... features) {
        return JSON.toJSONString(object, SerializeConfig.globalInstance, null, null, defaultFeatures, features);
    }

    public static final String toJSONStringWithDateFormat(Object object, String dateFormat, SerializerFeature ... features) {
        return JSON.toJSONString(object, SerializeConfig.globalInstance, null, dateFormat, DEFAULT_GENERATE_FEATURE, features);
    }

    public static final String toJSONString(Object object, SerializeFilter filter, SerializerFeature ... features) {
        return JSON.toJSONString(object, SerializeConfig.globalInstance, new SerializeFilter[]{filter}, null, DEFAULT_GENERATE_FEATURE, features);
    }

    public static final String toJSONString(Object object, SerializeFilter[] filters, SerializerFeature ... features) {
        return JSON.toJSONString(object, SerializeConfig.globalInstance, filters, null, DEFAULT_GENERATE_FEATURE, features);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] toJSONBytes(Object object, SerializerFeature ... features) {
        SerializeWriter out = new SerializeWriter((Writer)null, DEFAULT_GENERATE_FEATURE, features);
        try {
            JSONSerializer serializer = new JSONSerializer(out, SerializeConfig.globalInstance);
            serializer.write(object);
            byte[] byArray = out.toBytes("UTF-8");
            return byArray;
        }
        finally {
            out.close();
        }
    }

    public static final String toJSONString(Object object, SerializeConfig config, SerializerFeature ... features) {
        return JSON.toJSONString(object, config, null, null, DEFAULT_GENERATE_FEATURE, features);
    }

    public static final String toJSONString(Object object, SerializeConfig config, SerializeFilter filter, SerializerFeature ... features) {
        return JSON.toJSONString(object, config, new SerializeFilter[]{filter}, null, DEFAULT_GENERATE_FEATURE, features);
    }

    public static final String toJSONString(Object object, SerializeConfig config, SerializeFilter[] filters, SerializerFeature ... features) {
        return JSON.toJSONString(object, config, filters, null, DEFAULT_GENERATE_FEATURE, features);
    }

    public static final String toJSONStringZ(Object object, SerializeConfig mapping, SerializerFeature ... features) {
        return JSON.toJSONString(object, SerializeConfig.globalInstance, null, null, 0, features);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] toJSONBytes(Object object, SerializeConfig config, SerializerFeature ... features) {
        SerializeWriter out = new SerializeWriter((Writer)null, DEFAULT_GENERATE_FEATURE, features);
        try {
            JSONSerializer serializer = new JSONSerializer(out, config);
            serializer.write(object);
            byte[] byArray = out.toBytes("UTF-8");
            return byArray;
        }
        finally {
            out.close();
        }
    }

    public static final String toJSONString(Object object, boolean prettyFormat) {
        if (!prettyFormat) {
            return JSON.toJSONString(object);
        }
        return JSON.toJSONString(object, SerializerFeature.PrettyFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeJSONStringTo(Object object, Writer writer, SerializerFeature ... features) {
        SerializeWriter out = new SerializeWriter(writer, DEFAULT_GENERATE_FEATURE, features);
        try {
            JSONSerializer serializer = new JSONSerializer(out, SerializeConfig.globalInstance);
            serializer.write(object);
        }
        finally {
            out.close();
        }
    }

    public String toString() {
        return this.toJSONString();
    }

    @Override
    public String toJSONString() {
        SerializeWriter out = new SerializeWriter((Writer)null, DEFAULT_GENERATE_FEATURE, SerializerFeature.EMPTY);
        try {
            new JSONSerializer(out, SerializeConfig.globalInstance).write(this);
            String string = out.toString();
            return string;
        }
        finally {
            out.close();
        }
    }

    @Override
    public void writeJSONString(Appendable appendable) {
        SerializeWriter out = new SerializeWriter((Writer)null, DEFAULT_GENERATE_FEATURE, SerializerFeature.EMPTY);
        try {
            new JSONSerializer(out, SerializeConfig.globalInstance).write(this);
            appendable.append(out.toString());
        }
        catch (IOException e) {
            throw new JSONException(e.getMessage(), e);
        }
        finally {
            out.close();
        }
    }

    public static final Object toJSON(Object javaObject) {
        return JSON.toJSON(javaObject, SerializeConfig.globalInstance);
    }

    @Deprecated
    public static final Object toJSON(Object javaObject, ParserConfig mapping) {
        return JSON.toJSON(javaObject, SerializeConfig.globalInstance);
    }

    public static Object toJSON(Object javaObject, SerializeConfig config) {
        if (javaObject == null) {
            return null;
        }
        if (javaObject instanceof JSON) {
            return (JSON)javaObject;
        }
        if (javaObject instanceof Map) {
            Map map = (Map)javaObject;
            int size = map.size();
            AbstractMap innerMap = map instanceof LinkedHashMap ? new LinkedHashMap(size) : (map instanceof TreeMap ? new TreeMap() : new HashMap(size));
            JSONObject json = new JSONObject(innerMap);
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                String jsonKey = TypeUtils.castToString(key);
                Object jsonValue = JSON.toJSON(entry.getValue());
                json.put(jsonKey, jsonValue);
            }
            return json;
        }
        if (javaObject instanceof Collection) {
            Collection collection = (Collection)javaObject;
            JSONArray array = new JSONArray(collection.size());
            for (Object item : collection) {
                Object jsonValue = JSON.toJSON(item);
                array.add(jsonValue);
            }
            return array;
        }
        Class<?> clazz = javaObject.getClass();
        if (clazz.isEnum()) {
            return ((Enum)javaObject).name();
        }
        if (clazz.isArray()) {
            int len = Array.getLength(javaObject);
            JSONArray array = new JSONArray(len);
            for (int i = 0; i < len; ++i) {
                Object item = Array.get(javaObject, i);
                Object jsonValue = JSON.toJSON(item);
                array.add(jsonValue);
            }
            return array;
        }
        if (ParserConfig.isPrimitive(clazz)) {
            return javaObject;
        }
        ObjectSerializer serializer = config.get(clazz);
        if (serializer instanceof JavaBeanSerializer) {
            JavaBeanSerializer javaBeanSerializer = (JavaBeanSerializer)serializer;
            JSONObject json = new JSONObject();
            try {
                Map<String, Object> values = javaBeanSerializer.getFieldValuesMap(javaObject);
                for (Map.Entry<String, Object> entry : values.entrySet()) {
                    json.put(entry.getKey(), JSON.toJSON(entry.getValue()));
                }
            }
            catch (Exception e) {
                throw new JSONException("toJSON error", e);
            }
            return json;
        }
        return null;
    }

    public static final <T> T toJavaObject(JSON json, Class<T> clazz) {
        return TypeUtils.cast((Object)json, clazz, ParserConfig.global);
    }

    public <T> T toJavaObject(Class<T> clazz) {
        return TypeUtils.cast((Object)this, clazz, ParserConfig.getGlobalInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toJSONString(Object object, SerializeConfig config, SerializeFilter[] filters, String dateFormat, int defaultFeatures, SerializerFeature ... features) {
        SerializeWriter out = new SerializeWriter(null, defaultFeatures, features);
        try {
            JSONSerializer serializer = new JSONSerializer(out, config);
            for (SerializerFeature serializerFeature : features) {
                serializer.config(serializerFeature, true);
            }
            if (dateFormat != null && dateFormat.length() != 0) {
                serializer.setDateFormat(dateFormat);
                serializer.config(SerializerFeature.WriteDateUseDateFormat, true);
            }
            if (filters != null) {
                for (SerializeFilter serializeFilter : filters) {
                    if (serializeFilter == null) continue;
                    if (serializeFilter instanceof PropertyPreFilter) {
                        serializer.getPropertyPreFilters().add((PropertyPreFilter)serializeFilter);
                    }
                    if (serializeFilter instanceof NameFilter) {
                        serializer.getNameFilters().add((NameFilter)serializeFilter);
                    }
                    if (serializeFilter instanceof ValueFilter) {
                        serializer.getValueFilters().add((ValueFilter)serializeFilter);
                    }
                    if (serializeFilter instanceof PropertyFilter) {
                        serializer.getPropertyFilters().add((PropertyFilter)serializeFilter);
                    }
                    if (serializeFilter instanceof BeforeFilter) {
                        serializer.getBeforeFilters().add((BeforeFilter)serializeFilter);
                    }
                    if (!(serializeFilter instanceof AfterFilter)) continue;
                    serializer.getAfterFilters().add((AfterFilter)serializeFilter);
                }
            }
            serializer.write(object);
            String string = out.toString();
            return string;
        }
        finally {
            out.close();
        }
    }

    static {
        int features = 0;
        features |= Feature.UseBigDecimal.mask;
        features |= Feature.SortFeidFastMatch.mask;
        DEFAULT_PARSER_FEATURE = features |= Feature.IgnoreNotMatch.mask;
        DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
        features = 0;
        features |= SerializerFeature.QuoteFieldNames.mask;
        features |= SerializerFeature.SkipTransientField.mask;
        features |= SerializerFeature.WriteEnumUsingToString.mask;
        DEFAULT_GENERATE_FEATURE = features |= SerializerFeature.SortField.mask;
    }
}

