/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.serializer.AfterFilter;
import com.alibaba.fastjson.serializer.BeforeFilter;
import com.alibaba.fastjson.serializer.FieldSerializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanSerializer
implements ObjectSerializer {
    private static final char[] true_chars = new char[]{'t', 'r', 'u', 'e'};
    private static final char[] false_chars = new char[]{'f', 'a', 'l', 's', 'e'};
    private final FieldSerializer[] getters;
    private final FieldSerializer[] sortedGetters;
    protected int features = 0;
    protected final String typeName;
    protected final String typeKey;

    public JavaBeanSerializer(Class<?> clazz) {
        this(clazz, (PropertyNamingStrategy)null);
    }

    public JavaBeanSerializer(Class<?> clazz, PropertyNamingStrategy propertyNamingStrategy) {
        this(clazz, clazz.getModifiers(), (Map<String, String>)null, false, true, true, true, propertyNamingStrategy);
    }

    public JavaBeanSerializer(Class<?> clazz, String ... aliasList) {
        this(clazz, clazz.getModifiers(), JavaBeanSerializer.map(aliasList), false, true, true, true, null);
    }

    private static Map<String, String> map(String ... aliasList) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        for (String alias : aliasList) {
            aliasMap.put(alias, alias);
        }
        return aliasMap;
    }

    public JavaBeanSerializer(Class<?> clazz, int classModifiers, Map<String, String> aliasMap, boolean fieldOnly, boolean jsonTypeSupport, boolean jsonFieldSupport, boolean fieldGenericSupport, PropertyNamingStrategy propertyNamingStrategy) {
        JSONType jsonType = jsonTypeSupport ? clazz.getAnnotation(JSONType.class) : null;
        String typeName = null;
        String typeKey = null;
        if (jsonType != null) {
            this.features = SerializerFeature.of(jsonType.serialzeFeatures());
            typeName = jsonType.typeName();
            if (typeName.length() == 0) {
                typeName = null;
            } else {
                Class<?> interfaceClass;
                JSONType superJsonType;
                JSONType superJsonType22;
                Object supperClass;
                for (supperClass = clazz.getSuperclass(); supperClass != null && supperClass != Object.class && (superJsonType22 = supperClass.getAnnotation(JSONType.class)) != null && (typeKey = superJsonType22.typeKey()).length() == 0; supperClass = supperClass.getSuperclass()) {
                }
                supperClass = clazz.getInterfaces();
                int superJsonType22 = ((Class<?>[])supperClass).length;
                for (int i = 0; i < superJsonType22 && ((superJsonType = (interfaceClass = supperClass[i]).getAnnotation(JSONType.class)) == null || (typeKey = superJsonType.typeKey()).length() == 0); ++i) {
                }
                if (typeKey != null && typeKey.length() == 0) {
                    typeKey = null;
                }
            }
        }
        this.typeName = typeName;
        this.typeKey = typeKey;
        List<FieldInfo> fieldInfoList = TypeUtils.computeGetters(clazz, classModifiers, fieldOnly, jsonType, aliasMap, false, jsonFieldSupport, fieldGenericSupport, propertyNamingStrategy);
        ArrayList<FieldSerializer> getterList = new ArrayList<FieldSerializer>();
        for (FieldInfo fieldInfo : fieldInfoList) {
            FieldSerializer fieldDeser = new FieldSerializer(fieldInfo);
            getterList.add(fieldDeser);
        }
        this.getters = getterList.toArray(new FieldSerializer[getterList.size()]);
        String[] orders = null;
        if (jsonType != null) {
            orders = jsonType.orders();
        }
        if (orders != null && orders.length != 0) {
            List<FieldInfo> fieldInfoList2 = TypeUtils.computeGetters(clazz, classModifiers, fieldOnly, jsonType, aliasMap, true, jsonFieldSupport, fieldGenericSupport, propertyNamingStrategy);
            ArrayList<FieldSerializer> getterList2 = new ArrayList<FieldSerializer>();
            for (FieldInfo fieldInfo : fieldInfoList2) {
                FieldSerializer fieldDeser = new FieldSerializer(fieldInfo);
                getterList2.add(fieldDeser);
            }
            this.sortedGetters = getterList2.toArray(new FieldSerializer[getterList2.size()]);
        } else {
            Object[] sortedGetters = new FieldSerializer[this.getters.length];
            System.arraycopy(this.getters, 0, sortedGetters, 0, this.getters.length);
            Arrays.sort(sortedGetters);
            this.sortedGetters = Arrays.equals(sortedGetters, this.getters) ? this.getters : sortedGetters;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull();
            return;
        }
        if ((serializer.context == null || (serializer.context.features & SerializerFeature.DisableCircularReferenceDetect.mask) == 0) && serializer.references != null && serializer.references.containsKey(object)) {
            serializer.writeReference(object);
            return;
        }
        FieldSerializer[] getters = (out.features & SerializerFeature.SortField.mask) != 0 ? this.sortedGetters : this.getters;
        SerialContext parent = serializer.context;
        if ((out.features & SerializerFeature.DisableCircularReferenceDetect.mask) == 0) {
            serializer.context = new SerialContext(parent, object, fieldName, this.features);
            if (serializer.references == null) {
                serializer.references = new IdentityHashMap();
            }
            serializer.references.put(object, serializer.context);
        }
        boolean writeAsArray = (this.features & SerializerFeature.BeanToArray.mask) != 0 || (out.features & SerializerFeature.BeanToArray.mask) != 0;
        try {
            int newcount;
            char seperator;
            Class<?> objClass;
            boolean isWriteClassName;
            int startSeperator = writeAsArray ? 91 : 123;
            int endSeperator = writeAsArray ? 93 : 125;
            int newcount2 = out.count + 1;
            if (newcount2 > out.buf.length) {
                if (out.writer == null) {
                    out.expandCapacity(newcount2);
                } else {
                    out.flush();
                    newcount2 = 1;
                }
            }
            out.buf[out.count] = startSeperator;
            out.count = newcount2;
            if (getters.length > 0 && (out.features & SerializerFeature.PrettyFormat.mask) != 0) {
                serializer.incrementIndent();
                serializer.println();
            }
            boolean commaFlag = false;
            boolean bl = isWriteClassName = (this.features & SerializerFeature.WriteClassName.mask) != 0 || (out.features & SerializerFeature.WriteClassName.mask) != 0 && (fieldType != null || (out.features & SerializerFeature.NotWriteRootClassName.mask) == 0 || serializer.context != null && serializer.context.parent != null);
            if (isWriteClassName && (objClass = object.getClass()) != fieldType) {
                out.writeFieldName(this.typeKey != null ? this.typeKey : serializer.config.typeKey, false);
                String typeName = this.typeName;
                if (typeName == null) {
                    typeName = object.getClass().getName();
                }
                serializer.write(typeName);
                commaFlag = true;
            }
            char newSeperator = seperator = commaFlag ? (char)',' : '\u0000';
            if (serializer.beforeFilters != null) {
                for (BeforeFilter beforeFilter : serializer.beforeFilters) {
                    newSeperator = beforeFilter.writeBefore(serializer, object, newSeperator);
                }
            }
            commaFlag = newSeperator == ',';
            boolean directWritePrefix = (out.features & SerializerFeature.QuoteFieldNames.mask) != 0 && (out.features & SerializerFeature.UseSingleQuotes.mask) == 0;
            boolean useSingleQuote = (out.features & SerializerFeature.UseSingleQuotes.mask) != 0;
            boolean notWriteDefaultValue = (out.features & SerializerFeature.NotWriteDefaultValue.mask) != 0;
            List<PropertyFilter> propertyFilters = serializer.propertyFilters;
            List<NameFilter> nameFilters = serializer.nameFilters;
            List<ValueFilter> valueFilters = serializer.valueFilters;
            List<PropertyPreFilter> filters = serializer.propertyPreFilters;
            for (int i = 0; i < getters.length; ++i) {
                void var37_52;
                Field field;
                FieldSerializer fieldSerializer = getters[i];
                FieldInfo fieldInfo = fieldSerializer.fieldInfo;
                Class<?> fieldClass = fieldInfo.fieldClass;
                String fieldInfoName = fieldInfo.name;
                if ((out.features & SerializerFeature.SkipTransientField.mask) != 0 && (field = fieldInfo.field) != null && fieldInfo.fieldTransient || this.typeKey != null && this.typeKey.equals(fieldInfoName)) continue;
                boolean applyName = true;
                if (filters != null) {
                    for (PropertyPreFilter filter : filters) {
                        if (filter.apply(serializer, object, fieldInfoName)) continue;
                        applyName = false;
                        break;
                    }
                }
                if (!applyName) continue;
                Object propertyValue = null;
                int propertyValueInt = 0;
                long propertyValueLong = 0L;
                boolean propertyValueBoolean = false;
                boolean propertyValueGot = false;
                boolean valueGot = false;
                if (fieldInfo.fieldAccess) {
                    if (fieldClass == Integer.TYPE) {
                        propertyValueInt = fieldInfo.field.getInt(object);
                        valueGot = true;
                    } else if (fieldClass == Long.TYPE) {
                        propertyValueLong = fieldInfo.field.getLong(object);
                        valueGot = true;
                    } else if (fieldClass == Boolean.TYPE) {
                        propertyValueBoolean = fieldInfo.field.getBoolean(object);
                        valueGot = true;
                    } else {
                        propertyValue = fieldInfo.field.get(object);
                        propertyValueGot = true;
                    }
                } else {
                    propertyValue = fieldSerializer.getPropertyValue(object);
                    propertyValueGot = true;
                }
                boolean apply = true;
                if (propertyFilters != null) {
                    if (valueGot) {
                        if (fieldClass == Integer.TYPE) {
                            propertyValue = propertyValueInt;
                            propertyValueGot = true;
                        } else if (fieldClass == Long.TYPE) {
                            propertyValue = propertyValueLong;
                            propertyValueGot = true;
                        } else if (fieldClass == Boolean.TYPE) {
                            propertyValue = propertyValueBoolean;
                            propertyValueGot = true;
                        }
                    }
                    for (PropertyFilter propertyFilter : propertyFilters) {
                        if (propertyFilter.apply(object, fieldInfoName, propertyValue)) continue;
                        apply = false;
                        break;
                    }
                }
                if (!apply) continue;
                String key = fieldInfoName;
                if (nameFilters != null) {
                    if (valueGot && !propertyValueGot) {
                        if (fieldClass == Integer.TYPE) {
                            propertyValue = propertyValueInt;
                            propertyValueGot = true;
                        } else if (fieldClass == Long.TYPE) {
                            propertyValue = propertyValueLong;
                            propertyValueGot = true;
                        } else if (fieldClass == Boolean.TYPE) {
                            propertyValue = propertyValueBoolean;
                            propertyValueGot = true;
                        }
                    }
                    for (Object nameFilter : nameFilters) {
                        key = nameFilter.process(object, key, propertyValue);
                    }
                }
                Object object2 = propertyValue;
                if (valueFilters != null) {
                    Object nameFilter;
                    if (valueGot && !propertyValueGot) {
                        if (fieldClass == Integer.TYPE) {
                            Object object3 = propertyValue = Integer.valueOf(propertyValueInt);
                            propertyValueGot = true;
                        } else if (fieldClass == Long.TYPE) {
                            Object object4 = propertyValue = Long.valueOf(propertyValueLong);
                            propertyValueGot = true;
                        } else if (fieldClass == Boolean.TYPE) {
                            Object object5 = propertyValue = Boolean.valueOf(propertyValueBoolean);
                            propertyValueGot = true;
                        }
                    }
                    nameFilter = valueFilters.iterator();
                    while (nameFilter.hasNext()) {
                        ValueFilter valueFilter = (ValueFilter)nameFilter.next();
                        propertyValue = valueFilter.process(object, fieldInfoName, propertyValue);
                    }
                }
                if (propertyValueGot && propertyValue == null && !writeAsArray && !fieldSerializer.writeNull && (out.features & SerializerFeature.WriteMapNullValue.mask) == 0 || propertyValueGot && propertyValue != null && notWriteDefaultValue && ((fieldClass == Byte.TYPE || fieldClass == Short.TYPE || fieldClass == Integer.TYPE || fieldClass == Long.TYPE || fieldClass == Float.TYPE || fieldClass == Double.TYPE) && propertyValue instanceof Number && ((Number)propertyValue).byteValue() == 0 || fieldClass == Boolean.TYPE && propertyValue instanceof Boolean && !((Boolean)propertyValue).booleanValue())) continue;
                if (commaFlag) {
                    int newcount3 = out.count + 1;
                    if (newcount3 > out.buf.length) {
                        if (out.writer == null) {
                            out.expandCapacity(newcount3);
                        } else {
                            out.flush();
                            newcount3 = 1;
                        }
                    }
                    out.buf[out.count] = 44;
                    out.count = newcount3;
                    if ((out.features & SerializerFeature.PrettyFormat.mask) != 0) {
                        serializer.println();
                    }
                }
                if (key != fieldInfoName) {
                    if (!writeAsArray) {
                        out.writeFieldName(key, true);
                    }
                    serializer.write(propertyValue);
                } else if (var37_52 != propertyValue) {
                    if (!writeAsArray) {
                        fieldSerializer.writePrefix(serializer);
                    }
                    serializer.write(propertyValue);
                } else {
                    if (!writeAsArray) {
                        if (directWritePrefix) {
                            char[] c = fieldSerializer.name_chars;
                            int off = 0;
                            int len = c.length;
                            int newcount4 = out.count + len;
                            if (newcount4 > out.buf.length) {
                                if (out.writer == null) {
                                    out.expandCapacity(newcount4);
                                } else {
                                    int rest;
                                    do {
                                        rest = out.buf.length - out.count;
                                        System.arraycopy(c, off, out.buf, out.count, rest);
                                        out.count = out.buf.length;
                                        out.flush();
                                        off += rest;
                                    } while ((len -= rest) > out.buf.length);
                                    newcount4 = len;
                                }
                            }
                            System.arraycopy(c, off, out.buf, out.count, len);
                            out.count = newcount4;
                        } else {
                            fieldSerializer.writePrefix(serializer);
                        }
                    }
                    if (valueGot && !propertyValueGot) {
                        if (fieldClass == Integer.TYPE) {
                            if (propertyValueInt == Integer.MIN_VALUE) {
                                out.write("-2147483648");
                            } else {
                                int x = propertyValueInt < 0 ? -propertyValueInt : propertyValueInt;
                                int j = 0;
                                while (true) {
                                    if (x <= SerializeWriter.sizeTable[j]) break;
                                    ++j;
                                }
                                int size = j + 1;
                                if (propertyValueInt < 0) {
                                    ++size;
                                }
                                boolean flushed = false;
                                int newcount3 = out.count + size;
                                if (newcount3 > out.buf.length) {
                                    if (out.writer == null) {
                                        out.expandCapacity(newcount3);
                                    } else {
                                        char[] chars = new char[size];
                                        SerializeWriter.getChars(propertyValueInt, size, chars);
                                        out.write(chars, 0, chars.length);
                                        flushed = true;
                                    }
                                }
                                if (!flushed) {
                                    SerializeWriter.getChars(propertyValueInt, newcount3, out.buf);
                                    out.count = newcount3;
                                }
                            }
                        } else if (fieldClass == Long.TYPE) {
                            serializer.out.writeLong(propertyValueLong);
                        } else if (fieldClass == Boolean.TYPE) {
                            if (propertyValueBoolean) {
                                serializer.out.write(true_chars, 0, true_chars.length);
                            } else {
                                serializer.out.write(false_chars, 0, false_chars.length);
                            }
                        }
                    } else if (!writeAsArray) {
                        if (fieldClass == String.class) {
                            if (propertyValue == null) {
                                if ((out.features & SerializerFeature.WriteNullStringAsEmpty.mask) != 0 || (fieldSerializer.features & SerializerFeature.WriteNullStringAsEmpty.mask) != 0) {
                                    out.writeString("");
                                } else {
                                    out.writeNull();
                                }
                            } else {
                                String propertyValueString = (String)propertyValue;
                                if (useSingleQuote) {
                                    out.writeStringWithSingleQuote(propertyValueString);
                                } else {
                                    out.writeStringWithDoubleQuote(propertyValueString, '\u0000', true);
                                }
                            }
                        } else if (fieldInfo.isEnum) {
                            if (propertyValue != null) {
                                if ((out.features & SerializerFeature.WriteEnumUsingToString.mask) != 0) {
                                    boolean userSingleQuote;
                                    Enum e = (Enum)propertyValue;
                                    String name = e.toString();
                                    boolean bl2 = userSingleQuote = (out.features & SerializerFeature.UseSingleQuotes.mask) != 0;
                                    if (userSingleQuote) {
                                        out.writeStringWithSingleQuote(name);
                                    } else {
                                        out.writeStringWithDoubleQuote(name, '\u0000', false);
                                    }
                                } else {
                                    Enum e = (Enum)propertyValue;
                                    out.writeInt(e.ordinal());
                                }
                            } else {
                                out.writeNull();
                            }
                        } else {
                            fieldSerializer.writeValue(serializer, propertyValue);
                        }
                    } else {
                        fieldSerializer.writeValue(serializer, propertyValue);
                    }
                }
                commaFlag = true;
            }
            if (serializer.afterFilters != null) {
                char afterOperator = commaFlag ? (char)',' : '\u0000';
                for (AfterFilter afterFilter : serializer.afterFilters) {
                    afterOperator = afterFilter.writeAfter(serializer, object, afterOperator);
                }
            }
            if (getters.length > 0 && (out.features & SerializerFeature.PrettyFormat.mask) != 0) {
                serializer.decrementIdent();
                serializer.println();
            }
            if ((newcount = out.count + 1) > out.buf.length) {
                if (out.writer == null) {
                    out.expandCapacity(newcount);
                } else {
                    out.flush();
                    newcount = 1;
                }
            }
            out.buf[out.count] = endSeperator;
            out.count = newcount;
        }
        catch (Exception e) {
            String errorMessage = "write javaBean error";
            if (fieldName != null) {
                errorMessage = errorMessage + ", fieldName : " + fieldName;
            }
            throw new JSONException(errorMessage, e);
        }
        finally {
            serializer.context = parent;
        }
    }

    public Map<String, Object> getFieldValuesMap(Object object) throws Exception {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(this.sortedGetters.length);
        for (FieldSerializer getter : this.sortedGetters) {
            map.put(getter.fieldInfo.name, getter.getPropertyValue(object));
        }
        return map;
    }
}

