/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONCreator;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaBeanInfo {
    final Constructor<?> defaultConstructor;
    final int defaultConstructorParameterSize;
    final Constructor<?> creatorConstructor;
    final Method factoryMethod;
    final FieldInfo[] fields;
    final FieldInfo[] sortedFields;
    final JSONType jsonType;
    boolean ordered = false;
    final boolean supportBeanToArray;
    public final String typeName;
    public final String typeKey;
    public final int parserFeatures;

    JavaBeanInfo(Class<?> clazz, Constructor<?> defaultConstructor, Constructor<?> creatorConstructor, Method factoryMethod, FieldInfo[] fields, FieldInfo[] sortedFields, JSONType jsonType) {
        this.defaultConstructor = defaultConstructor;
        this.creatorConstructor = creatorConstructor;
        this.factoryMethod = factoryMethod;
        this.fields = fields;
        this.jsonType = jsonType;
        int parserFeatures = 0;
        if (jsonType != null) {
            String typeName = jsonType.typeName();
            this.typeName = typeName.length() > 0 ? typeName : clazz.getName();
            String typeKey = jsonType.typeKey();
            this.typeKey = typeKey.length() > 0 ? typeKey : null;
            Feature[] featureArray = jsonType.parseFeatures();
            int n = featureArray.length;
            for (int i = 0; i < n; ++i) {
                Feature feature = featureArray[i];
                parserFeatures |= feature.mask;
            }
        } else {
            this.typeName = clazz.getName();
            this.typeKey = null;
        }
        this.parserFeatures = parserFeatures;
        boolean supportBeanToArray = false;
        if (jsonType != null) {
            for (Feature feature : jsonType.parseFeatures()) {
                if (feature != Feature.SupportArrayToBean) continue;
                supportBeanToArray = true;
            }
        }
        this.supportBeanToArray = supportBeanToArray;
        FieldInfo[] fieldInfoArray = this.sortedFields = Arrays.equals(fields, sortedFields = this.computeSortedFields(fields, sortedFields)) ? fields : sortedFields;
        this.defaultConstructorParameterSize = defaultConstructor != null ? defaultConstructor.getParameterTypes().length : (factoryMethod != null ? factoryMethod.getParameterTypes().length : 0);
    }

    private FieldInfo[] computeSortedFields(FieldInfo[] fields, FieldInfo[] sortedFields) {
        if (this.jsonType == null) {
            return sortedFields;
        }
        String[] orders = this.jsonType.orders();
        if (orders != null && orders.length != 0) {
            int i;
            int i2;
            int j;
            boolean containsAll = true;
            for (int i3 = 0; i3 < orders.length; ++i3) {
                boolean got = false;
                for (j = 0; j < sortedFields.length; ++j) {
                    if (!sortedFields[j].name.equals(orders[i3])) continue;
                    got = true;
                    break;
                }
                if (got) continue;
                containsAll = false;
                break;
            }
            if (!containsAll) {
                return sortedFields;
            }
            if (orders.length == fields.length) {
                boolean orderMatch = true;
                for (i2 = 0; i2 < orders.length; ++i2) {
                    if (sortedFields[i2].name.equals(orders[i2])) continue;
                    orderMatch = false;
                    break;
                }
                if (orderMatch) {
                    return sortedFields;
                }
                FieldInfo[] newSortedFields = new FieldInfo[sortedFields.length];
                block3: for (i = 0; i < orders.length; ++i) {
                    for (int j2 = 0; j2 < sortedFields.length; ++j2) {
                        if (!sortedFields[j2].name.equals(orders[i])) continue;
                        newSortedFields[i] = sortedFields[j2];
                        continue block3;
                    }
                }
                sortedFields = newSortedFields;
                this.ordered = true;
                return newSortedFields;
            }
            FieldInfo[] newSortedFields = new FieldInfo[sortedFields.length];
            block5: for (i2 = 0; i2 < orders.length; ++i2) {
                for (j = 0; j < sortedFields.length; ++j) {
                    if (!sortedFields[j].name.equals(orders[i2])) continue;
                    newSortedFields[i2] = sortedFields[j];
                    continue block5;
                }
            }
            int fieldIndex = orders.length;
            for (i = 0; i < sortedFields.length; ++i) {
                boolean contains = false;
                for (int j3 = 0; j3 < newSortedFields.length && j3 < fieldIndex; ++j3) {
                    if (!newSortedFields[i].equals(sortedFields[j3])) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                newSortedFields[fieldIndex] = sortedFields[i];
                ++fieldIndex;
            }
            this.ordered = true;
        }
        return sortedFields;
    }

    static boolean addField(List<FieldInfo> fields, FieldInfo field, boolean fieldOnly) {
        if (!fieldOnly) {
            int size = fields.size();
            for (int i = 0; i < size; ++i) {
                FieldInfo item = fields.get(i);
                if (!item.name.equals(field.name) || item.getOnly && !field.getOnly) continue;
                return false;
            }
        }
        fields.add(field);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static JavaBeanInfo build(Class<?> clazz, int classModifiers, Type type, boolean fieldOnly, boolean jsonTypeSupport, boolean jsonFieldSupport, boolean fieldGenericSupport, PropertyNamingStrategy propertyNamingStrategy) {
        void var18_31;
        void var20_59;
        boolean isInterfaceOrAbstract;
        Method[] methods;
        ArrayList<FieldInfo> fieldList = new ArrayList<FieldInfo>();
        HashMap classFieldCache = new HashMap();
        Constructor<?> defaultConstructor = null;
        if ((classModifiers & 0x400) == 0) {
            try {
                defaultConstructor = clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (defaultConstructor == null && clazz.isMemberClass() && (classModifiers & 8) == 0) {
                for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                    Class<?>[] parameterTypes = constructor.getParameterTypes();
                    if (parameterTypes.length != 1 || !parameterTypes[0].equals(clazz.getDeclaringClass())) continue;
                    defaultConstructor = constructor;
                    break;
                }
            }
        }
        Executable creatorConstructor = null;
        Executable factoryMethod = null;
        if (fieldOnly) {
            methods = null;
        } else {
            ArrayList<Executable> methodList = new ArrayList<Executable>();
            for (Class<?> cls = clazz; cls != null && cls != Object.class; cls = cls.getSuperclass()) {
                Method[] declaredMethods = cls.getDeclaredMethods();
                for (Executable executable : declaredMethods) {
                    int modifier = ((Method)executable).getModifiers();
                    if ((modifier & 8) != 0) {
                        if (!executable.isAnnotationPresent(JSONCreator.class)) continue;
                        if (factoryMethod != null) {
                            throw new JSONException("multi-json creator");
                        }
                        factoryMethod = executable;
                        continue;
                    }
                    if ((modifier & 2) != 0 || (modifier & 0x100) != 0 || (modifier & 4) != 0) continue;
                    methodList.add(executable);
                }
            }
            methods = new Method[methodList.size()];
            methodList.toArray(methods);
        }
        Field[] declaredFields = clazz.getDeclaredFields();
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        boolean bl = isInterfaceOrAbstract = clazz.isInterface() || (classModifiers & 0x400) != 0;
        if (defaultConstructor == null || isInterfaceOrAbstract) {
            Class<?>[] parameterTypes;
            creatorConstructor = null;
            for (Executable executable : constructors) {
                JSONCreator annotation = ((Constructor)executable).getAnnotation(JSONCreator.class);
                if (annotation == null) continue;
                if (creatorConstructor != null) {
                    throw new JSONException("multi-json creator");
                }
                creatorConstructor = executable;
                break;
            }
            if (creatorConstructor != null) {
                void var20_50;
                TypeUtils.setAccessible(clazz, creatorConstructor, classModifiers);
                parameterTypes = ((Constructor)creatorConstructor).getParameterTypes();
                Type[] typeArray = fieldGenericSupport ? ((Constructor)creatorConstructor).getGenericParameterTypes() : parameterTypes;
                Annotation[][] paramAnnotationArrays = ((Constructor)creatorConstructor).getParameterAnnotations();
                boolean bl2 = false;
                while (var20_50 < parameterTypes.length) {
                    Annotation[] paramAnnotations = paramAnnotationArrays[var20_50];
                    JSONField fieldAnnotation = null;
                    for (Annotation paramAnnotation : paramAnnotations) {
                        if (!(paramAnnotation instanceof JSONField)) continue;
                        fieldAnnotation = (JSONField)paramAnnotation;
                        break;
                    }
                    if (fieldAnnotation == null) {
                        throw new JSONException("illegal json creator");
                    }
                    Class<?> clazz2 = parameterTypes[var20_50];
                    Type fieldType = typeArray[var20_50];
                    Field field = TypeUtils.getField(clazz, fieldAnnotation.name(), declaredFields, classFieldCache);
                    if (field != null) {
                        TypeUtils.setAccessible(clazz, field, classModifiers);
                    }
                    int ordinal = fieldAnnotation.ordinal();
                    int serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                    FieldInfo fieldInfo = new FieldInfo(fieldAnnotation.name(), clazz, clazz2, fieldType, field, ordinal, serialzeFeatures);
                    JavaBeanInfo.addField(fieldList, fieldInfo, fieldOnly);
                    ++var20_50;
                }
                FieldInfo[] fieldInfoArray = new FieldInfo[fieldList.size()];
                fieldList.toArray(fieldInfoArray);
                Object[] sortedFields = new FieldInfo[fieldInfoArray.length];
                System.arraycopy(fieldInfoArray, 0, sortedFields, 0, fieldInfoArray.length);
                Arrays.sort(sortedFields);
                JSONType jsonType = jsonTypeSupport ? clazz.getAnnotation(JSONType.class) : null;
                return new JavaBeanInfo(clazz, null, (Constructor<?>)creatorConstructor, null, fieldInfoArray, (FieldInfo[])sortedFields, jsonType);
            }
            if (factoryMethod != null) {
                TypeUtils.setAccessible(clazz, factoryMethod, classModifiers);
                parameterTypes = ((Method)factoryMethod).getParameterTypes();
                if (parameterTypes.length > 0) {
                    void var20_53;
                    Type[] typeArray = fieldGenericSupport ? ((Method)factoryMethod).getGenericParameterTypes() : parameterTypes;
                    Annotation[][] paramAnnotationArrays = ((Method)factoryMethod).getParameterAnnotations();
                    boolean bl3 = false;
                    while (var20_53 < parameterTypes.length) {
                        Annotation[] paramAnnotations = paramAnnotationArrays[var20_53];
                        JSONField fieldAnnotation = null;
                        for (Annotation paramAnnotation : paramAnnotations) {
                            if (!(paramAnnotation instanceof JSONField)) continue;
                            fieldAnnotation = (JSONField)paramAnnotation;
                            break;
                        }
                        if (fieldAnnotation == null) {
                            throw new JSONException("illegal json creator");
                        }
                        Class<?> clazz3 = parameterTypes[var20_53];
                        Type fieldType = typeArray[var20_53];
                        Field field = TypeUtils.getField(clazz, fieldAnnotation.name(), declaredFields, classFieldCache);
                        int ordinal = fieldAnnotation.ordinal();
                        int serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                        FieldInfo fieldInfo = new FieldInfo(fieldAnnotation.name(), clazz, clazz3, fieldType, field, ordinal, serialzeFeatures);
                        JavaBeanInfo.addField(fieldList, fieldInfo, fieldOnly);
                        ++var20_53;
                    }
                    Object[] objectArray = new FieldInfo[fieldList.size()];
                    fieldList.toArray(objectArray);
                    Object[] sortedFields = new FieldInfo[objectArray.length];
                    System.arraycopy(objectArray, 0, sortedFields, 0, objectArray.length);
                    Arrays.sort(sortedFields);
                    if (Arrays.equals(objectArray, sortedFields)) {
                        sortedFields = objectArray;
                    }
                    JSONType jsonType = jsonTypeSupport ? clazz.getAnnotation(JSONType.class) : null;
                    JavaBeanInfo javaBeanInfo = new JavaBeanInfo(clazz, null, null, (Method)factoryMethod, (FieldInfo[])objectArray, (FieldInfo[])sortedFields, jsonType);
                    return javaBeanInfo;
                }
            } else if (!isInterfaceOrAbstract) {
                String[] stringArray;
                boolean kotlin = TypeUtils.isKotlin(clazz);
                if (kotlin && constructors.length > 0 && (stringArray = TypeUtils.getKoltinConstructorParameters(clazz)) != null) {
                    creatorConstructor = constructors[constructors.length - 1];
                    ((Constructor)creatorConstructor).setAccessible(true);
                    TypeUtils.setAccessible(clazz, creatorConstructor, classModifiers);
                    Class<?>[] parameterTypes2 = ((Constructor)creatorConstructor).getParameterTypes();
                    Type[] typeArray = fieldGenericSupport ? ((Constructor)creatorConstructor).getGenericParameterTypes() : parameterTypes2;
                    Annotation[][] paramAnnotationArrays = ((Constructor)creatorConstructor).getParameterAnnotations();
                    for (int i = 0; i < parameterTypes2.length; ++i) {
                        void var23_91;
                        int serialzeFeatures;
                        int ordinal;
                        String string = stringArray[i];
                        Annotation[] paramAnnotations = paramAnnotationArrays[i];
                        JSONField fieldAnnotation = null;
                        for (Annotation paramAnnotation : paramAnnotations) {
                            if (!(paramAnnotation instanceof JSONField)) continue;
                            fieldAnnotation = (JSONField)paramAnnotation;
                            break;
                        }
                        Class<?> fieldClass = parameterTypes2[i];
                        Type fieldType = typeArray[i];
                        Field field = TypeUtils.getField(clazz, string, declaredFields, classFieldCache);
                        if (field != null && fieldAnnotation == null) {
                            fieldAnnotation = field.getAnnotation(JSONField.class);
                        }
                        if (fieldAnnotation != null) {
                            ordinal = fieldAnnotation.ordinal();
                            serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                            String nameAnnotated = fieldAnnotation.name();
                            if (nameAnnotated.length() != 0) {
                                String string2 = nameAnnotated;
                            }
                        } else {
                            ordinal = 0;
                            serialzeFeatures = 0;
                        }
                        FieldInfo fieldInfo = new FieldInfo((String)var23_91, clazz, fieldClass, fieldType, field, ordinal, serialzeFeatures);
                        JavaBeanInfo.addField(fieldList, fieldInfo, fieldOnly);
                    }
                    FieldInfo[] fields = new FieldInfo[fieldList.size()];
                    fieldList.toArray(fields);
                    Object[] objectArray = new FieldInfo[fields.length];
                    System.arraycopy(fields, 0, objectArray, 0, fields.length);
                    Arrays.sort(objectArray);
                    JSONType jsonType = jsonTypeSupport ? clazz.getAnnotation(JSONType.class) : null;
                    return new JavaBeanInfo(clazz, null, (Constructor<?>)creatorConstructor, null, fields, (FieldInfo[])objectArray, jsonType);
                }
                throw new JSONException("default constructor not found. " + clazz);
            }
        }
        if (defaultConstructor != null) {
            TypeUtils.setAccessible(clazz, defaultConstructor, classModifiers);
        }
        if (!fieldOnly) {
            for (Method method : methods) {
                String propertyName;
                JSONField annotation;
                Class<?> returnType;
                int ordinal = 0;
                int serialzeFeatures = 0;
                String string = method.getName();
                if (string.length() < 4 || (returnType = method.getReturnType()) != Void.TYPE && returnType != method.getDeclaringClass() || method.getParameterTypes().length != 1) continue;
                JSONField jSONField = annotation = jsonFieldSupport ? method.getAnnotation(JSONField.class) : null;
                if (annotation == null && jsonFieldSupport) {
                    annotation = TypeUtils.getSupperMethodAnnotation(clazz, method);
                }
                if (annotation != null) {
                    if (!annotation.deserialize()) continue;
                    ordinal = annotation.ordinal();
                    serialzeFeatures = SerializerFeature.of(annotation.serialzeFeatures());
                    if (annotation.name().length() != 0) {
                        String propertyName2 = annotation.name();
                        JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName2, method, null, clazz, type, ordinal, serialzeFeatures, annotation, null, fieldGenericSupport), fieldOnly);
                        TypeUtils.setAccessible(clazz, method, classModifiers);
                        continue;
                    }
                }
                if (!string.startsWith("set")) continue;
                char c3 = string.charAt(3);
                if (Character.isUpperCase(c3)) {
                    propertyName = TypeUtils.compatibleWithJavaBean ? TypeUtils.decapitalize(string.substring(3)) : Character.toLowerCase(string.charAt(3)) + string.substring(4);
                } else if (c3 == '_') {
                    propertyName = string.substring(4);
                } else if (c3 == 'f') {
                    propertyName = string.substring(3);
                } else {
                    if (string.length() < 5 || !Character.isUpperCase(string.charAt(4))) continue;
                    propertyName = TypeUtils.decapitalize(string.substring(3));
                }
                Field field = TypeUtils.getField(clazz, propertyName, declaredFields, classFieldCache);
                if (field == null && method.getParameterTypes()[0] == Boolean.TYPE) {
                    String isFieldName = "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                    field = TypeUtils.getField(clazz, isFieldName, declaredFields, classFieldCache);
                }
                if (field != null) {
                    JSONField fieldAnnotation;
                    JSONField jSONField2 = fieldAnnotation = jsonFieldSupport ? field.getAnnotation(JSONField.class) : null;
                    if (fieldAnnotation != null) {
                        ordinal = fieldAnnotation.ordinal();
                        serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                        if (fieldAnnotation.name().length() != 0) {
                            propertyName = fieldAnnotation.name();
                            JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName, method, field, clazz, type, ordinal, serialzeFeatures, annotation, fieldAnnotation, fieldGenericSupport), fieldOnly);
                            continue;
                        }
                        if (annotation == null) {
                            annotation = fieldAnnotation;
                        }
                    }
                }
                if (propertyNamingStrategy != null) {
                    propertyName = propertyNamingStrategy.translate(propertyName);
                }
                JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName, method, null, clazz, type, ordinal, serialzeFeatures, annotation, null, fieldGenericSupport), fieldOnly);
                TypeUtils.setAccessible(clazz, method, classModifiers);
            }
        }
        ArrayList<Field> classfields = new ArrayList<Field>(declaredFields.length);
        Field[] fieldArray = declaredFields;
        int parameterTypes2 = fieldArray.length;
        boolean bl4 = false;
        while (var20_59 < parameterTypes2) {
            block70: {
                Field f;
                block71: {
                    boolean supportReadOnly;
                    f = fieldArray[var20_59];
                    int modifiers = f.getModifiers();
                    if ((modifiers & 8) != 0) break block70;
                    if ((modifiers & 0x10) == 0) break block71;
                    Class<?> clazz4 = f.getType();
                    boolean bl5 = supportReadOnly = Map.class.isAssignableFrom(clazz4) || Collection.class.isAssignableFrom(clazz4);
                    if (!supportReadOnly) break block70;
                }
                if ((f.getModifiers() & 1) != 0) {
                    classfields.add(f);
                }
            }
            ++var20_59;
        }
        Class<?> clazz5 = clazz.getSuperclass();
        while (var18_31 != null && var18_31 != Object.class) {
            for (Field f : var18_31.getDeclaredFields()) {
                int n = f.getModifiers();
                if ((n & 8) != 0) continue;
                if ((n & 0x10) != 0) {
                    boolean supportReadOnly;
                    Class<?> fieldType = f.getType();
                    boolean bl6 = supportReadOnly = Map.class.isAssignableFrom(fieldType) || Collection.class.isAssignableFrom(fieldType);
                    if (!supportReadOnly) continue;
                }
                if ((n & 1) == 0) continue;
                classfields.add(f);
            }
            Class clazz6 = var18_31.getSuperclass();
        }
        for (Field field : classfields) {
            JSONField fieldAnnotation;
            String string = field.getName();
            boolean contains = false;
            int n = fieldList.size();
            for (int i = 0; i < n; ++i) {
                FieldInfo item = (FieldInfo)fieldList.get(i);
                if (!item.name.equals(string)) continue;
                contains = true;
            }
            if (contains) continue;
            int ordinal = 0;
            n = 0;
            String propertyName = string;
            JSONField jSONField = fieldAnnotation = jsonFieldSupport ? field.getAnnotation(JSONField.class) : null;
            if (fieldAnnotation != null) {
                ordinal = fieldAnnotation.ordinal();
                n = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                if (fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                }
            }
            if (propertyNamingStrategy != null) {
                propertyName = propertyNamingStrategy.translate(propertyName);
            }
            TypeUtils.setAccessible(clazz, field, classModifiers);
            JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName, null, field, clazz, type, ordinal, n, null, fieldAnnotation, fieldGenericSupport), fieldOnly);
        }
        if (!fieldOnly) {
            void var20_63;
            Method[] methodArray = methods;
            int field = methodArray.length;
            boolean bl7 = false;
            while (var20_63 < field) {
                Class<?> clazz7;
                Method method = methodArray[var20_63];
                String methodName = method.getName();
                if (methodName.length() >= 4 && methodName.startsWith("get") && Character.isUpperCase(methodName.charAt(3)) && method.getParameterTypes().length == 0 && (Collection.class.isAssignableFrom(clazz7 = method.getReturnType()) || Map.class.isAssignableFrom(clazz7))) {
                    String annotationName;
                    JSONField annotation = jsonFieldSupport ? method.getAnnotation(JSONField.class) : null;
                    String propertyName = annotation != null && (annotationName = annotation.name()).length() > 0 ? annotationName : Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
                    JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName, method, null, clazz, type, 0, 0, annotation, null, fieldGenericSupport), fieldOnly);
                    TypeUtils.setAccessible(clazz, method, classModifiers);
                }
                ++var20_63;
            }
        }
        FieldInfo[] fieldInfoArray = new FieldInfo[fieldList.size()];
        fieldList.toArray(fieldInfoArray);
        Object[] sortedFields = new FieldInfo[fieldInfoArray.length];
        System.arraycopy(fieldInfoArray, 0, sortedFields, 0, fieldInfoArray.length);
        Arrays.sort(sortedFields);
        JSONType jSONType = jsonTypeSupport ? clazz.getAnnotation(JSONType.class) : null;
        return new JavaBeanInfo(clazz, defaultConstructor, null, (Method)factoryMethod, fieldInfoArray, (FieldInfo[])sortedFields, jSONType);
    }
}

