/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;

class EnumSerializer
implements ObjectSerializer {
    EnumSerializer() {
    }

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.out;
        if ((out.features & SerializerFeature.WriteEnumUsingToString.mask) != 0) {
            boolean userSingleQuote;
            Enum e = (Enum)object;
            String name = e.toString();
            boolean bl = userSingleQuote = (out.features & SerializerFeature.UseSingleQuotes.mask) != 0;
            if (userSingleQuote) {
                out.writeStringWithSingleQuote(name);
            } else {
                out.writeStringWithDoubleQuote(name, '\u0000', false);
            }
        } else {
            Enum e = (Enum)object;
            out.writeInt(e.ordinal());
        }
    }
}

