/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

public class SymbolTable {
    private final Entry[] symbols;
    private final int indexMask;

    public SymbolTable(int tableSize) {
        this.indexMask = tableSize - 1;
        this.symbols = new Entry[tableSize];
        this.addSymbol("$ref", 0, 4, "$ref".hashCode());
        this.addSymbol("@type", 0, "@type".length(), "@type".hashCode());
    }

    public String addSymbol(char[] buffer, int offset, int len, int hash) {
        int bucket = hash & this.indexMask;
        Entry entry = this.symbols[bucket];
        if (entry != null) {
            boolean eq = true;
            if (hash == entry.hashCode && len == entry.chars.length) {
                for (int i = 0; i < len; ++i) {
                    if (buffer[offset + i] == entry.chars[i]) continue;
                    eq = false;
                    break;
                }
            } else {
                eq = false;
            }
            if (eq) {
                return entry.value;
            }
            return new String(buffer, offset, len);
        }
        String strVal = new String(buffer, offset, len).intern();
        this.symbols[bucket] = entry = new Entry(strVal, hash);
        return strVal;
    }

    public String addSymbol(String buffer, int offset, int len, int hash) {
        int bucket = hash & this.indexMask;
        Entry entry = this.symbols[bucket];
        if (entry != null) {
            if (hash == entry.hashCode && len == entry.chars.length && buffer.regionMatches(offset, entry.value, 0, len)) {
                return entry.value;
            }
            return SymbolTable.subString(buffer, offset, len);
        }
        String symbol = len == buffer.length() ? buffer : SymbolTable.subString(buffer, offset, len);
        symbol = symbol.intern();
        this.symbols[bucket] = new Entry(symbol, hash);
        return symbol;
    }

    private static String subString(String src, int offset, int len) {
        char[] chars = new char[len];
        src.getChars(offset, offset + len, chars, 0);
        return new String(chars);
    }

    public static int hash(char[] buffer, int offset, int len) {
        int h = 0;
        int off = offset;
        for (int i = 0; i < len; ++i) {
            h = 31 * h + buffer[off++];
        }
        return h;
    }

    static class Entry {
        final String value;
        final char[] chars;
        final int hashCode;

        Entry(String value, int hashCode) {
            this.value = value;
            this.chars = value.toCharArray();
            this.hashCode = hashCode;
        }
    }
}

