/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.util.ParameterizedTypeImpl;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldInfo
implements Comparable<FieldInfo> {
    public final String name;
    public final Method method;
    public final Field field;
    public final boolean fieldAccess;
    public final boolean fieldTransient;
    private int ordinal = 0;
    public final Class<?> fieldClass;
    public final Type fieldType;
    public final Class<?> declaringClass;
    public final boolean getOnly;
    private final JSONField fieldAnnotation;
    private final JSONField methodAnnotation;
    public final char[] name_chars;
    public final boolean isEnum;

    public FieldInfo(String name, Class<?> declaringClass, Class<?> fieldClass, Type fieldType, Field field, int ordinal, int serialzeFeatures) {
        this.name = name;
        this.declaringClass = declaringClass;
        this.fieldClass = fieldClass;
        this.fieldType = fieldType;
        this.method = null;
        this.field = field;
        this.ordinal = ordinal;
        this.isEnum = fieldClass.isEnum();
        this.fieldAnnotation = null;
        this.methodAnnotation = null;
        if (field != null) {
            int modifiers = field.getModifiers();
            this.fieldAccess = (modifiers & 1) != 0 || this.method == null;
            this.fieldTransient = Modifier.isTransient(modifiers);
        } else {
            this.fieldAccess = false;
            this.fieldTransient = false;
        }
        this.getOnly = false;
        int nameLen = this.name.length();
        this.name_chars = new char[nameLen + 3];
        this.name.getChars(0, this.name.length(), this.name_chars, 1);
        this.name_chars[0] = 34;
        this.name_chars[nameLen + 1] = 34;
        this.name_chars[nameLen + 2] = 58;
    }

    public FieldInfo(String name, Method method, Field field, Class<?> clazz, Type type, int ordinal, int serialzeFeatures, JSONField methodAnnotation, JSONField fieldAnnotation, boolean fieldGenericSupport) {
        TypeVariable tv;
        Type genericFieldType;
        Type fieldType;
        Class<?> fieldClass;
        this.name = name;
        this.method = method;
        this.field = field;
        this.ordinal = ordinal;
        this.methodAnnotation = methodAnnotation;
        this.fieldAnnotation = fieldAnnotation;
        if (field != null) {
            int modifiers = field.getModifiers();
            this.fieldAccess = method == null || (modifiers & 1) != 0;
            this.fieldTransient = (modifiers & 0x80) != 0;
        } else {
            this.fieldAccess = false;
            this.fieldTransient = false;
        }
        int nameLen = this.name.length();
        this.name_chars = new char[nameLen + 3];
        this.name.getChars(0, this.name.length(), this.name_chars, 1);
        this.name_chars[0] = 34;
        this.name_chars[nameLen + 1] = 34;
        this.name_chars[nameLen + 2] = 58;
        if (method != null) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length == 1) {
                fieldClass = parameterTypes[0];
                fieldType = fieldClass == Class.class || fieldClass == String.class || fieldClass.isPrimitive() ? fieldClass : (fieldGenericSupport ? method.getGenericParameterTypes()[0] : fieldClass);
                this.getOnly = false;
            } else {
                fieldClass = method.getReturnType();
                fieldType = fieldClass == Class.class ? fieldClass : (fieldGenericSupport ? method.getGenericReturnType() : fieldClass);
                this.getOnly = true;
            }
            this.declaringClass = method.getDeclaringClass();
        } else {
            fieldClass = field.getType();
            fieldType = fieldClass.isPrimitive() || fieldClass == String.class || fieldClass.isEnum() ? fieldClass : (fieldGenericSupport ? field.getGenericType() : fieldClass);
            this.declaringClass = field.getDeclaringClass();
            this.getOnly = false;
        }
        if (clazz != null && fieldClass == Object.class && fieldType instanceof TypeVariable && (genericFieldType = FieldInfo.getInheritGenericType(clazz, tv = (TypeVariable)fieldType)) != null) {
            this.fieldClass = TypeUtils.getClass(genericFieldType);
            this.fieldType = genericFieldType;
            this.isEnum = fieldClass.isEnum();
            return;
        }
        Type genericFieldType2 = fieldType;
        if (!(fieldType instanceof Class) && (genericFieldType2 = FieldInfo.getFieldType(clazz, type, fieldType)) != fieldType) {
            if (genericFieldType2 instanceof ParameterizedType) {
                fieldClass = TypeUtils.getClass(genericFieldType2);
            } else if (genericFieldType2 instanceof Class) {
                fieldClass = TypeUtils.getClass(genericFieldType2);
            }
        }
        this.fieldType = genericFieldType2;
        this.fieldClass = fieldClass;
        this.isEnum = !fieldClass.isArray() && fieldClass.isEnum();
    }

    public static Type getFieldType(Class<?> clazz, Type type, Type fieldType) {
        int i;
        if (clazz == null || type == null) {
            return fieldType;
        }
        if (fieldType instanceof GenericArrayType) {
            Type componentTypeX;
            GenericArrayType genericArrayType = (GenericArrayType)fieldType;
            Type componentType = genericArrayType.getGenericComponentType();
            if (componentType != (componentTypeX = FieldInfo.getFieldType(clazz, type, componentType))) {
                Class<?> fieldTypeX = Array.newInstance(TypeUtils.getClass(componentTypeX), 0).getClass();
                return fieldTypeX;
            }
            return fieldType;
        }
        if (!TypeUtils.isGenericParamType(type)) {
            return fieldType;
        }
        if (fieldType instanceof TypeVariable) {
            ParameterizedType paramType = (ParameterizedType)TypeUtils.getGenericParamType(type);
            Class<?> parameterizedClass = TypeUtils.getClass(paramType);
            TypeVariable typeVar = (TypeVariable)fieldType;
            for (i = 0; i < parameterizedClass.getTypeParameters().length; ++i) {
                if (!parameterizedClass.getTypeParameters()[i].getName().equals(typeVar.getName())) continue;
                fieldType = paramType.getActualTypeArguments()[i];
                return fieldType;
            }
        }
        if (fieldType instanceof ParameterizedType) {
            ParameterizedType parameterizedFieldType = (ParameterizedType)fieldType;
            Type[] arguments = parameterizedFieldType.getActualTypeArguments();
            boolean changed = false;
            for (i = 0; i < arguments.length; ++i) {
                Type feildTypeArguement = arguments[i];
                if (!(feildTypeArguement instanceof TypeVariable)) continue;
                TypeVariable typeVar = (TypeVariable)feildTypeArguement;
                if (!(type instanceof ParameterizedType)) continue;
                ParameterizedType parameterizedType = (ParameterizedType)type;
                for (int j = 0; j < clazz.getTypeParameters().length; ++j) {
                    if (!clazz.getTypeParameters()[j].getName().equals(typeVar.getName())) continue;
                    arguments[i] = parameterizedType.getActualTypeArguments()[j];
                    changed = true;
                }
            }
            if (changed) {
                fieldType = new ParameterizedTypeImpl(arguments, parameterizedFieldType.getOwnerType(), parameterizedFieldType.getRawType());
                return fieldType;
            }
        }
        return fieldType;
    }

    public static Type getInheritGenericType(Class<?> clazz, TypeVariable<?> tv) {
        Type type = null;
        Object gd = tv.getGenericDeclaration();
        do {
            ParameterizedType ptype;
            if ((type = clazz.getGenericSuperclass()) == null) {
                return null;
            }
            if (type instanceof ParameterizedType && (ptype = (ParameterizedType)type).getRawType() == gd) {
                TypeVariable<?>[] tvs = gd.getTypeParameters();
                Type[] types = ptype.getActualTypeArguments();
                for (int i = 0; i < tvs.length; ++i) {
                    if (tvs[i] != tv) continue;
                    return types[i];
                }
                return null;
            }
            clazz = TypeUtils.getClass(type);
        } while (type != null);
        return null;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(FieldInfo o) {
        if (this.ordinal < o.ordinal) {
            return -1;
        }
        if (this.ordinal > o.ordinal) {
            return 1;
        }
        return this.name.compareTo(o.name);
    }

    public boolean equals(FieldInfo o) {
        if (o == this) {
            return true;
        }
        return this.compareTo(o) == 0;
    }

    public JSONField getAnnotation() {
        if (this.fieldAnnotation != null) {
            return this.fieldAnnotation;
        }
        return this.methodAnnotation;
    }

    public Object get(Object javaObject) throws IllegalAccessException, InvocationTargetException {
        if (this.fieldAccess) {
            return this.field.get(javaObject);
        }
        Object value = this.method.invoke(javaObject, new Object[0]);
        return value;
    }

    public void set(Object javaObject, Object value) throws IllegalAccessException, InvocationTargetException {
        if (this.method != null) {
            this.method.invoke(javaObject, value);
            return;
        }
        this.field.set(javaObject, value);
    }
}

