/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.util.FieldInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldDeserializer {
    public final FieldInfo fieldInfo;
    public final Class<?> clazz;

    public FieldDeserializer(Class<?> clazz, FieldInfo fieldInfo, int fastMatchToken) {
        this.clazz = clazz;
        this.fieldInfo = fieldInfo;
    }

    public abstract void parseField(DefaultJSONParser var1, Object var2, Type var3, Map<String, Object> var4);

    public void setValue(Object object, int value) throws IllegalAccessException {
        this.fieldInfo.field.setInt(object, value);
    }

    public void setValue(Object object, long value) throws IllegalAccessException {
        this.fieldInfo.field.setLong(object, value);
    }

    public void setValue(Object object, float value) throws IllegalAccessException {
        this.fieldInfo.field.setFloat(object, value);
    }

    public void setValue(Object object, double value) throws IllegalAccessException {
        this.fieldInfo.field.setDouble(object, value);
    }

    public void setValue(Object object, Object value) {
        Class<?> fieldClass;
        if (value == null && (fieldClass = this.fieldInfo.fieldClass).isPrimitive()) {
            return;
        }
        Field field = this.fieldInfo.field;
        Method method = this.fieldInfo.method;
        try {
            if (this.fieldInfo.fieldAccess) {
                field.set(object, value);
            } else if (this.fieldInfo.getOnly) {
                if (Map.class.isAssignableFrom(method.getReturnType())) {
                    Map map = (Map)method.invoke(object, new Object[0]);
                    if (map != null) {
                        map.putAll((Map)value);
                    }
                } else {
                    Collection collection = (Collection)method.invoke(object, new Object[0]);
                    if (collection != null) {
                        collection.addAll((Collection)value);
                    }
                }
            } else {
                method.invoke(object, value);
            }
        }
        catch (Exception e) {
            throw new JSONException("set property error, " + this.fieldInfo.name, e);
        }
    }
}

