/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.ArrayCodec;
import com.alibaba.fastjson.serializer.BigDecimalCodec;
import com.alibaba.fastjson.serializer.BooleanCodec;
import com.alibaba.fastjson.serializer.IntegerCodec;
import com.alibaba.fastjson.serializer.JavaBeanSerializer;
import com.alibaba.fastjson.serializer.MiscCodec;
import com.alibaba.fastjson.serializer.NumberCodec;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.StringCodec;
import com.alibaba.fastjson.util.IdentityHashMap;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializeConfig
extends IdentityHashMap<ObjectSerializer> {
    public static final SerializeConfig globalInstance = new SerializeConfig();

    public ObjectSerializer createJavaBeanSerializer(Class<?> clazz) {
        return new JavaBeanSerializer(clazz);
    }

    public static final SerializeConfig getGlobalInstance() {
        return globalInstance;
    }

    public SerializeConfig() {
        this(1024);
    }

    public SerializeConfig(int tableSize) {
        super(tableSize);
        this.put((Type)((Object)Boolean.class), BooleanCodec.instance);
        this.put((Type)((Object)Character.class), MiscCodec.instance);
        this.put((Type)((Object)Byte.class), IntegerCodec.instance);
        this.put((Type)((Object)Short.class), IntegerCodec.instance);
        this.put((Type)((Object)Integer.class), IntegerCodec.instance);
        this.put((Type)((Object)Long.class), IntegerCodec.instance);
        this.put((Type)((Object)Float.class), NumberCodec.instance);
        this.put((Type)((Object)Double.class), NumberCodec.instance);
        this.put((Type)((Object)BigDecimal.class), BigDecimalCodec.instance);
        this.put((Type)((Object)BigInteger.class), BigDecimalCodec.instance);
        this.put((Type)((Object)String.class), StringCodec.instance);
        this.put((Type)((Object)Object[].class), ArrayCodec.instance);
        this.put((Type)((Object)Class.class), MiscCodec.instance);
        this.put((Type)((Object)SimpleDateFormat.class), MiscCodec.instance);
        this.put((Type)((Object)Locale.class), MiscCodec.instance);
        this.put((Type)((Object)Currency.class), MiscCodec.instance);
        this.put((Type)((Object)TimeZone.class), MiscCodec.instance);
        this.put((Type)((Object)UUID.class), MiscCodec.instance);
        this.put((Type)((Object)URI.class), MiscCodec.instance);
        this.put((Type)((Object)URL.class), MiscCodec.instance);
        this.put((Type)((Object)Pattern.class), MiscCodec.instance);
        this.put((Type)((Object)Charset.class), MiscCodec.instance);
    }
}

