/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public final class ListSerializer
implements ObjectSerializer {
    public static final ListSerializer instance = new ListSerializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.out;
        boolean writeClassName = (out.features & SerializerFeature.WriteClassName.mask) != 0;
        Type elementType = null;
        if (writeClassName && fieldType instanceof ParameterizedType) {
            ParameterizedType param = (ParameterizedType)fieldType;
            elementType = param.getActualTypeArguments()[0];
        }
        if (object == null) {
            if ((out.features & SerializerFeature.WriteNullListAsEmpty.mask) != 0) {
                out.write("[]");
            } else {
                out.writeNull();
            }
            return;
        }
        List list = (List)object;
        int size = list.size();
        if (size == 0) {
            out.append("[]");
            return;
        }
        SerialContext context = serializer.context;
        serializer.setContext(context, object, fieldName, 0);
        ObjectSerializer itemSerializer = null;
        try {
            if ((out.features & SerializerFeature.PrettyFormat.mask) != 0) {
                out.write('[');
                serializer.incrementIndent();
                for (int i = 0; i < size; ++i) {
                    Object item = list.get(i);
                    if (i != 0) {
                        out.write(',');
                    }
                    serializer.println();
                    if (item != null) {
                        SerialContext itemContext;
                        if (serializer.containsReference(item)) {
                            serializer.writeReference(item);
                            continue;
                        }
                        itemSerializer = serializer.getObjectWriter(item.getClass());
                        serializer.context = itemContext = new SerialContext(context, object, fieldName, 0);
                        itemSerializer.write(serializer, item, i, elementType);
                        continue;
                    }
                    serializer.out.writeNull();
                }
                serializer.decrementIdent();
                serializer.println();
                out.write(']');
                return;
            }
            out.write('[');
            for (int i = 0; i < list.size(); ++i) {
                SerialContext itemContext;
                Object item = list.get(i);
                if (i != 0) {
                    out.write(',');
                }
                if (item == null) {
                    out.append("null");
                    continue;
                }
                Class<?> clazz = item.getClass();
                if (clazz == Integer.class) {
                    out.writeInt((Integer)item);
                    continue;
                }
                if (clazz == Long.class) {
                    long val = (Long)item;
                    if (writeClassName) {
                        out.writeLong(val);
                        out.write('L');
                        continue;
                    }
                    out.writeLong(val);
                    continue;
                }
                serializer.context = itemContext = new SerialContext(context, object, fieldName, 0);
                if (serializer.containsReference(item)) {
                    serializer.writeReference(item);
                    continue;
                }
                itemSerializer = serializer.getObjectWriter(item.getClass());
                itemSerializer.write(serializer, item, i, elementType);
            }
            out.write(']');
        }
        finally {
            serializer.context = context;
        }
    }
}

