/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.serializer.FieldSerializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.NumberFieldSerializer;
import com.alibaba.fastjson.serializer.ObjectFieldSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.alibaba.fastjson.serializer.SerialContext;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanSerializer
implements ObjectSerializer {
    private final FieldSerializer[] getters;
    private final FieldSerializer[] sortedGetters;
    protected int features = 0;

    public FieldSerializer[] getGetters() {
        return this.getters;
    }

    public JavaBeanSerializer(Class<?> clazz) {
        this(clazz, (Map<String, String>)null);
    }

    public JavaBeanSerializer(Class<?> clazz, String ... aliasList) {
        this(clazz, JavaBeanSerializer.createAliasMap(aliasList));
    }

    static Map<String, String> createAliasMap(String ... aliasList) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        for (String alias : aliasList) {
            aliasMap.put(alias, alias);
        }
        return aliasMap;
    }

    public JavaBeanSerializer(Class<?> clazz, Map<String, String> aliasMap) {
        JSONType jsonType = clazz.getAnnotation(JSONType.class);
        if (jsonType != null) {
            this.features = SerializerFeature.of(jsonType.serialzeFeatures());
        }
        List<FieldInfo> fieldInfoList = TypeUtils.computeGetters(clazz, jsonType, aliasMap, false);
        ArrayList<FieldSerializer> getterList = new ArrayList<FieldSerializer>();
        for (FieldInfo fieldInfo : fieldInfoList) {
            getterList.add(this.createFieldSerializer(fieldInfo));
        }
        this.getters = getterList.toArray(new FieldSerializer[getterList.size()]);
        String[] orders = null;
        if (jsonType != null) {
            orders = jsonType.orders();
        }
        if (orders != null && orders.length != 0) {
            List<FieldInfo> fieldInfoList2 = TypeUtils.computeGetters(clazz, jsonType, aliasMap, true);
            ArrayList<FieldSerializer> getterList2 = new ArrayList<FieldSerializer>();
            for (FieldInfo fieldInfo : fieldInfoList2) {
                getterList2.add(this.createFieldSerializer(fieldInfo));
            }
            this.sortedGetters = getterList2.toArray(new FieldSerializer[getterList2.size()]);
        } else {
            this.sortedGetters = new FieldSerializer[this.getters.length];
            System.arraycopy(this.getters, 0, this.sortedGetters, 0, this.getters.length);
            Arrays.sort(this.sortedGetters);
        }
    }

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull();
            return;
        }
        if (this.writeReference(serializer, object)) {
            return;
        }
        FieldSerializer[] getters = (out.features & SerializerFeature.SortField.mask) != 0 ? this.sortedGetters : this.getters;
        SerialContext parent = serializer.context;
        serializer.setContext(parent, object, fieldName, this.features);
        boolean writeAsArray = (this.features & SerializerFeature.BeanToArray.mask) != 0 ? true : (out.features & SerializerFeature.BeanToArray.mask) != 0;
        try {
            Class<?> objClass;
            boolean isWriteClassName;
            char startSeperator = writeAsArray ? (char)'[' : '{';
            char endSeperator = writeAsArray ? (char)']' : '}';
            out.write(startSeperator);
            if (getters.length > 0 && (out.features & SerializerFeature.PrettyFormat.mask) != 0) {
                serializer.incrementIndent();
                serializer.println();
            }
            boolean commaFlag = false;
            boolean bl = isWriteClassName = (this.features & SerializerFeature.WriteClassName.mask) != 0 || serializer.isWriteClassName(fieldType, fieldName);
            if (isWriteClassName && (objClass = object.getClass()) != fieldType) {
                out.writeFieldName(JSON.DEFAULT_TYPE_KEY);
                serializer.write(object.getClass());
                commaFlag = true;
            }
            char seperator = commaFlag ? (char)',' : '\u0000';
            char newSeperator = JSONSerializer.writeBefore(serializer, object, seperator);
            commaFlag = newSeperator == ',';
            for (int i = 0; i < getters.length; ++i) {
                Field field;
                FieldSerializer fieldSerializer = getters[i];
                FieldInfo fieldInfo = fieldSerializer.fieldInfo;
                Class<?> fieldClass = fieldInfo.fieldClass;
                String fieldInfoName = fieldInfo.name;
                if ((out.features & SerializerFeature.SkipTransientField.mask) != 0 && (field = fieldInfo.field) != null && fieldInfo.fieldTransient) continue;
                boolean applyName = true;
                List<PropertyPreFilter> filters = serializer.propertyPreFilters;
                if (filters != null) {
                    for (PropertyPreFilter filter : filters) {
                        if (filter.apply(serializer, object, fieldInfoName)) continue;
                        applyName = false;
                        break;
                    }
                }
                if (!applyName) continue;
                Object propertyValue = null;
                int propertyValueInt = 0;
                long propertyValueLong = 0L;
                boolean propertyValueBoolean = false;
                boolean propertyValueGot = false;
                boolean valueGot = false;
                if (fieldInfo.fieldAccess) {
                    if (fieldClass == Integer.TYPE) {
                        propertyValueInt = fieldInfo.field.getInt(object);
                        valueGot = true;
                    } else if (fieldClass == Long.TYPE) {
                        propertyValueLong = fieldInfo.field.getLong(object);
                        valueGot = true;
                    } else if (fieldClass == Boolean.TYPE) {
                        propertyValueBoolean = fieldInfo.field.getBoolean(object);
                        valueGot = true;
                    }
                }
                if (!valueGot) {
                    propertyValue = fieldSerializer.getPropertyValue(object);
                    propertyValueGot = true;
                }
                boolean apply = true;
                List<PropertyFilter> propertyFilters = serializer.propertyFilters;
                if (propertyFilters != null) {
                    if (valueGot) {
                        if (fieldClass == Integer.TYPE) {
                            propertyValue = propertyValueInt;
                            propertyValueGot = true;
                        } else if (fieldClass == Long.TYPE) {
                            propertyValue = propertyValueLong;
                            propertyValueGot = true;
                        } else if (fieldClass == Boolean.TYPE) {
                            propertyValue = propertyValueBoolean;
                            propertyValueGot = true;
                        }
                    }
                    for (PropertyFilter propertyFilter : propertyFilters) {
                        if (propertyFilter.apply(object, fieldInfoName, propertyValue)) continue;
                        apply = false;
                        break;
                    }
                }
                if (!apply) continue;
                String key = fieldInfoName;
                List<NameFilter> nameFilters = serializer.nameFilters;
                if (nameFilters != null) {
                    if (valueGot && !propertyValueGot) {
                        if (fieldClass == Integer.TYPE) {
                            propertyValue = propertyValueInt;
                            propertyValueGot = true;
                        } else if (fieldClass == Long.TYPE) {
                            propertyValue = propertyValueLong;
                            propertyValueGot = true;
                        } else if (fieldClass == Boolean.TYPE) {
                            propertyValue = propertyValueBoolean;
                            propertyValueGot = true;
                        }
                    }
                    for (NameFilter nameFilter : nameFilters) {
                        key = nameFilter.process(object, key, propertyValue);
                    }
                }
                Object originalValue = propertyValue;
                List<ValueFilter> list = serializer.valueFilters;
                if (list != null) {
                    if (valueGot && !propertyValueGot) {
                        if (fieldClass == Integer.TYPE) {
                            originalValue = propertyValue = Integer.valueOf(propertyValueInt);
                            propertyValueGot = true;
                        } else if (fieldClass == Long.TYPE) {
                            originalValue = propertyValue = Long.valueOf(propertyValueLong);
                            propertyValueGot = true;
                        } else if (fieldClass == Boolean.TYPE) {
                            originalValue = propertyValue = Boolean.valueOf(propertyValueBoolean);
                            propertyValueGot = true;
                        }
                    }
                    for (ValueFilter valueFilter : list) {
                        propertyValue = valueFilter.process(object, fieldInfoName, propertyValue);
                    }
                }
                if (propertyValueGot && propertyValue == null && !writeAsArray && !fieldSerializer.writeNull && (out.features & SerializerFeature.WriteMapNullValue.mask) == 0 || propertyValueGot && propertyValue != null && (out.features & SerializerFeature.NotWriteDefaultValue.mask) != 0 && (fieldClass == Byte.TYPE && propertyValue instanceof Byte && (Byte)propertyValue == 0 || fieldClass == Short.TYPE && propertyValue instanceof Short && (Short)propertyValue == 0 || fieldClass == Integer.TYPE && propertyValue instanceof Integer && (Integer)propertyValue == 0 || fieldClass == Long.TYPE && propertyValue instanceof Long && (Long)propertyValue == 0L || fieldClass == Float.TYPE && propertyValue instanceof Float && ((Float)propertyValue).floatValue() == 0.0f || fieldClass == Double.TYPE && propertyValue instanceof Double && (Double)propertyValue == 0.0 || fieldClass == Boolean.TYPE && propertyValue instanceof Boolean && !((Boolean)propertyValue).booleanValue())) continue;
                if (commaFlag) {
                    out.write(',');
                    if ((out.features & SerializerFeature.PrettyFormat.mask) != 0) {
                        serializer.println();
                    }
                }
                if (key != fieldInfoName) {
                    if (!writeAsArray) {
                        out.writeFieldName(key);
                    }
                    if (valueGot && !propertyValueGot) {
                        if (fieldInfo.fieldClass == Integer.TYPE) {
                            propertyValue = propertyValueInt;
                            propertyValueGot = true;
                        } else if (fieldInfo.fieldClass == Long.TYPE) {
                            propertyValue = propertyValueLong;
                            propertyValueGot = true;
                        } else if (fieldInfo.fieldClass == Boolean.TYPE) {
                            propertyValue = propertyValueBoolean;
                            propertyValueGot = true;
                        }
                    }
                    serializer.write(propertyValue);
                } else if (originalValue != propertyValue) {
                    if (!writeAsArray) {
                        fieldSerializer.writePrefix(serializer);
                    }
                    serializer.write(propertyValue);
                } else if (valueGot) {
                    if (fieldClass == Integer.TYPE) {
                        if (!writeAsArray) {
                            fieldSerializer.writePrefix(serializer);
                            serializer.out.writeInt(propertyValueInt);
                        } else {
                            serializer.out.writeInt(propertyValueInt);
                        }
                    } else if (fieldClass == Long.TYPE) {
                        if (!writeAsArray) {
                            fieldSerializer.writePrefix(serializer);
                            serializer.out.writeLong(propertyValueLong);
                        } else {
                            serializer.out.writeLong(propertyValueLong);
                        }
                    } else if (fieldClass == Boolean.TYPE) {
                        String string;
                        String string2 = string = propertyValueBoolean ? "true" : "false";
                        if (!writeAsArray) {
                            fieldSerializer.writePrefix(serializer);
                            serializer.out.write(string);
                        } else {
                            serializer.out.write(string);
                        }
                    }
                } else if (!writeAsArray) {
                    fieldSerializer.writeProperty(serializer, propertyValue);
                } else {
                    fieldSerializer.writeValue(serializer, propertyValue);
                }
                commaFlag = true;
            }
            JSONSerializer.writeAfter(serializer, object, commaFlag ? (char)',' : '\u0000');
            if (getters.length > 0 && (out.features & SerializerFeature.PrettyFormat.mask) != 0) {
                serializer.decrementIdent();
                serializer.println();
            }
            out.write(endSeperator);
        }
        catch (Exception e) {
            throw new JSONException("write javaBean error", e);
        }
        finally {
            serializer.context = parent;
        }
    }

    public boolean writeReference(JSONSerializer serializer, Object object) {
        SerialContext context = serializer.context;
        if (context != null && (context.features & SerializerFeature.DisableCircularReferenceDetect.mask) != 0) {
            return false;
        }
        if (!serializer.containsReference(object)) {
            return false;
        }
        serializer.writeReference(object);
        return true;
    }

    public FieldSerializer createFieldSerializer(FieldInfo fieldInfo) {
        Class<?> clazz = fieldInfo.fieldClass;
        if (clazz == Number.class) {
            return new NumberFieldSerializer(fieldInfo);
        }
        return new ObjectFieldSerializer(fieldInfo);
    }
}

