/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.ParseContext;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.parser.deserializer.ExtraProcessor;
import com.alibaba.fastjson.parser.deserializer.ExtraTypeProvider;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.ResolveFieldDeserializer;
import com.alibaba.fastjson.serializer.IntegerCodec;
import com.alibaba.fastjson.serializer.StringCodec;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.Closeable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJSONParser
implements Closeable {
    protected final Object input;
    public final SymbolTable symbolTable;
    public ParserConfig config;
    private String dateFormatPattern = JSON.DEFFAULT_DATE_FORMAT;
    private DateFormat dateFormat;
    public final JSONLexer lexer;
    protected ParseContext context;
    private ParseContext[] contextArray = new ParseContext[8];
    private int contextArrayIndex = 0;
    private List<ResolveTask> resolveTaskList;
    public static final int NONE = 0;
    public static final int NeedToResolve = 1;
    public static final int TypeNameRedirect = 2;
    public int resolveStatus = 0;
    private List<ExtraTypeProvider> extraTypeProviders = null;
    private List<ExtraProcessor> extraProcessors = null;

    public String getDateFomartPattern() {
        return this.dateFormatPattern;
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat(this.dateFormatPattern);
        }
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormatPattern = dateFormat;
        this.dateFormat = null;
    }

    public void setDateFomrat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public DefaultJSONParser(String input) {
        this(input, ParserConfig.global, JSON.DEFAULT_PARSER_FEATURE);
    }

    public DefaultJSONParser(String input, ParserConfig config) {
        this((Object)input, new JSONLexer(input, JSON.DEFAULT_PARSER_FEATURE), config);
    }

    public DefaultJSONParser(String input, ParserConfig config, int features) {
        this((Object)input, new JSONLexer(input, features), config);
    }

    public DefaultJSONParser(char[] input, int length, ParserConfig config, int features) {
        this(input, new JSONLexer(input, length, features), config);
    }

    public DefaultJSONParser(JSONLexer lexer) {
        this(lexer, ParserConfig.global);
    }

    public DefaultJSONParser(JSONLexer lexer, ParserConfig config) {
        this(null, lexer, config);
    }

    public DefaultJSONParser(Object input, JSONLexer lexer, ParserConfig config) {
        this.lexer = lexer;
        this.input = input;
        this.config = config;
        this.symbolTable = config.symbolTable;
        lexer.nextToken(12);
    }

    public String getInput() {
        if (this.input instanceof char[]) {
            return new String((char[])this.input);
        }
        return this.input.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object parseObject(Map object, Object fieldName) {
        JSONLexer lexer = this.lexer;
        if (lexer.token == 8) {
            lexer.next();
            return null;
        }
        if (lexer.token != 12 && lexer.token != 16) {
            throw new JSONException("syntax error, expect {, actual " + lexer.tokenName());
        }
        ParseContext context = this.context;
        try {
            Object key;
            char ch;
            boolean setContextFlag = false;
            while (true) {
                Object iso8601Lexer;
                Object value;
                block79: {
                    ParseContext rootContext;
                    Object refValue;
                    block78: {
                        String ref;
                        block80: {
                            lexer.skipWhitespace();
                            ch = lexer.ch;
                            if ((lexer.features & Feature.AllowArbitraryCommas.mask) != 0) {
                                while (ch == ',') {
                                    lexer.next();
                                    lexer.skipWhitespace();
                                    ch = lexer.ch;
                                }
                            }
                            boolean isObjectKey = false;
                            if (ch == '\"') {
                                key = lexer.scanSymbol(this.symbolTable, '\"');
                                lexer.skipWhitespace();
                                ch = lexer.ch;
                                if (ch != ':') {
                                    throw new JSONException("expect ':' at " + lexer.pos + ", name " + key);
                                }
                            } else {
                                if (ch == '}') {
                                    lexer.next();
                                    lexer.resetStringPosition();
                                    lexer.nextToken();
                                    Map map = object;
                                    return map;
                                }
                                if (ch == '\'') {
                                    if ((lexer.features & Feature.AllowSingleQuotes.mask) == 0) {
                                        throw new JSONException("syntax error");
                                    }
                                    key = lexer.scanSymbol(this.symbolTable, '\'');
                                    lexer.skipWhitespace();
                                    ch = lexer.ch;
                                    if (ch != ':') {
                                        throw new JSONException("expect ':' at " + lexer.pos);
                                    }
                                } else {
                                    if (ch == '\u001a') {
                                        throw new JSONException("syntax error");
                                    }
                                    if (ch == ',') {
                                        throw new JSONException("syntax error");
                                    }
                                    if (ch >= '0' && ch <= '9' || ch == '-') {
                                        lexer.resetStringPosition();
                                        lexer.scanNumber();
                                        key = lexer.token == 2 ? (Number)lexer.integerValue() : (Number)lexer.decimalValue(true);
                                        ch = lexer.ch;
                                        if (ch != ':') {
                                            throw new JSONException("expect ':' at " + lexer.pos() + ", name " + key);
                                        }
                                    } else if (ch == '{' || ch == '[') {
                                        lexer.nextToken();
                                        key = this.parse();
                                        isObjectKey = true;
                                    } else {
                                        if ((lexer.features & Feature.AllowUnQuotedFieldNames.mask) == 0) {
                                            throw new JSONException("syntax error");
                                        }
                                        key = lexer.scanSymbolUnQuoted(this.symbolTable);
                                        lexer.skipWhitespace();
                                        ch = lexer.ch;
                                        if (ch != ':') {
                                            throw new JSONException("expect ':' at " + lexer.pos() + ", actual " + ch);
                                        }
                                    }
                                }
                            }
                            if (!isObjectKey) {
                                lexer.next();
                                lexer.skipWhitespace();
                            }
                            ch = lexer.ch;
                            lexer.resetStringPosition();
                            if (key == JSON.DEFAULT_TYPE_KEY) {
                                ObjectDeserializer deserializer;
                                String typeName = lexer.scanSymbol(this.symbolTable, '\"');
                                Class<?> clazz = TypeUtils.loadClass(typeName, this.config.defaultClassLoader);
                                if (clazz == null) {
                                    object.put(JSON.DEFAULT_TYPE_KEY, typeName);
                                    continue;
                                }
                                lexer.nextToken(16);
                                if (lexer.token == 13) {
                                    lexer.nextToken(16);
                                    try {
                                        HashMap instance = null;
                                        deserializer = this.config.getDeserializer(clazz);
                                        if (deserializer instanceof JavaBeanDeserializer) {
                                            instance = ((JavaBeanDeserializer)deserializer).createInstance(this, clazz);
                                        }
                                        if (instance == null) {
                                            instance = clazz == Cloneable.class ? new HashMap() : clazz.newInstance();
                                        }
                                        HashMap hashMap = instance;
                                        return hashMap;
                                    }
                                    catch (Exception e) {
                                        throw new JSONException("create instance error", e);
                                    }
                                }
                                this.resolveStatus = 2;
                                if (this.context != null && !(fieldName instanceof Integer)) {
                                    this.popContext();
                                }
                                ObjectDeserializer deserializer2 = this.config.getDeserializer(clazz);
                                deserializer = deserializer2.deserialze(this, clazz, fieldName);
                                return deserializer;
                            }
                            if (key != "$ref") break block79;
                            lexer.nextToken(4);
                            if (lexer.token != 4) throw new JSONException("illegal ref, " + JSONToken.name(lexer.token));
                            ref = lexer.stringVal();
                            lexer.nextToken(13);
                            refValue = null;
                            if (!"@".equals(ref)) break block80;
                            if (this.context != null) {
                                ParseContext thisContext = this.context;
                                Object thisObj = thisContext.object;
                                if (thisObj instanceof Object[] || thisObj instanceof Collection) {
                                    refValue = thisObj;
                                    break block78;
                                } else if (thisContext.parent != null) {
                                    refValue = thisContext.parent.object;
                                }
                            }
                            break block78;
                        }
                        if ("..".equals(ref)) {
                            ParseContext parentContext = context.parent;
                            if (parentContext.object != null) {
                                refValue = parentContext.object;
                            } else {
                                this.addResolveTask(new ResolveTask(parentContext, ref));
                                this.resolveStatus = 1;
                            }
                        } else if ("$".equals(ref)) {
                            rootContext = context;
                            while (rootContext.parent != null) {
                                rootContext = rootContext.parent;
                            }
                            if (rootContext.object != null) {
                                refValue = rootContext.object;
                            } else {
                                this.addResolveTask(new ResolveTask(rootContext, ref));
                                this.resolveStatus = 1;
                            }
                        } else {
                            this.addResolveTask(new ResolveTask(context, ref));
                            this.resolveStatus = 1;
                        }
                    }
                    if (lexer.token != 13) {
                        throw new JSONException("syntax error");
                    }
                    lexer.nextToken(16);
                    rootContext = refValue;
                    return rootContext;
                }
                if (!setContextFlag) {
                    ParseContext contextR = this.setContext(object, fieldName);
                    if (context == null) {
                        context = contextR;
                    }
                    setContextFlag = true;
                }
                if (object.getClass() == JSONObject.class) {
                    Object object2 = key = key == null ? "null" : key.toString();
                }
                if (ch == '\"') {
                    lexer.scanString();
                    String strValue = lexer.stringVal();
                    value = strValue;
                    if ((lexer.features & Feature.AllowISO8601DateFormat.mask) != 0) {
                        iso8601Lexer = new JSONLexer(strValue);
                        if (((JSONLexer)iso8601Lexer).scanISO8601DateIfMatch(true)) {
                            value = ((JSONLexer)iso8601Lexer).getCalendar().getTime();
                        }
                        ((JSONLexer)iso8601Lexer).close();
                    }
                    object.put(key, value);
                } else if (ch >= '0' && ch <= '9' || ch == '-') {
                    lexer.scanNumber();
                    if (lexer.token == 2) {
                        value = lexer.integerValue();
                    } else {
                        boolean useBigDecimal = (lexer.features & Feature.UseBigDecimal.mask) != 0;
                        value = lexer.decimalValue(useBigDecimal);
                    }
                    object.put(key, value);
                } else {
                    if (ch == '[') {
                        lexer.nextToken();
                        JSONArray list = new JSONArray();
                        this.parseArray(list, key);
                        value = list;
                        object.put(key, value);
                        if (lexer.token == 13) {
                            lexer.nextToken();
                            iso8601Lexer = object;
                            return iso8601Lexer;
                        }
                        if (lexer.token != 16) throw new JSONException("syntax error");
                        continue;
                    }
                    if (ch == '{') {
                        lexer.nextToken();
                        boolean parentIsArray = fieldName != null && fieldName.getClass() == Integer.class;
                        JSONObject input = new JSONObject();
                        ParseContext ctxLocal = null;
                        if (!parentIsArray) {
                            ctxLocal = this.setContext(context, input, key);
                        }
                        Object obj = this.parseObject(input, key);
                        if (ctxLocal != null && input != obj) {
                            ctxLocal.object = object;
                        }
                        this.checkMapResolve(object, key.toString());
                        if (object.getClass() == JSONObject.class) {
                            object.put(key.toString(), obj);
                        } else {
                            object.put(key, obj);
                        }
                        if (parentIsArray) {
                            this.setContext(context, obj, key);
                        }
                        if (lexer.token == 13) {
                            lexer.nextToken();
                            this.setContext(context);
                            Map map = object;
                            return map;
                        }
                        if (lexer.token != 16) throw new JSONException("syntax error, " + lexer.tokenName());
                        continue;
                    }
                    lexer.nextToken();
                    value = this.parse();
                    if (object.getClass() == JSONObject.class) {
                        key = key.toString();
                    }
                    object.put(key, value);
                    if (lexer.token == 13) {
                        lexer.nextToken();
                        Map map = object;
                        return map;
                    }
                    if (lexer.token != 16) throw new JSONException("syntax error, position at " + lexer.pos() + ", name " + key);
                    continue;
                }
                lexer.skipWhitespace();
                ch = lexer.ch;
                if (ch != ',') break;
                lexer.next();
            }
            if (ch != '}') throw new JSONException("syntax error, position at " + lexer.pos() + ", name " + key);
            lexer.next();
            lexer.resetStringPosition();
            lexer.nextToken();
            this.setContext(object, fieldName);
            Map map = object;
            return map;
        }
        finally {
            this.setContext(context);
        }
    }

    public <T> T parseObject(Class<T> clazz) {
        return this.parseObject((Type)clazz);
    }

    public <T> T parseObject(Type type) {
        if (this.lexer.token == 8) {
            this.lexer.nextToken();
            return null;
        }
        if (this.lexer.token == 4) {
            if ((type = TypeUtils.unwrap(type)) == byte[].class) {
                byte[] bytes = this.lexer.bytesValue();
                this.lexer.nextToken();
                return (T)bytes;
            }
            if (type == char[].class) {
                String strVal = this.lexer.stringVal();
                this.lexer.nextToken();
                return (T)strVal.toCharArray();
            }
        }
        ObjectDeserializer derializer = this.config.getDeserializer(type);
        try {
            return derializer.deserialze(this, type, null);
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public <T> List<T> parseArray(Class<T> clazz) {
        ArrayList array = new ArrayList();
        this.parseArray(clazz, array);
        return array;
    }

    public void parseArray(Class<?> clazz, Collection array) {
        this.parseArray((Type)clazz, array);
    }

    public void parseArray(Type type, Collection array) {
        this.parseArray(type, array, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseArray(Type type, Collection array, Object fieldName) {
        if (this.lexer.token == 21 || this.lexer.token == 22) {
            this.lexer.nextToken();
        }
        if (this.lexer.token != 14) {
            throw new JSONException("exepct '[', but " + JSONToken.name(this.lexer.token));
        }
        ObjectDeserializer deserializer = null;
        if (Integer.TYPE == type) {
            deserializer = IntegerCodec.instance;
            this.lexer.nextToken(2);
        } else if (String.class == type) {
            deserializer = StringCodec.instance;
            this.lexer.nextToken(4);
        } else {
            deserializer = this.config.getDeserializer(type);
            this.lexer.nextToken(12);
        }
        ParseContext context = this.context;
        this.setContext(array, fieldName);
        try {
            int i = 0;
            while (true) {
                Object val;
                if ((this.lexer.features & Feature.AllowArbitraryCommas.mask) != 0) {
                    while (this.lexer.token == 16) {
                        this.lexer.nextToken();
                    }
                }
                if (this.lexer.token == 15) {
                    break;
                }
                if (Integer.TYPE == type) {
                    val = IntegerCodec.instance.deserialze(this, null, null);
                    array.add(val);
                } else if (String.class == type) {
                    String value;
                    if (this.lexer.token == 4) {
                        value = this.lexer.stringVal();
                        this.lexer.nextToken(16);
                    } else {
                        Object obj = this.parse();
                        value = obj == null ? null : obj.toString();
                    }
                    array.add(value);
                } else {
                    if (this.lexer.token == 8) {
                        this.lexer.nextToken();
                        val = null;
                    } else {
                        val = deserializer.deserialze(this, type, i);
                    }
                    array.add(val);
                    this.checkListResolve(array);
                }
                if (this.lexer.token == 16) {
                    this.lexer.nextToken();
                }
                ++i;
            }
        }
        finally {
            this.setContext(context);
        }
        this.lexer.nextToken(16);
    }

    public Object[] parseArray(Type[] types) {
        if (this.lexer.token == 8) {
            this.lexer.nextToken(16);
            return null;
        }
        if (this.lexer.token != 14) {
            throw new JSONException("syntax error : " + this.lexer.tokenName());
        }
        Object[] list = new Object[types.length];
        if (types.length == 0) {
            this.lexer.nextToken(15);
            if (this.lexer.token != 15) {
                throw new JSONException("syntax error");
            }
            this.lexer.nextToken(16);
            return new Object[0];
        }
        this.lexer.nextToken(2);
        for (int i = 0; i < types.length; ++i) {
            Object value;
            if (this.lexer.token == 8) {
                value = null;
                this.lexer.nextToken(16);
            } else {
                Type type = types[i];
                if (type == Integer.TYPE || type == Integer.class) {
                    if (this.lexer.token == 2) {
                        value = this.lexer.intValue();
                        this.lexer.nextToken(16);
                    } else {
                        value = this.parse();
                        value = TypeUtils.cast(value, type, this.config);
                    }
                } else if (type == String.class) {
                    if (this.lexer.token == 4) {
                        value = this.lexer.stringVal();
                        this.lexer.nextToken(16);
                    } else {
                        value = this.parse();
                        value = TypeUtils.cast(value, type, this.config);
                    }
                } else {
                    boolean isArray = false;
                    Class<?> componentType = null;
                    if (i == types.length - 1 && type instanceof Class) {
                        Class clazz = (Class)type;
                        isArray = clazz.isArray();
                        componentType = clazz.getComponentType();
                    }
                    if (isArray && this.lexer.token != 14) {
                        ArrayList varList = new ArrayList();
                        ObjectDeserializer derializer = this.config.getDeserializer(componentType);
                        if (this.lexer.token != 15) {
                            while (true) {
                                Object item = derializer.deserialze(this, type, null);
                                varList.add(item);
                                if (this.lexer.token != 16) break;
                                this.lexer.nextToken(12);
                            }
                            if (this.lexer.token != 15) {
                                throw new JSONException("syntax error :" + JSONToken.name(this.lexer.token));
                            }
                        }
                        value = TypeUtils.cast(varList, type, this.config);
                    } else {
                        ObjectDeserializer derializer = this.config.getDeserializer(type);
                        value = derializer.deserialze(this, type, null);
                    }
                }
            }
            list[i] = value;
            if (this.lexer.token == 15) break;
            if (this.lexer.token != 16) {
                throw new JSONException("syntax error :" + JSONToken.name(this.lexer.token));
            }
            if (i == types.length - 1) {
                this.lexer.nextToken(15);
                continue;
            }
            this.lexer.nextToken(2);
        }
        if (this.lexer.token != 15) {
            throw new JSONException("syntax error");
        }
        this.lexer.nextToken(16);
        return list;
    }

    public void parseObject(Object object) {
        block14: {
            Class<?> clazz = object.getClass();
            Map<String, FieldDeserializer> setters = this.config.getFieldDeserializers(clazz);
            if (this.lexer.token != 12 && this.lexer.token != 16) {
                throw new JSONException("syntax error, expect {, actual " + this.lexer.tokenName());
            }
            while (true) {
                Object fieldValue;
                FieldDeserializer fieldDeser;
                String key;
                if ((key = this.lexer.scanSymbol(this.symbolTable)) == null) {
                    if (this.lexer.token != 13) {
                        if (this.lexer.token == 16 && (this.lexer.features & Feature.AllowArbitraryCommas.mask) != 0) continue;
                    }
                    break block14;
                }
                if ((fieldDeser = setters.get(key)) == null && key != null) {
                    for (Map.Entry<String, FieldDeserializer> entry : setters.entrySet()) {
                        if (!key.equalsIgnoreCase(entry.getKey())) continue;
                        fieldDeser = entry.getValue();
                        break;
                    }
                }
                if (fieldDeser == null) {
                    if ((this.lexer.features & Feature.IgnoreNotMatch.mask) == 0) {
                        throw new JSONException("setter not found, class " + clazz.getName() + ", property " + key);
                    }
                    this.lexer.nextTokenWithChar(':');
                    this.parse();
                    if (this.lexer.token != 13) continue;
                    this.lexer.nextToken();
                    return;
                }
                Class<?> fieldClass = fieldDeser.fieldInfo.fieldClass;
                Type fieldType = fieldDeser.fieldInfo.fieldType;
                if (fieldClass == Integer.TYPE) {
                    this.lexer.nextTokenWithChar(':');
                    fieldValue = IntegerCodec.instance.deserialze(this, fieldType, null);
                } else if (fieldClass == String.class) {
                    this.lexer.nextTokenWithChar(':');
                    fieldValue = StringCodec.deserialze(this);
                } else if (fieldClass == Long.TYPE) {
                    this.lexer.nextTokenWithChar(':');
                    fieldValue = IntegerCodec.instance.deserialze(this, fieldType, null);
                } else {
                    ObjectDeserializer fieldValueDeserializer = this.config.getDeserializer(fieldClass, fieldType);
                    this.lexer.nextTokenWithChar(':');
                    fieldValue = fieldValueDeserializer.deserialze(this, fieldType, null);
                }
                fieldDeser.setValue(object, fieldValue);
                if (this.lexer.token != 16 && this.lexer.token == 13) break;
            }
            this.lexer.nextToken(16);
            return;
        }
        this.lexer.nextToken(16);
    }

    public Object parseArrayWithType(Type collectionType) {
        if (this.lexer.token == 8) {
            this.lexer.nextToken();
            return null;
        }
        Type[] actualTypes = ((ParameterizedType)collectionType).getActualTypeArguments();
        if (actualTypes.length != 1) {
            throw new JSONException("not support type " + collectionType);
        }
        Type actualTypeArgument = actualTypes[0];
        if (actualTypeArgument instanceof Class) {
            ArrayList array = new ArrayList();
            this.parseArray((Class)actualTypeArgument, array);
            return array;
        }
        if (actualTypeArgument instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)actualTypeArgument;
            Type upperBoundType = wildcardType.getUpperBounds()[0];
            if (Object.class.equals((Object)upperBoundType)) {
                if (wildcardType.getLowerBounds().length == 0) {
                    return this.parse();
                }
                throw new JSONException("not support type : " + collectionType);
            }
            ArrayList array = new ArrayList();
            this.parseArray((Class)upperBoundType, array);
            return array;
        }
        if (actualTypeArgument instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)actualTypeArgument;
            Type[] bounds = typeVariable.getBounds();
            if (bounds.length != 1) {
                throw new JSONException("not support : " + typeVariable);
            }
            Type boundType = bounds[0];
            if (boundType instanceof Class) {
                ArrayList array = new ArrayList();
                this.parseArray((Class)boundType, array);
                return array;
            }
        }
        if (actualTypeArgument instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)actualTypeArgument;
            ArrayList array = new ArrayList();
            this.parseArray(parameterizedType, array);
            return array;
        }
        throw new JSONException("TODO : " + collectionType);
    }

    public Object getObject(String path) {
        for (int i = 0; i < this.contextArrayIndex; ++i) {
            if (!path.equals(this.contextArray[i].toString())) continue;
            return this.contextArray[i].object;
        }
        return null;
    }

    public void checkListResolve(Collection array) {
        if (this.resolveStatus == 1) {
            if (array instanceof List) {
                int index = array.size() - 1;
                List list = (List)array;
                ResolveTask task = this.getLastResolveTask();
                task.fieldDeserializer = new ResolveFieldDeserializer(this, list, index);
                task.ownerContext = this.context;
                this.resolveStatus = 0;
            } else {
                ResolveTask task = this.getLastResolveTask();
                task.fieldDeserializer = new ResolveFieldDeserializer(array);
                task.ownerContext = this.context;
                this.resolveStatus = 0;
            }
        }
    }

    public void checkMapResolve(Map object, String fieldName) {
        if (this.resolveStatus == 1) {
            ResolveFieldDeserializer fieldResolver = new ResolveFieldDeserializer(object, fieldName);
            ResolveTask task = this.getLastResolveTask();
            task.fieldDeserializer = fieldResolver;
            task.ownerContext = this.context;
            this.resolveStatus = 0;
        }
    }

    public Object parseObject(Map object) {
        return this.parseObject(object, null);
    }

    public JSONObject parseObject() {
        JSONObject object = new JSONObject();
        this.parseObject(object);
        return object;
    }

    public final void parseArray(Collection array) {
        this.parseArray(array, null);
    }

    public final void parseArray(Collection array, Object fieldName) {
        if (this.lexer.token == 21 || this.lexer.token == 22) {
            this.lexer.nextToken();
        }
        if (this.lexer.token != 14) {
            throw new JSONException("syntax error, expect [, actual " + JSONToken.name(this.lexer.token) + ", pos " + this.lexer.pos);
        }
        this.lexer.nextToken(4);
        ParseContext context = this.context;
        this.setContext(array, fieldName);
        try {
            int i = 0;
            while (true) {
                Object value;
                if ((this.lexer.features & Feature.AllowArbitraryCommas.mask) != 0) {
                    while (this.lexer.token == 16) {
                        this.lexer.nextToken();
                    }
                }
                switch (this.lexer.token) {
                    case 2: {
                        value = this.lexer.integerValue();
                        this.lexer.nextToken(16);
                        break;
                    }
                    case 3: {
                        value = (this.lexer.features & Feature.UseBigDecimal.mask) != 0 ? (Number)this.lexer.decimalValue(true) : (Number)this.lexer.decimalValue(false);
                        this.lexer.nextToken(16);
                        break;
                    }
                    case 4: {
                        String stringLiteral = this.lexer.stringVal();
                        this.lexer.nextToken(16);
                        if ((this.lexer.features & Feature.AllowISO8601DateFormat.mask) != 0) {
                            JSONLexer iso8601Lexer = new JSONLexer(stringLiteral);
                            value = iso8601Lexer.scanISO8601DateIfMatch(true) ? iso8601Lexer.getCalendar().getTime() : stringLiteral;
                            iso8601Lexer.close();
                            break;
                        }
                        value = stringLiteral;
                        break;
                    }
                    case 6: {
                        value = Boolean.TRUE;
                        this.lexer.nextToken(16);
                        break;
                    }
                    case 7: {
                        value = Boolean.FALSE;
                        this.lexer.nextToken(16);
                        break;
                    }
                    case 12: {
                        JSONObject object = new JSONObject();
                        value = this.parseObject(object, i);
                        break;
                    }
                    case 14: {
                        JSONArray items = new JSONArray();
                        this.parseArray(items, i);
                        value = items;
                        break;
                    }
                    case 8: {
                        value = null;
                        this.lexer.nextToken(4);
                        break;
                    }
                    case 23: {
                        value = null;
                        this.lexer.nextToken(4);
                        break;
                    }
                    case 15: {
                        this.lexer.nextToken(16);
                        return;
                    }
                    case 20: {
                        throw new JSONException("unclosed jsonArray");
                    }
                    default: {
                        value = this.parse();
                    }
                }
                array.add(value);
                this.checkListResolve(array);
                if (this.lexer.token == 16) {
                    this.lexer.nextToken(4);
                }
                ++i;
            }
        }
        finally {
            this.setContext(context);
        }
    }

    public ParseContext getContext() {
        return this.context;
    }

    public void addResolveTask(ResolveTask task) {
        if (this.resolveTaskList == null) {
            this.resolveTaskList = new ArrayList<ResolveTask>(2);
        }
        this.resolveTaskList.add(task);
    }

    public ResolveTask getLastResolveTask() {
        return this.resolveTaskList.get(this.resolveTaskList.size() - 1);
    }

    public List<ExtraProcessor> getExtraProcessors() {
        if (this.extraProcessors == null) {
            this.extraProcessors = new ArrayList<ExtraProcessor>(2);
        }
        return this.extraProcessors;
    }

    public List<ExtraTypeProvider> getExtraTypeProviders() {
        if (this.extraTypeProviders == null) {
            this.extraTypeProviders = new ArrayList<ExtraTypeProvider>(2);
        }
        return this.extraTypeProviders;
    }

    public void setContext(ParseContext context) {
        if ((this.lexer.features & Feature.DisableCircularReferenceDetect.mask) != 0) {
            return;
        }
        this.context = context;
    }

    public void popContext() {
        if ((this.lexer.features & Feature.DisableCircularReferenceDetect.mask) != 0) {
            return;
        }
        this.context = this.context.parent;
        this.contextArray[this.contextArrayIndex - 1] = null;
        --this.contextArrayIndex;
    }

    public ParseContext setContext(Object object, Object fieldName) {
        if ((this.lexer.features & Feature.DisableCircularReferenceDetect.mask) != 0) {
            return null;
        }
        return this.setContext(this.context, object, fieldName);
    }

    public ParseContext setContext(ParseContext parent, Object object, Object fieldName) {
        if ((this.lexer.features & Feature.DisableCircularReferenceDetect.mask) != 0) {
            return null;
        }
        this.context = new ParseContext(parent, object, fieldName);
        this.addContext(this.context);
        return this.context;
    }

    private void addContext(ParseContext context) {
        int i;
        if ((i = this.contextArrayIndex++) >= this.contextArray.length) {
            int newLen = this.contextArray.length * 3 / 2;
            ParseContext[] newArray = new ParseContext[newLen];
            System.arraycopy(this.contextArray, 0, newArray, 0, this.contextArray.length);
            this.contextArray = newArray;
        }
        this.contextArray[i] = context;
    }

    public Object parse() {
        return this.parse(null);
    }

    public Object parseKey() {
        if (this.lexer.token == 18) {
            String value = this.lexer.stringVal();
            this.lexer.nextToken(16);
            return value;
        }
        return this.parse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parse(Object fieldName) {
        switch (this.lexer.token) {
            case 21: {
                this.lexer.nextToken();
                HashSet set = new HashSet();
                this.parseArray(set, fieldName);
                return set;
            }
            case 22: {
                this.lexer.nextToken();
                TreeSet treeSet = new TreeSet();
                this.parseArray(treeSet, fieldName);
                return treeSet;
            }
            case 14: {
                JSONArray array = new JSONArray();
                this.parseArray(array, fieldName);
                return array;
            }
            case 12: {
                JSONObject object = new JSONObject();
                return this.parseObject(object, fieldName);
            }
            case 2: {
                Number intValue = this.lexer.integerValue();
                this.lexer.nextToken();
                return intValue;
            }
            case 3: {
                boolean useBigDecimal = (this.lexer.features & Feature.UseBigDecimal.mask) != 0;
                Number value = this.lexer.decimalValue(useBigDecimal);
                this.lexer.nextToken();
                return value;
            }
            case 4: {
                String stringLiteral = this.lexer.stringVal();
                this.lexer.nextToken(16);
                if ((this.lexer.features & Feature.AllowISO8601DateFormat.mask) != 0) {
                    JSONLexer iso8601Lexer = new JSONLexer(stringLiteral);
                    try {
                        if (iso8601Lexer.scanISO8601DateIfMatch(true)) {
                            Date date = iso8601Lexer.getCalendar().getTime();
                            return date;
                        }
                    }
                    finally {
                        iso8601Lexer.close();
                    }
                }
                return stringLiteral;
            }
            case 8: {
                this.lexer.nextToken();
                return null;
            }
            case 23: {
                this.lexer.nextToken();
                return null;
            }
            case 6: {
                this.lexer.nextToken();
                return Boolean.TRUE;
            }
            case 7: {
                this.lexer.nextToken();
                return Boolean.FALSE;
            }
            case 9: {
                this.lexer.nextToken(18);
                if (this.lexer.token != 18) {
                    throw new JSONException("syntax error");
                }
                this.lexer.nextToken(10);
                this.accept(10);
                long time = this.lexer.integerValue().longValue();
                this.accept(2);
                this.accept(11);
                return new Date(time);
            }
            case 20: {
                if (this.lexer.isBlankInput()) {
                    return null;
                }
                throw new JSONException("unterminated json string, pos " + this.lexer.bp);
            }
        }
        throw new JSONException("syntax error, pos " + this.lexer.bp);
    }

    public void config(Feature feature, boolean state) {
        this.lexer.config(feature, state);
    }

    public final void accept(int token) {
        if (this.lexer.token != token) {
            throw new JSONException("syntax error, expect " + JSONToken.name(token) + ", actual " + JSONToken.name(this.lexer.token));
        }
        this.lexer.nextToken();
    }

    public final void accept(int token, int nextExpectToken) {
        if (this.lexer.token != token) {
            throw new JSONException("syntax error, expect " + JSONToken.name(token) + ", actual " + JSONToken.name(this.lexer.token));
        }
        this.lexer.nextToken(nextExpectToken);
    }

    @Override
    public void close() {
        try {
            if ((this.lexer.features & Feature.AutoCloseSource.mask) != 0 && this.lexer.token != 20) {
                throw new JSONException("not close json text, token : " + JSONToken.name(this.lexer.token));
            }
        }
        finally {
            this.lexer.close();
        }
    }

    public void handleResovleTask(Object value) {
        if (this.resolveTaskList == null) {
            return;
        }
        int size = this.resolveTaskList.size();
        for (int i = 0; i < size; ++i) {
            String ref;
            ResolveTask task = this.resolveTaskList.get(i);
            FieldDeserializer fieldDeser = task.fieldDeserializer;
            if (fieldDeser == null) continue;
            Object object = null;
            if (task.ownerContext != null) {
                object = task.ownerContext.object;
            }
            Object refValue = (ref = task.referenceValue).startsWith("$") ? this.getObject(ref) : ((ResolveTask)task).context.object;
            fieldDeser.setValue(object, refValue);
        }
    }

    public static Type getExtratype(DefaultJSONParser parser, Object object, String key) {
        List<ExtraTypeProvider> extraTypeProviders = parser.extraTypeProviders;
        if (extraTypeProviders == null) {
            return null;
        }
        Type type = null;
        for (ExtraTypeProvider extraProvider : extraTypeProviders) {
            type = extraProvider.getExtraType(object, key);
        }
        return type;
    }

    public static void processExtra(DefaultJSONParser parser, Object object, String key, Object value) {
        List<ExtraProcessor> extraProcessors = parser.extraProcessors;
        if (extraProcessors == null) {
            return;
        }
        for (ExtraProcessor process : extraProcessors) {
            process.processExtra(object, key, value);
        }
    }

    public static class ResolveTask {
        private final ParseContext context;
        private final String referenceValue;
        public FieldDeserializer fieldDeserializer;
        public ParseContext ownerContext;

        public ResolveTask(ParseContext context, String referenceValue) {
            this.context = context;
            this.referenceValue = referenceValue;
        }
    }
}

