/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.constant;

import com.alibaba.excel.util.MapUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class BuiltinFormats {
    public static short GENERAL = 0;
    public static final String[] BUILTIN_FORMATS_CN = new String[]{"General", "0", "0.00", "#,##0", "#,##0.00", "\"\uffe5\"#,##0_);(\"\uffe5\"#,##0)", "\"\uffe5\"#,##0_);[Red](\"\uffe5\"#,##0)", "\"\uffe5\"#,##0.00_);(\"\uffe5\"#,##0.00)", "\"\uffe5\"#,##0.00_);[Red](\"\uffe5\"#,##0.00)", "0%", "0.00%", "0.00E+00", "# ?/?", "# ??/??", "yyyy/m/d", "d-mmm-yy", "d-mmm", "mmm-yy", "h:mm AM/PM", "h:mm:ss AM/PM", "h:mm", "h:mm:ss", "yyyy-m-d h:mm", null, null, null, null, "yyyy\"\u5e74\"m\"\u6708\"", "m\"\u6708\"d\"\u65e5\"", "m\"\u6708\"d\"\u65e5\"", "m-d-yy", "yyyy\"\u5e74\"m\"\u6708\"d\"\u65e5\"", "h\"\u65f6\"mm\"\u5206\"", "h\"\u65f6\"mm\"\u5206\"ss\"\u79d2\"", "\u4e0a\u5348/\u4e0b\u5348h\"\u65f6\"mm\"\u5206\"", "\u4e0a\u5348/\u4e0b\u5348h\"\u65f6\"mm\"\u5206\"ss\"\u79d2\"", "yyyy\"\u5e74\"m\"\u6708\"", "#,##0_);(#,##0)", "#,##0_);[Red](#,##0)", "#,##0.00_);(#,##0.00)", "#,##0.00_);[Red](#,##0.00)", "_(* #,##0_);_(* (#,##0);_(* \"-\"_);_(@_)", "_(\"\uffe5\"* #,##0_);_(\"\uffe5\"* (#,##0);_(\"\uffe5\"* \"-\"_);_(@_)", "_(* #,##0.00_);_(* (#,##0.00);_(* \"-\"??_);_(@_)", "_(\"\uffe5\"* #,##0.00_);_(\"\uffe5\"* (#,##0.00);_(\"\uffe5\"* \"-\"??_);_(@_)", "mm:ss", "[h]:mm:ss", "mm:ss.0", "##0.0E+0", "@", "yyyy\"\u5e74\"m\"\u6708\"", "m\"\u6708\"d\"\u65e5\"", "yyyy\"\u5e74\"m\"\u6708\"", "m\"\u6708\"d\"\u65e5\"", "m\"\u6708\"d\"\u65e5\"", "\u4e0a\u5348/\u4e0b\u5348h\"\u65f6\"mm\"\u5206\"", "\u4e0a\u5348/\u4e0b\u5348h\"\u65f6\"mm\"\u5206\"ss\"\u79d2\"", "yyyy\"\u5e74\"m\"\u6708\"", "m\"\u6708\"d\"\u65e5\"", "t0", "t0.00", "t#,##0", "t#,##0.00", null, null, null, null, "t0%", "t0.00%", "t# ?/?", "t# ??/??", "\u0e27/\u0e14/\u0e1b\u0e1b\u0e1b\u0e1b", "\u0e27-\u0e14\u0e14\u0e14-\u0e1b\u0e1b", "\u0e27-\u0e14\u0e14\u0e14", "\u0e14\u0e14\u0e14-\u0e1b\u0e1b", "\u0e0a:\u0e19\u0e19", "\u0e0a:\u0e19\u0e19:\u0e17\u0e17", "\u0e27/\u0e14/\u0e1b\u0e1b\u0e1b\u0e1b \u0e0a:\u0e19\u0e19", "\u0e19\u0e19:\u0e17\u0e17", "[\u0e0a]:\u0e19\u0e19:\u0e17\u0e17", "\u0e19\u0e19:\u0e17\u0e17.0", "d/m/bb"};
    public static final String[] BUILTIN_FORMATS_US = new String[]{"General", "0", "0.00", "#,##0", "#,##0.00", "\"$\"#,##0_);(\"$\"#,##0)", "\"$\"#,##0_);[Red](\"$\"#,##0)", "\"$\"#,##0.00_);(\"$\"#,##0.00)", "\"$\"#,##0.00_);[Red](\"$\"#,##0.00)", "0%", "0.00%", "0.00E+00", "# ?/?", "# ??/??", "yyyy/m/d", "d-mmm-yy", "d-mmm", "mmm-yy", "h:mm AM/PM", "h:mm:ss AM/PM", "h:mm", "h:mm:ss", "yyyy-m-d h:mm", null, null, null, null, "yyyy\"\u5e74\"m\"\u6708\"", "m\"\u6708\"d\"\u65e5\"", "m\"\u6708\"d\"\u65e5\"", "m-d-yy", "yyyy\"\u5e74\"m\"\u6708\"d\"\u65e5\"", "h\"\u65f6\"mm\"\u5206\"", "h\"\u65f6\"mm\"\u5206\"ss\"\u79d2\"", "\u4e0a\u5348/\u4e0b\u5348h\"\u65f6\"mm\"\u5206\"", "\u4e0a\u5348/\u4e0b\u5348h\"\u65f6\"mm\"\u5206\"ss\"\u79d2\"", "yyyy\"\u5e74\"m\"\u6708\"", "#,##0_);(#,##0)", "#,##0_);[Red](#,##0)", "#,##0.00_);(#,##0.00)", "#,##0.00_);[Red](#,##0.00)", "_(* #,##0_);_(* (#,##0);_(* \"-\"_);_(@_)", "_(\"$\"* #,##0_);_(\"$\"* (#,##0);_(\"$\"* \"-\"_);_(@_)", "_(* #,##0.00_);_(* (#,##0.00);_(* \"-\"??_);_(@_)", "_(\"$\"* #,##0.00_);_(\"$\"* (#,##0.00);_(\"$\"* \"-\"??_);_(@_)", "mm:ss", "[h]:mm:ss", "mm:ss.0", "##0.0E+0", "@", "yyyy\"\u5e74\"m\"\u6708\"", "m\"\u6708\"d\"\u65e5\"", "yyyy\"\u5e74\"m\"\u6708\"", "m\"\u6708\"d\"\u65e5\"", "m\"\u6708\"d\"\u65e5\"", "\u4e0a\u5348/\u4e0b\u5348h\"\u65f6\"mm\"\u5206\"", "\u4e0a\u5348/\u4e0b\u5348h\"\u65f6\"mm\"\u5206\"ss\"\u79d2\"", "yyyy\"\u5e74\"m\"\u6708\"", "m\"\u6708\"d\"\u65e5\"", "t0", "t0.00", "t#,##0", "t#,##0.00", null, null, null, null, "t0%", "t0.00%", "t# ?/?", "t# ??/??", "\u0e27/\u0e14/\u0e1b\u0e1b\u0e1b\u0e1b", "\u0e27-\u0e14\u0e14\u0e14-\u0e1b\u0e1b", "\u0e27-\u0e14\u0e14\u0e14", "\u0e14\u0e14\u0e14-\u0e1b\u0e1b", "\u0e0a:\u0e19\u0e19", "\u0e0a:\u0e19\u0e19:\u0e17\u0e17", "\u0e27/\u0e14/\u0e1b\u0e1b\u0e1b\u0e1b \u0e0a:\u0e19\u0e19", "\u0e19\u0e19:\u0e17\u0e17", "[\u0e0a]:\u0e19\u0e19:\u0e17\u0e17", "\u0e19\u0e19:\u0e17\u0e17.0", "d/m/bb"};
    public static final Map<String, Short> BUILTIN_FORMATS_MAP_CN = BuiltinFormats.buildMap(BUILTIN_FORMATS_CN);
    public static final Map<String, Short> BUILTIN_FORMATS_MAP_US = BuiltinFormats.buildMap(BUILTIN_FORMATS_US);
    public static final short MIN_CUSTOM_DATA_FORMAT_INDEX = 82;

    public static String getBuiltinFormat(Short index, String defaultFormat, Locale locale) {
        String[] builtinFormat = BuiltinFormats.switchBuiltinFormats(locale);
        if (index == null || index < 0 || index >= builtinFormat.length) {
            return defaultFormat;
        }
        return builtinFormat[index];
    }

    public static String[] switchBuiltinFormats(Locale locale) {
        if (locale != null && Locale.US.getCountry().equals(locale.getCountry())) {
            return BUILTIN_FORMATS_US;
        }
        return BUILTIN_FORMATS_CN;
    }

    public static Map<String, Short> switchBuiltinFormatsMap(Locale locale) {
        if (locale != null && Locale.US.getCountry().equals(locale.getCountry())) {
            return BUILTIN_FORMATS_MAP_US;
        }
        return BUILTIN_FORMATS_MAP_CN;
    }

    private static Map<String, Short> buildMap(String[] builtinFormats) {
        HashMap<String, Short> map = MapUtils.newHashMapWithExpectedSize(builtinFormats.length);
        for (int i = 0; i < builtinFormats.length; ++i) {
            map.put(builtinFormats[i], (short)i);
        }
        return map;
    }
}

