/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.hologres.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.clickhouse.ast.CKSelectQueryBlock;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGOutputVisitor;
import com.alibaba.druid.sql.parser.CharTypes;
import com.alibaba.druid.sql.visitor.VisitorFeature;
import java.util.List;

public class HologresOutputVisitor
extends PGOutputVisitor {
    public HologresOutputVisitor(StringBuilder appender, boolean parameterized) {
        super(appender, DbType.hologres, parameterized);
    }

    public HologresOutputVisitor(StringBuilder appender) {
        super(appender, DbType.hologres);
    }

    @Override
    protected void printPartitionBy(SQLCreateTableStatement x) {
        SQLPartitionBy partitionBy = x.getPartitioning();
        if (partitionBy == null) {
            return;
        }
        this.println();
        if (partitionBy.getLogical() != null && partitionBy.getLogical().booleanValue()) {
            this.print0(this.ucase ? "LOGICAL " : "logical ");
        }
        this.print0(this.ucase ? "PARTITION BY " : "partition by ");
        partitionBy.accept(this);
    }

    @Override
    protected void printFrom(SQLSelectQueryBlock x) {
        SQLTableSource from = x.getFrom();
        if (from == null) {
            return;
        }
        List<String> beforeComments = from.getBeforeCommentsDirect();
        if (beforeComments != null) {
            for (String comment : beforeComments) {
                this.println();
                this.print0(comment);
            }
        }
        super.printFrom(x);
        if (x instanceof CKSelectQueryBlock && ((CKSelectQueryBlock)x).isFinal()) {
            this.print0(this.ucase ? " FINAL" : " final");
        }
    }

    @Override
    public void printComment(String comment) {
        if (comment == null) {
            return;
        }
        if (this.isEnabled(VisitorFeature.OutputSkipMultilineComment) && comment.startsWith("/*")) {
            return;
        }
        if (this.isEnabled(VisitorFeature.OutputSkipSingleLineComment) && (comment.startsWith("-") || comment.startsWith("#"))) {
            return;
        }
        if (comment.startsWith("--") && comment.length() > 2 && comment.charAt(2) != ' ' && comment.charAt(2) != '-') {
            this.print0("-- ");
            this.print0(comment.substring(2));
        } else if (comment.startsWith("#") && comment.length() > 1 && comment.charAt(1) != ' ' && comment.charAt(1) != '#') {
            this.print0("# ");
            this.print0(comment.substring(1));
        } else if (comment.startsWith("/*")) {
            this.println();
            this.print0(comment);
        } else if (comment.startsWith("--")) {
            this.print0(comment);
        }
        int first = 0;
        for (int i = 0; i < comment.length(); ++i) {
            char c = comment.charAt(i);
            if (CharTypes.isWhitespace(c)) continue;
            first = c;
            break;
        }
        if (first == 45 || first == 35) {
            this.endLineComment = true;
        }
    }
}

