/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.statement.SQLTableSourceImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLUnnestTableSource
extends SQLTableSourceImpl
implements SQLReplaceable {
    private final List<SQLExpr> items = new ArrayList<SQLExpr>();
    protected List<SQLName> columns = new ArrayList<SQLName>();
    private boolean ordinality;
    private SQLExpr offset;

    @Override
    protected void accept0(SQLASTVisitor v) {
        if (v.visit(this)) {
            this.acceptChild(v, this.items);
            this.acceptChild(v, this.columns);
            this.acceptChild(v, this.offset);
            super.accept0(v);
        }
        v.endVisit(this);
    }

    public List<SQLName> getColumns() {
        return this.columns;
    }

    public void addColumn(SQLName column) {
        column.setParent(this);
        this.columns.add(column);
    }

    public boolean isOrdinality() {
        return this.ordinality;
    }

    public void setOrdinality(boolean ordinality) {
        this.ordinality = ordinality;
    }

    public List<SQLExpr> getItems() {
        return this.items;
    }

    public void addItem(SQLExpr item) {
        item.setParent(this);
        this.items.add(item);
    }

    public void setItem(int i, SQLExpr item) {
        this.items.set(i, item);
    }

    public SQLExpr getOffset() {
        return this.offset;
    }

    public void setOffset(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.offset = x;
    }

    @Override
    public SQLUnnestTableSource clone() {
        SQLUnnestTableSource x = new SQLUnnestTableSource();
        for (SQLExpr item : this.items) {
            SQLExpr item2 = item.clone();
            item2.setParent(x);
            x.items.add(item2);
        }
        for (SQLName column : this.columns) {
            SQLName c2 = column.clone();
            c2.setParent(x);
            x.columns.add(c2);
        }
        x.alias = this.alias;
        if (this.offset != null) {
            x.setOffset(this.offset);
        }
        return x;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) != expr) continue;
            target.setParent(this);
            this.items.set(i, target);
            return true;
        }
        if (target instanceof SQLName) {
            SQLName targetName = (SQLName)target;
            for (int i = 0; i < this.columns.size(); ++i) {
                if (this.columns.get(i) != expr) continue;
                target.setParent(this);
                this.columns.set(i, targetName);
                return true;
            }
        }
        return false;
    }
}

