/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.FastsqlColumnAmbiguousException;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSourceImpl;
import com.alibaba.druid.sql.repository.SchemaResolveVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.FnvHash;
import java.util.ArrayList;
import java.util.List;

public class SQLJoinTableSource
extends SQLTableSourceImpl
implements SQLReplaceable {
    protected SQLTableSource left;
    protected JoinType joinType;
    protected SQLTableSource right;
    protected SQLExpr condition;
    protected final List<SQLExpr> using = new ArrayList<SQLExpr>();
    protected boolean natural;
    protected UDJ udj;
    protected boolean asof;
    protected boolean global;

    public SQLJoinTableSource(String alias) {
        super(alias);
    }

    public SQLJoinTableSource() {
    }

    public SQLJoinTableSource(SQLTableSource left, JoinType joinType, SQLTableSource right, SQLExpr condition) {
        this.setLeft(left);
        this.setJoinType(joinType);
        this.setRight(right);
        this.setCondition(condition);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.left);
            this.acceptChild(visitor, this.right);
            this.acceptChild(visitor, this.condition);
            this.acceptChild(visitor, this.using);
            this.acceptChild(visitor, this.udj);
            super.accept0(visitor);
        }
        visitor.endVisit(this);
    }

    public UDJ getUdj() {
        return this.udj;
    }

    public void setUdj(UDJ x) {
        if (x != null) {
            x.setParent(this);
        }
        this.udj = x;
    }

    public boolean isAsof() {
        return this.asof;
    }

    public void setAsof(boolean asof) {
        this.asof = asof;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public void setJoinType(JoinType joinType) {
        this.joinType = joinType;
    }

    public void setImplicitJoinToCross() {
        if (this.joinType == JoinType.COMMA) {
            this.joinType = JoinType.CROSS_JOIN;
        }
        if (this.left instanceof SQLJoinTableSource) {
            ((SQLJoinTableSource)this.left).setImplicitJoinToCross();
        }
        if (this.right instanceof SQLJoinTableSource) {
            ((SQLJoinTableSource)this.right).setImplicitJoinToCross();
        }
    }

    public SQLTableSource getLeft() {
        return this.left;
    }

    public void setLeft(SQLTableSource left) {
        if (left != null) {
            left.setParent(this);
        }
        this.left = left;
    }

    public void setLeft(String tableName, String alias) {
        SQLExprTableSource tableSource = tableName == null || tableName.length() == 0 ? null : new SQLExprTableSource(new SQLIdentifierExpr(tableName), alias);
        this.setLeft(tableSource);
    }

    public void setRight(String tableName, String alias) {
        SQLExprTableSource tableSource = tableName == null || tableName.length() == 0 ? null : new SQLExprTableSource(new SQLIdentifierExpr(tableName), alias);
        this.setRight(tableSource);
    }

    public SQLTableSource getRight() {
        return this.right;
    }

    public void setRight(SQLTableSource right) {
        if (right != null) {
            right.setParent(this);
        }
        this.right = right;
    }

    public SQLExpr getCondition() {
        return this.condition;
    }

    public void setCondition(SQLExpr condition) {
        if (condition != null) {
            condition.setParent(this);
        }
        this.condition = condition;
    }

    public void addCondition(SQLExpr condition) {
        if (this.condition == null) {
            this.condition = condition;
            this.setImplicitJoinToCross();
            return;
        }
        this.condition = SQLBinaryOpExpr.and(this.condition, condition);
    }

    public void addConditionnIfAbsent(SQLExpr condition) {
        if (this.containsCondition(condition)) {
            return;
        }
        this.condition = SQLBinaryOpExpr.and(this.condition, condition);
    }

    public boolean containsCondition(SQLExpr condition) {
        if (this.condition == null) {
            return false;
        }
        if (this.condition.equals(condition)) {
            return false;
        }
        if (this.condition instanceof SQLBinaryOpExpr) {
            return ((SQLBinaryOpExpr)this.condition).contains(condition);
        }
        return false;
    }

    public List<SQLExpr> getUsing() {
        return this.using;
    }

    public boolean isNatural() {
        return this.natural;
    }

    public void setNatural(boolean natural) {
        this.natural = natural;
    }

    @Override
    public void output(StringBuilder buf) {
        this.left.output(buf);
        buf.append(' ');
        buf.append(JoinType.toString(this.joinType));
        buf.append(' ');
        this.right.output(buf);
        if (this.condition != null) {
            buf.append(" ON ");
            this.condition.output(buf);
        }
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (this.condition == expr) {
            this.setCondition(target);
            return true;
        }
        for (int i = 0; i < this.using.size(); ++i) {
            if (this.using.get(i) != expr) continue;
            target.setParent(this);
            this.using.set(i, target);
            return true;
        }
        return false;
    }

    public boolean replace(SQLTableSource cmp, SQLTableSource target) {
        if (this.left == cmp) {
            if (target == null) {
                SQLUtils.replaceInParent(this, this.right);
            } else {
                this.setLeft(target);
            }
            return true;
        }
        if (this.right == cmp) {
            if (target == null) {
                SQLUtils.replaceInParent(this, this.left);
            } else {
                this.setRight(target);
            }
            return true;
        }
        return false;
    }

    public void cloneTo(SQLJoinTableSource x) {
        x.alias = this.alias;
        if (this.left != null) {
            x.setLeft(this.left.clone());
        }
        x.joinType = this.joinType;
        if (this.right != null) {
            x.setRight(this.right.clone());
        }
        if (this.condition != null) {
            x.setCondition(this.condition.clone());
        }
        for (SQLExpr item : this.using) {
            SQLExpr item2 = item.clone();
            item2.setParent(x);
            x.using.add(item2);
        }
        x.natural = this.natural;
        x.asof = this.asof;
        if (this.udj != null) {
            x.udj = this.udj.clone();
        }
    }

    @Override
    public SQLJoinTableSource clone() {
        SQLJoinTableSource x = new SQLJoinTableSource();
        this.cloneTo(x);
        return x;
    }

    public void reverse() {
        SQLTableSource temp = this.left;
        this.left = this.right;
        this.right = temp;
        if (this.left instanceof SQLJoinTableSource) {
            ((SQLJoinTableSource)this.left).reverse();
        }
        if (this.right instanceof SQLJoinTableSource) {
            ((SQLJoinTableSource)this.right).reverse();
        }
    }

    public void rearrangement() {
        if (this.joinType != JoinType.COMMA && this.joinType != JoinType.INNER_JOIN) {
            return;
        }
        if (this.right instanceof SQLJoinTableSource) {
            SQLBinaryOpExpr on_ab_binaryOpExpr;
            SQLJoinTableSource rightJoin = (SQLJoinTableSource)this.right;
            if (rightJoin.joinType != JoinType.COMMA && rightJoin.joinType != JoinType.INNER_JOIN) {
                return;
            }
            SQLTableSource a = this.left;
            SQLTableSource b = rightJoin.getLeft();
            SQLTableSource c = rightJoin.getRight();
            SQLExpr on_ab = this.condition;
            SQLExpr on_bc = rightJoin.condition;
            this.setLeft(rightJoin);
            rightJoin.setLeft(a);
            rightJoin.setRight(b);
            boolean on_ab_match = false;
            if (on_ab instanceof SQLBinaryOpExpr && (on_ab_binaryOpExpr = (SQLBinaryOpExpr)on_ab).getLeft() instanceof SQLPropertyExpr && on_ab_binaryOpExpr.getRight() instanceof SQLPropertyExpr) {
                String leftOwnerName = ((SQLPropertyExpr)on_ab_binaryOpExpr.getLeft()).getOwnernName();
                String rightOwnerName = ((SQLPropertyExpr)on_ab_binaryOpExpr.getRight()).getOwnernName();
                if (rightJoin.containsAlias(leftOwnerName) && rightJoin.containsAlias(rightOwnerName)) {
                    on_ab_match = true;
                }
            }
            if (on_ab_match) {
                rightJoin.setCondition(on_ab);
            } else {
                rightJoin.setCondition(null);
                on_bc = SQLBinaryOpExpr.and(on_bc, on_ab);
            }
            this.setRight(c);
            this.setCondition(on_bc);
        }
    }

    public boolean contains(SQLTableSource tableSource, SQLExpr condition) {
        if (this.right.equals(tableSource)) {
            if (this.condition == condition) {
                return true;
            }
            return this.condition != null && this.condition.equals(condition);
        }
        if (this.left instanceof SQLJoinTableSource) {
            SQLJoinTableSource joinLeft = (SQLJoinTableSource)this.left;
            if (tableSource instanceof SQLJoinTableSource) {
                SQLJoinTableSource join = (SQLJoinTableSource)tableSource;
                if (join.right.equals(this.right) && this.condition.equals(condition) && joinLeft.right.equals(join.left)) {
                    return true;
                }
            }
            return joinLeft.contains(tableSource, condition);
        }
        return false;
    }

    public boolean contains(SQLTableSource tableSource, SQLExpr condition, JoinType joinType) {
        if (this.right.equals(tableSource)) {
            if (this.condition == condition) {
                return true;
            }
            return this.condition != null && this.condition.equals(condition) && this.joinType == joinType;
        }
        if (this.left instanceof SQLJoinTableSource) {
            SQLJoinTableSource joinLeft = (SQLJoinTableSource)this.left;
            if (tableSource instanceof SQLJoinTableSource) {
                SQLJoinTableSource join = (SQLJoinTableSource)tableSource;
                if (join.right.equals(this.right) && this.condition != null && this.condition.equals(join.condition) && joinLeft.right.equals(join.left) && this.joinType == join.joinType && joinLeft.condition != null && joinLeft.condition.equals(condition) && joinLeft.joinType == joinType) {
                    return true;
                }
            }
            return joinLeft.contains(tableSource, condition, joinType);
        }
        return false;
    }

    public SQLJoinTableSource findJoin(SQLTableSource tableSource, JoinType joinType) {
        if (this.right.equals(tableSource)) {
            if (this.joinType == joinType) {
                return this;
            }
            return null;
        }
        if (this.left instanceof SQLJoinTableSource) {
            return ((SQLJoinTableSource)this.left).findJoin(tableSource, joinType);
        }
        return null;
    }

    @Override
    public boolean containsAlias(String alias) {
        if (SQLUtils.nameEquals(this.alias, alias)) {
            return true;
        }
        if (this.left != null && this.left.containsAlias(alias)) {
            return true;
        }
        return this.right != null && this.right.containsAlias(alias);
    }

    @Override
    public SQLColumnDefinition findColumn(String columnName) {
        long hash = FnvHash.hashCode64(columnName);
        return this.findColumn(hash);
    }

    @Override
    public SQLColumnDefinition findColumn(long columnNameHash) {
        SQLObject column = this.resolveColum(columnNameHash);
        if (column instanceof SQLColumnDefinition) {
            return (SQLColumnDefinition)column;
        }
        return null;
    }

    @Override
    public SQLObject resolveColumn(long columnNameHash) {
        SQLObject column;
        if (this.left != null && (column = this.left.resolveColum(columnNameHash)) != null) {
            return column;
        }
        if (this.right != null) {
            return this.right.resolveColum(columnNameHash);
        }
        return null;
    }

    @Override
    public SQLTableSource findTableSourceWithColumn(String columnName) {
        long hash = FnvHash.hashCode64(columnName);
        return this.findTableSourceWithColumn(hash, columnName, 0);
    }

    public SQLJoinTableSource findTableSourceWithColumn(SQLName a, SQLName b) {
        if (this.left.findTableSourceWithColumn(a) != null && this.right.findTableSourceWithColumn(b) != null) {
            return this;
        }
        if (this.right.findTableSourceWithColumn(a) != null && this.left.findTableSourceWithColumn(b) != null) {
            return this;
        }
        if (this.left instanceof SQLJoinTableSource) {
            return ((SQLJoinTableSource)this.left).findTableSourceWithColumn(a, b);
        }
        if (this.right instanceof SQLJoinTableSource) {
            return ((SQLJoinTableSource)this.right).findTableSourceWithColumn(a, b);
        }
        return null;
    }

    @Override
    public SQLTableSource findTableSourceWithColumn(long columnNameHash, String name, int option) {
        boolean checkColumnAmbiguous;
        SQLTableSource leftMatch = null;
        if (this.left != null) {
            leftMatch = this.left.findTableSourceWithColumn(columnNameHash, name, option);
        }
        boolean bl = checkColumnAmbiguous = (option & SchemaResolveVisitor.Option.CheckColumnAmbiguous.mask) != 0;
        if (leftMatch != null && !checkColumnAmbiguous) {
            return leftMatch;
        }
        SQLTableSource rightMatch = null;
        if (this.right != null) {
            rightMatch = this.right.findTableSourceWithColumn(columnNameHash, name, option);
        }
        if (leftMatch == null) {
            return rightMatch;
        }
        if (rightMatch == null) {
            return leftMatch;
        }
        if (name != null) {
            String msg = "Column '" + name + "' is ambiguous";
            throw new FastsqlColumnAmbiguousException(msg);
        }
        throw new FastsqlColumnAmbiguousException();
    }

    public boolean match(String alias_a, String alias_b) {
        if (this.left == null || this.right == null) {
            return false;
        }
        if (this.left.containsAlias(alias_a) && this.right.containsAlias(alias_b)) {
            return true;
        }
        return this.right.containsAlias(alias_a) && this.left.containsAlias(alias_b);
    }

    public boolean conditionContainsTable(String alias) {
        if (this.condition == null) {
            return false;
        }
        if (this.condition instanceof SQLBinaryOpExpr) {
            return ((SQLBinaryOpExpr)this.condition).conditionContainsTable(alias);
        }
        return false;
    }

    public SQLJoinTableSource join(SQLTableSource right, JoinType joinType, SQLExpr condition) {
        SQLJoinTableSource joined = new SQLJoinTableSource(this, joinType, right, condition);
        return joined;
    }

    @Override
    public SQLTableSource findTableSource(long alias_hash) {
        if (alias_hash == 0L) {
            return null;
        }
        if (this.aliasHashCode64() == alias_hash) {
            return this;
        }
        SQLTableSource result = this.left.findTableSource(alias_hash);
        if (result != null) {
            return result;
        }
        return this.right.findTableSource(alias_hash);
    }

    public SQLTableSource other(SQLTableSource x) {
        if (this.left == x) {
            return this.right;
        }
        if (this.right == x) {
            return this.left;
        }
        return null;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    @Override
    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.joinType != null ? this.joinType.hashCode() : 0);
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
        result = 31 * result + this.using.hashCode();
        result = 31 * result + (this.natural ? 1 : 0);
        result = 31 * result + (this.global ? 1 : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SQLJoinTableSource that = (SQLJoinTableSource)o;
        if (this.natural != that.natural) {
            return false;
        }
        if (this.asof != that.asof) {
            return false;
        }
        if (this.global != that.global) {
            return false;
        }
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        if (this.joinType != that.joinType) {
            return false;
        }
        if (this.right != null ? !this.right.equals(that.right) : that.right != null) {
            return false;
        }
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        if (this.using != null ? !this.using.equals(that.using) : that.using != null) {
            return false;
        }
        return this.udj != null ? this.udj.equals(that.udj) : that.udj == null;
    }

    public void splitTo(List<SQLTableSource> outTableSources, JoinType joinType) {
        if (joinType == this.joinType) {
            if (this.left instanceof SQLJoinTableSource) {
                ((SQLJoinTableSource)this.left).splitTo(outTableSources, joinType);
            } else {
                outTableSources.add(this.left);
            }
            if (this.right instanceof SQLJoinTableSource) {
                ((SQLJoinTableSource)this.right).splitTo(outTableSources, joinType);
            } else {
                outTableSources.add(this.right);
            }
        } else {
            outTableSources.add(this);
        }
    }

    public static class UDJ
    extends SQLObjectImpl {
        protected SQLExpr function;
        protected final List<SQLExpr> arguments = new ArrayList<SQLExpr>();
        protected String alias;
        protected final List<SQLName> columns = new ArrayList<SQLName>();
        protected List<SQLSelectOrderByItem> sortBy = new ArrayList<SQLSelectOrderByItem>();
        protected List<SQLAssignItem> properties = new ArrayList<SQLAssignItem>();

        public UDJ() {
        }

        @Override
        protected void accept0(SQLASTVisitor v) {
            if (v.visit(this)) {
                this.acceptChild(v, this.arguments);
                this.acceptChild(v, this.columns);
            }
            v.endVisit(this);
        }

        public List<SQLSelectOrderByItem> getSortBy() {
            return this.sortBy;
        }

        public UDJ(SQLExpr function) {
            this.function = function;
        }

        @Override
        public UDJ clone() {
            SQLExpr t;
            UDJ x = new UDJ();
            x.function = this.function.clone();
            for (SQLExpr arg : this.arguments) {
                t = arg.clone();
                t.setParent(x);
                x.arguments.add(t);
            }
            x.alias = this.alias;
            for (SQLName column : this.columns) {
                t = column.clone();
                t.setParent(x);
                x.columns.add((SQLName)t);
            }
            for (SQLAssignItem property : this.properties) {
                SQLAssignItem c = property.clone();
                c.setParent(x);
                x.properties.add(c);
            }
            return x;
        }

        public SQLExpr getFunction() {
            return this.function;
        }

        public void setFunction(SQLExpr function) {
            this.function = function;
        }

        public List<SQLExpr> getArguments() {
            return this.arguments;
        }

        public List<SQLName> getColumns() {
            return this.columns;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public List<SQLAssignItem> getProperties() {
            return this.properties;
        }
    }

    public static enum JoinType {
        COMMA(","),
        JOIN("JOIN"),
        INNER_JOIN("INNER JOIN"),
        CROSS_JOIN("CROSS JOIN"),
        NATURAL_JOIN("NATURAL JOIN"),
        NATURAL_CROSS_JOIN("NATURAL CROSS JOIN"),
        NATURAL_LEFT_JOIN("NATURAL LEFT JOIN"),
        NATURAL_RIGHT_JOIN("NATURAL RIGHT JOIN"),
        NATURAL_INNER_JOIN("NATURAL INNER JOIN"),
        LEFT_OUTER_JOIN("LEFT JOIN"),
        LEFT_SEMI_JOIN("LEFT SEMI JOIN"),
        LEFT_ANTI_JOIN("LEFT ANTI JOIN"),
        ARRAY_JOIN("ARRAY JOIN"),
        LEFT_ARRAY_JOIN("LEFT ARRAY JOIN"),
        RIGHT_OUTER_JOIN("RIGHT JOIN"),
        FULL_OUTER_JOIN("FULL JOIN"),
        STRAIGHT_JOIN("STRAIGHT_JOIN"),
        OUTER_APPLY("OUTER APPLY"),
        CROSS_APPLY("CROSS APPLY");

        public final String name;
        public final String nameLCase;

        private JoinType(String name) {
            this.name = name;
            this.nameLCase = name.toLowerCase();
        }

        public static String toString(JoinType joinType) {
            return joinType.name;
        }
    }
}

