/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.Collections;
import java.util.List;

public class SQLRealExpr
extends SQLNumericLiteralExpr
implements SQLValuableExpr {
    public SQLRealExpr() {
        super(new SQLDataTypeImpl("REAL"));
    }

    public SQLRealExpr(float value) {
        this();
        this.value = Float.valueOf(value);
    }

    public SQLRealExpr(String value) {
        this();
        this.value = Float.valueOf(value);
    }

    @Override
    public SQLRealExpr clone() {
        return new SQLRealExpr(this.getValue().floatValue());
    }

    @Override
    public List<SQLObject> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public Number getNumber() {
        return this.getValue();
    }

    @Override
    public Float getValue() {
        return (Float)this.value;
    }

    public void setValue(Float value) {
        this.value = value;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public void setValue(float value) {
        this.value = Float.valueOf(value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLRealExpr that = (SQLRealExpr)o;
        return Float.compare(that.getValue().floatValue(), this.getValue().floatValue()) == 0;
    }

    @Override
    public int hashCode() {
        return this.getValue().floatValue() != 0.0f ? Float.floatToIntBits(this.getValue().floatValue()) : 0;
    }

    @Override
    public void setNumber(Number number) {
        if (number == null) {
            this.value = null;
            return;
        }
        this.setValue(number.floatValue());
    }
}

