/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.expr.SQLDateTypeExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class SQLDateTimeExpr
extends SQLDateTypeExpr {
    public static long supportDbTypes = DbType.of(DbType.mysql, DbType.oracle, DbType.presto, DbType.trino, DbType.postgresql, DbType.mariadb, DbType.tidb, DbType.polardbx);

    public SQLDateTimeExpr() {
        super(new SQLDataTypeImpl("DATETIME"));
    }

    public SQLDateTimeExpr(Date now, TimeZone timeZone) {
        this();
        this.setValue(now, timeZone);
    }

    public void setValue(Date x, TimeZone timeZone) {
        if (x == null) {
            this.value = null;
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (timeZone != null) {
            format.setTimeZone(timeZone);
        }
        String text = format.format(x);
        this.setValue(text);
    }

    public SQLDateTimeExpr(String literal) {
        this();
        this.setValue(literal);
    }

    public void setValue(String literal) {
        this.value = literal;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.dataType);
        }
        visitor.endVisit(this);
    }

    @Override
    public String getValue() {
        return (String)this.value;
    }

    @Override
    public SQLDateTimeExpr clone() {
        SQLDateTimeExpr x = new SQLDateTimeExpr();
        x.value = this.value;
        return x;
    }

    public static boolean isSupport(DbType dbType) {
        return (dbType.mask & supportDbTypes) != 0L;
    }

    public static boolean check(String str) {
        if (str == null || str.length() != 8) {
            return false;
        }
        if (str.charAt(2) != ':' && str.charAt(5) != ':') {
            return false;
        }
        char c0 = str.charAt(0);
        char c1 = str.charAt(1);
        char c3 = str.charAt(3);
        char c4 = str.charAt(4);
        char c6 = str.charAt(6);
        char c7 = str.charAt(7);
        if (c0 < '0' || c0 > '9') {
            return false;
        }
        if (c1 < '0' || c1 > '9') {
            return false;
        }
        if (c3 < '0' || c3 > '9') {
            return false;
        }
        if (c4 < '0' || c4 > '9') {
            return false;
        }
        if (c6 < '0' || c6 > '9') {
            return false;
        }
        if (c7 < '0' || c7 > '9') {
            return false;
        }
        int HH = (c0 - 48) * 10 + (c1 - 48);
        int mm = (c3 - 48) * 10 + (c4 - 48);
        int ss = (c6 - 48) * 10 + (c7 - 48);
        return HH <= 24 && mm <= 60 && ss <= 60;
    }
}

