/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.postgresql.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLSizeExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLTableSampling;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGFunctionTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectQueryBlock;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGExprParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectListCache;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.Arrays;
import java.util.List;

public class PGSelectParser
extends SQLSelectParser {
    public PGSelectParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    public PGSelectParser(SQLExprParser exprParser, SQLSelectListCache selectListCache) {
        super(exprParser, selectListCache);
    }

    public PGSelectParser(String sql) {
        this(new PGExprParser(sql));
    }

    protected SQLExprParser createExprParser() {
        return new PGExprParser(this.lexer);
    }

    @Override
    public SQLSelectQuery query(SQLObject parent, boolean acceptUnion) {
        if (this.lexer.token() == Token.VALUES) {
            return this.valuesQuery(acceptUnion);
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLSelectQuery select = this.query();
            if (select instanceof SQLSelectQueryBlock) {
                ((SQLSelectQueryBlock)select).setParenthesized(true);
            }
            this.accept(Token.RPAREN);
            return this.queryRest(select, acceptUnion);
        }
        PGSelectQueryBlock queryBlock = new PGSelectQueryBlock();
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            queryBlock.addBeforeComment(this.lexer.readAndResetComments());
        }
        if (this.lexer.token() == Token.SELECT) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.DISTINCT) {
                queryBlock.setDistionOption(2);
                this.lexer.nextToken();
                if (this.lexer.token() == Token.ON) {
                    this.lexer.nextToken();
                    while (true) {
                        SQLExpr expr = this.createExprParser().expr();
                        queryBlock.getDistinctOn().add(expr);
                        if (this.lexer.token() == Token.COMMA) {
                            this.lexer.nextToken();
                            continue;
                        }
                        break;
                    }
                }
            } else if (this.lexer.token() == Token.ALL) {
                queryBlock.setDistionOption(1);
                this.lexer.nextToken();
            }
            this.parseSelectList(queryBlock);
            if (this.lexer.token() == Token.INTO) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.TEMPORARY) {
                    this.lexer.nextToken();
                    queryBlock.setIntoOption(PGSelectQueryBlock.IntoOption.TEMPORARY);
                } else if (this.lexer.token() == Token.TEMP) {
                    this.lexer.nextToken();
                    queryBlock.setIntoOption(PGSelectQueryBlock.IntoOption.TEMP);
                } else if (this.lexer.token() == Token.UNLOGGED) {
                    this.lexer.nextToken();
                    queryBlock.setIntoOption(PGSelectQueryBlock.IntoOption.UNLOGGED);
                }
                if (this.lexer.token() == Token.TABLE) {
                    this.lexer.nextToken();
                }
                SQLName name = this.createExprParser().name();
                queryBlock.setInto(new SQLExprTableSource(name));
            }
        }
        this.parseFrom(queryBlock);
        this.parseWhere(queryBlock);
        this.parseGroupBy(queryBlock);
        if (this.lexer.token() == Token.WINDOW) {
            this.parseWindow(queryBlock);
        }
        queryBlock.setOrderBy(this.createExprParser().parseOrderBy());
        while (true) {
            SQLLimit limit;
            if (this.lexer.token() == Token.LIMIT) {
                limit = this.getOrInitLimit(queryBlock);
                this.lexer.nextToken();
                if (this.lexer.token() == Token.ALL) {
                    limit.setRowCount(new SQLIdentifierExpr("ALL"));
                    this.lexer.nextToken();
                    continue;
                }
                limit.setRowCount(this.expr());
                continue;
            }
            if (this.lexer.token() != Token.OFFSET) break;
            limit = this.getOrInitLimit(queryBlock);
            this.lexer.nextToken();
            SQLExpr offset = this.expr();
            limit.setOffset(offset);
            if (this.lexer.token() != Token.ROW && this.lexer.token() != Token.ROWS) continue;
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.FETCH) {
            this.lexer.nextToken();
            PGSelectQueryBlock.FetchClause fetch = new PGSelectQueryBlock.FetchClause();
            if (this.lexer.token() == Token.FIRST) {
                fetch.setOption(PGSelectQueryBlock.FetchClause.Option.FIRST);
            } else if (this.lexer.token() == Token.NEXT) {
                fetch.setOption(PGSelectQueryBlock.FetchClause.Option.NEXT);
            } else {
                throw new ParserException("expect 'FIRST' or 'NEXT'. " + this.lexer.info());
            }
            this.lexer.nextToken();
            SQLExpr count = this.expr();
            fetch.setCount(count);
            if (this.lexer.token() != Token.ROW && this.lexer.token() != Token.ROWS) {
                throw new ParserException("expect 'ROW' or 'ROWS'. " + this.lexer.info());
            }
            this.lexer.nextToken();
            if (this.lexer.token() != Token.ONLY) {
                throw new ParserException("expect 'ONLY'. " + this.lexer.info());
            }
            this.lexer.nextToken();
            queryBlock.setFetch(fetch);
        }
        if (this.lexer.token() == Token.FOR) {
            this.lexer.nextToken();
            PGSelectQueryBlock.ForClause forClause = new PGSelectQueryBlock.ForClause();
            if (this.lexer.token() == Token.UPDATE) {
                forClause.setOption(PGSelectQueryBlock.ForClause.Option.UPDATE);
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.SHARE) {
                forClause.setOption(PGSelectQueryBlock.ForClause.Option.SHARE);
                this.lexer.nextToken();
            } else {
                throw new ParserException("expect 'FIRST' or 'NEXT'. " + this.lexer.info());
            }
            if (this.lexer.token() == Token.OF) {
                while (true) {
                    SQLExpr expr = this.createExprParser().expr();
                    forClause.getOf().add(expr);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
            }
            if (this.lexer.token() == Token.NOWAIT) {
                this.lexer.nextToken();
                forClause.setNoWait(true);
            } else if (this.lexer.identifierEquals(FnvHash.Constants.SKIP)) {
                this.lexer.nextToken();
                this.acceptIdentifier("LOCKED");
                forClause.setSkipLocked(true);
            }
            queryBlock.setForClause(forClause);
        }
        return this.queryRest(queryBlock, acceptUnion);
    }

    private SQLLimit getOrInitLimit(SQLSelectQueryBlock queryBlock) {
        SQLLimit limit = queryBlock.getLimit();
        if (limit == null) {
            limit = new SQLLimit();
            queryBlock.setLimit(limit);
        }
        return limit;
    }

    @Override
    public SQLTableSource parseTableSourceRest(SQLTableSource tableSource) {
        if (this.lexer.token() == Token.AS && tableSource instanceof SQLExprTableSource) {
            this.lexer.nextToken();
            String alias = null;
            if (this.lexer.token() == Token.IDENTIFIER) {
                alias = this.lexer.stringVal();
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.LPAREN) {
                SQLExprTableSource exprTableSource = (SQLExprTableSource)tableSource;
                PGFunctionTableSource functionTableSource = new PGFunctionTableSource(exprTableSource.getExpr());
                if (alias != null) {
                    functionTableSource.setAlias(alias);
                }
                this.lexer.nextToken();
                this.parserParameters(functionTableSource.getParameters());
                this.accept(Token.RPAREN);
                return super.parseTableSourceRest(functionTableSource);
            }
            if (alias != null) {
                tableSource.setAlias(alias);
                return super.parseTableSourceRest(tableSource);
            }
        }
        return this.parseTableSourceTableSample(tableSource);
    }

    public SQLTableSource parseTableSourceTableSample(SQLTableSource tableSource) {
        if (this.lexer.identifierEquals(FnvHash.Constants.TABLESAMPLE) && tableSource instanceof SQLExprTableSource) {
            Lexer.SavePoint mark = this.lexer.mark();
            this.lexer.nextToken();
            SQLTableSampling sampling = new SQLTableSampling();
            if (this.lexer.identifierEquals(FnvHash.Constants.BERNOULLI)) {
                this.lexer.nextToken();
                sampling.setBernoulli(true);
            } else if (this.lexer.identifierEquals(FnvHash.Constants.SYSTEM)) {
                this.lexer.nextToken();
                sampling.setSystem(true);
            }
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals(FnvHash.Constants.BUCKET)) {
                    this.lexer.nextToken();
                    SQLExpr bucket = this.exprParser.primary();
                    sampling.setBucket(bucket);
                    if (this.lexer.token() == Token.OUT) {
                        this.lexer.nextToken();
                        this.accept(Token.OF);
                        SQLExpr outOf = this.exprParser.primary();
                        sampling.setOutOf(outOf);
                    }
                    if (this.lexer.token() == Token.ON) {
                        this.lexer.nextToken();
                        SQLExpr on = this.exprParser.expr();
                        sampling.setOn(on);
                    }
                }
                if (this.lexer.token() == Token.LITERAL_INT || this.lexer.token() == Token.LITERAL_FLOAT) {
                    SQLExpr val = this.exprParser.primary();
                    if (this.lexer.identifierEquals(FnvHash.Constants.ROWS)) {
                        this.lexer.nextToken();
                        sampling.setRows(val);
                    } else if (this.lexer.token() == Token.RPAREN) {
                        sampling.setRows(val);
                    } else {
                        this.acceptIdentifier("PERCENT");
                        sampling.setPercent(val);
                    }
                }
                if (this.lexer.token() == Token.IDENTIFIER) {
                    String strVal = this.lexer.stringVal();
                    char first = strVal.charAt(0);
                    char last = strVal.charAt(strVal.length() - 1);
                    if (last >= 'a' && last <= 'z') {
                        last = (char)(last - 32);
                    }
                    boolean match = false;
                    if (first == '.' || first >= '0' && first <= '9') {
                        switch (last) {
                            case 'B': 
                            case 'G': 
                            case 'K': 
                            case 'M': 
                            case 'P': 
                            case 'T': {
                                match = true;
                                break;
                            }
                        }
                    }
                    SQLSizeExpr size = new SQLSizeExpr(strVal.substring(0, strVal.length() - 2), last);
                    sampling.setByteLength(size);
                    this.lexer.nextToken();
                }
                SQLExprTableSource table = (SQLExprTableSource)tableSource;
                table.setSampling(sampling);
                this.accept(Token.RPAREN);
            } else {
                this.lexer.reset(mark);
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.USING)) {
            return tableSource;
        }
        return super.parseTableSourceRest(tableSource);
    }

    private void parserParameters(List<SQLParameter> parameters) {
        do {
            SQLParameter parameter = new SQLParameter();
            parameter.setName(this.exprParser.name());
            parameter.setDataType(this.exprParser.parseDataType());
            parameters.add(parameter);
            if (this.lexer.token() != Token.COMMA && this.lexer.token() != Token.SEMI) continue;
            this.lexer.nextToken();
        } while (this.lexer.token() != Token.BEGIN && this.lexer.token() != Token.RPAREN);
    }

    @Override
    protected List<String> getReturningFunctions() {
        return Arrays.asList("GENERATE_SERIES", "GENERATE_SUBSCRIPTS");
    }
}

