/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.FastsqlException;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SQLIntegerExpr
extends SQLNumericLiteralExpr
implements Comparable<SQLIntegerExpr> {
    public static final SQLDataType DATA_TYPE = new SQLDataTypeImpl("bigint");
    private Number number;
    private String type;

    public SQLIntegerExpr(Number number) {
        this();
        this.number = number;
    }

    public SQLIntegerExpr(Number number, SQLObject parent) {
        this();
        this.number = number;
        this.parent = parent;
    }

    public SQLIntegerExpr() {
        super(new SQLDataTypeImpl("INT"));
    }

    @Override
    public Number getNumber() {
        return this.number;
    }

    @Override
    public void setNumber(Number number) {
        this.number = number;
    }

    @Override
    public void output(StringBuilder buf) {
        buf.append(this.number.toString());
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.number == null ? 0 : this.number.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLIntegerExpr other = (SQLIntegerExpr)obj;
        return !(this.number == null ? other.number != null : !this.number.equals(other.number));
    }

    @Override
    public Object getValue() {
        return this.number;
    }

    @Override
    public SQLIntegerExpr clone() {
        return new SQLIntegerExpr(this.number);
    }

    @Override
    public SQLDataType computeDataType() {
        return DATA_TYPE;
    }

    public void decrement() {
        if (this.number instanceof Integer) {
            this.number = Integer.valueOf(this.number.intValue()) - 1;
        } else if (this.number instanceof Long) {
            this.number = Long.valueOf(this.number.longValue()) - 1L;
        } else {
            throw new FastsqlException("decrement not support.");
        }
    }

    public static boolean isZero(SQLExpr expr) {
        if (expr instanceof SQLIntegerExpr) {
            Number number = ((SQLIntegerExpr)expr).getNumber();
            return number != null && number.intValue() == 0;
        }
        return false;
    }

    public static SQLIntegerExpr substract(SQLIntegerExpr a, SQLIntegerExpr b) {
        int val = a.number.intValue() - b.number.intValue();
        return new SQLIntegerExpr(val);
    }

    public static SQLIntegerExpr least(SQLIntegerExpr a, SQLIntegerExpr b) {
        if (a == null) {
            return b;
        }
        if (a.number.intValue() <= b.number.intValue()) {
            return a;
        }
        return b;
    }

    public static SQLIntegerExpr greatst(SQLIntegerExpr a, SQLIntegerExpr b) {
        if (a.number.intValue() >= b.number.intValue()) {
            return a;
        }
        return b;
    }

    public static SQLIntegerExpr ofIntOrLong(long value) {
        if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
            return new SQLIntegerExpr((int)value);
        }
        return new SQLIntegerExpr(value);
    }

    public static SQLIntegerExpr add(long a, long b) {
        long r = a + b;
        if (a > 0L && b > 0L && r <= 0L) {
            return new SQLIntegerExpr(BigInteger.valueOf(a).add(BigInteger.valueOf(b)));
        }
        return new SQLIntegerExpr(r);
    }

    @Override
    public int compareTo(SQLIntegerExpr o) {
        if (this.number instanceof Integer && o.number instanceof Integer) {
            return ((Integer)this.number).compareTo((Integer)o.number);
        }
        if (this.number instanceof Long && o.number instanceof Long) {
            return ((Long)this.number).compareTo((Long)o.number);
        }
        if (this.number instanceof BigDecimal && o.number instanceof BigDecimal) {
            return ((BigDecimal)this.number).compareTo((BigDecimal)o.number);
        }
        if (this.number instanceof Float && o.number instanceof Float) {
            return ((Float)this.number).compareTo((Float)o.number);
        }
        if (this.number instanceof Double && o.number instanceof Double) {
            return ((Double)this.number).compareTo((Double)o.number);
        }
        return -1;
    }

    public SQLIntegerExpr negative() {
        Number number = this.number;
        if (number instanceof Integer) {
            number = -number.intValue();
        } else if (number instanceof Long) {
            number = -number.longValue();
        } else if (number instanceof BigInteger) {
            number = ((BigInteger)number).negate();
        } else {
            throw new UnsupportedOperationException();
        }
        return new SQLIntegerExpr(number);
    }
}

