/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.gaussdb.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.dialect.gaussdb.ast.stmt.GaussDbInsertStatement;
import com.alibaba.druid.sql.dialect.gaussdb.parser.GaussDbCreateTableParser;
import com.alibaba.druid.sql.dialect.gaussdb.parser.GaussDbExprParser;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGInsertStatement;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGSQLStatementParser;
import com.alibaba.druid.sql.parser.EOFParserException;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.ArrayList;
import java.util.List;

public class GaussDbStatementParser
extends PGSQLStatementParser {
    public GaussDbStatementParser(String sql) {
        super(new GaussDbExprParser(sql, new SQLParserFeature[0]));
    }

    public GaussDbStatementParser(String sql, SQLParserFeature ... features) {
        super(new GaussDbExprParser(sql, features));
    }

    @Override
    public GaussDbCreateTableParser getSQLCreateTableParser() {
        return new GaussDbCreateTableParser(this.exprParser);
    }

    @Override
    public SQLCreateTableStatement parseCreateTable() {
        return this.getSQLCreateTableParser().parseCreateTable();
    }

    @Override
    public PGInsertStatement parseInsert() {
        GaussDbInsertStatement stmt = new GaussDbInsertStatement();
        if (this.lexer.token() == Token.INSERT) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("IGNORE")) {
                this.lexer.nextToken();
                stmt.setIgnore(true);
            } else if (this.lexer.token() == Token.OVERWRITE) {
                this.lexer.nextToken();
                stmt.setOverwrite(true);
            }
            this.accept(Token.INTO);
            stmt.setTableSource(this.exprParser.name());
            if (this.lexer.token() == Token.AS) {
                this.lexer.nextToken();
                stmt.setAlias(this.lexer.stringVal());
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.IDENTIFIER) {
                stmt.setAlias(this.lexer.stringVal());
                this.lexer.nextToken();
            }
        }
        if (this.lexer.nextIf(Token.LPAREN)) {
            this.exprParser.exprList(stmt.getColumns(), stmt);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.nextIf(Token.DEFAULT)) {
            this.accept(Token.VALUES);
            stmt.setDefaultValues(true);
        }
        if (this.lexer.nextIf(Token.VALUES)) {
            while (true) {
                this.accept(Token.LPAREN);
                SQLInsertStatement.ValuesClause valuesCaluse = new SQLInsertStatement.ValuesClause();
                this.exprParser.exprList(valuesCaluse.getValues(), valuesCaluse);
                stmt.addValueCause(valuesCaluse);
                this.accept(Token.RPAREN);
                if (this.lexer.nextIf(Token.COMMA)) {
                    continue;
                }
                break;
            }
        } else if (this.lexer.token() == Token.SELECT) {
            SQLSelect select = this.createSQLSelectParser().select();
            stmt.setQuery(select);
        }
        if (this.lexer.nextIf(Token.ON)) {
            if (this.lexer.identifierEquals(FnvHash.Constants.CONFLICT)) {
                SQLExpr where;
                this.lexer.nextToken();
                if (this.lexer.nextIf(Token.LPAREN)) {
                    ArrayList<SQLExpr> onConflictTarget = new ArrayList<SQLExpr>();
                    this.exprParser.exprList(onConflictTarget, stmt);
                    stmt.setOnConflictTarget(onConflictTarget);
                    this.accept(Token.RPAREN);
                }
                if (this.lexer.nextIf(Token.ON)) {
                    this.accept(Token.CONSTRAINT);
                    SQLName constraintName = this.exprParser.name();
                    stmt.setOnConflictConstraint(constraintName);
                }
                if (this.lexer.nextIf(Token.WHERE)) {
                    where = this.exprParser.expr();
                    stmt.setOnConflictWhere(where);
                }
                if (this.lexer.nextIf(Token.DO)) {
                    if (this.lexer.identifierEquals(FnvHash.Constants.NOTHING)) {
                        this.lexer.nextToken();
                        stmt.setOnConflictDoNothing(true);
                    } else {
                        this.accept(Token.UPDATE);
                        this.accept(Token.SET);
                        while (true) {
                            SQLUpdateSetItem item = this.exprParser.parseUpdateSetItem();
                            stmt.addConflicUpdateItem(item);
                            if (this.lexer.token() != Token.COMMA) break;
                            this.lexer.nextToken();
                        }
                        if (this.lexer.nextIf(Token.WHERE)) {
                            where = this.exprParser.expr();
                            stmt.setOnConflictUpdateWhere(where);
                        }
                    }
                }
            } else if (this.lexer.identifierEquals("DUPLICATE")) {
                this.lexer.nextToken();
                this.accept(Token.KEY);
                this.accept(Token.UPDATE);
                List<SQLExpr> duplicateKeyUpdate = stmt.getDuplicateKeyUpdate();
                while (true) {
                    SQLExpr value;
                    SQLName name = this.exprParser.name();
                    this.accept(Token.EQ);
                    try {
                        value = this.exprParser.expr();
                    }
                    catch (EOFParserException e) {
                        throw new ParserException("EOF, " + name + "=", e);
                    }
                    SQLBinaryOpExpr assignment = new SQLBinaryOpExpr((SQLExpr)name, SQLBinaryOperator.Equality, value);
                    assignment.setParent(stmt);
                    duplicateKeyUpdate.add(assignment);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextTokenIdent();
                }
            }
        }
        if (this.lexer.nextIf(Token.RETURNING)) {
            SQLExpr returning = this.exprParser.expr();
            if (this.lexer.nextIf(Token.COMMA)) {
                SQLListExpr list = new SQLListExpr();
                list.addItem(returning);
                this.exprParser.exprList(list.getItems(), list);
                returning = list;
            }
            stmt.setReturning(returning);
        }
        return stmt;
    }

    @Override
    protected void createOptionSkip() {
        this.lexer.nextIf(Token.LOCAL);
        this.lexer.nextIfIdentifier("UNLOGGED");
        super.createOptionSkip();
    }
}

