/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.bigquery.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.bigquery.ast.BigQuerySelectQueryBlock;
import com.alibaba.druid.sql.dialect.bigquery.parser.BigQueryExprParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectListCache;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;

public class BigQuerySelectParser
extends SQLSelectParser {
    public BigQuerySelectParser(SQLExprParser exprParser, SQLSelectListCache selectListCache) {
        super(exprParser, selectListCache);
        this.dbType = DbType.bigquery;
    }

    protected SQLExprParser createExprParser() {
        return new BigQueryExprParser(this.lexer);
    }

    @Override
    protected BigQuerySelectQueryBlock createSelectQueryBlock() {
        return new BigQuerySelectQueryBlock();
    }

    @Override
    protected void querySelectListBefore(SQLSelectQueryBlock x) {
        if (this.lexer.nextIf(Token.DISTINCT)) {
            x.setDistinct();
        }
        if (this.lexer.nextIf(Token.AS)) {
            this.acceptIdentifier("STRUCT");
            ((BigQuerySelectQueryBlock)x).setAsStruct(true);
        }
        if (this.lexer.nextIf(Token.WITH)) {
            this.acceptIdentifier("DIFFERENTIAL_PRIVACY");
            this.acceptIdentifier("OPTIONS");
            BigQuerySelectQueryBlock.DifferentialPrivacy clause = new BigQuerySelectQueryBlock.DifferentialPrivacy();
            this.exprParser.parseAssignItem(clause.getOptions(), (SQLObject)clause);
            ((BigQuerySelectQueryBlock)x).setDifferentialPrivacy(clause);
        }
    }

    @Override
    protected boolean parseSelectListFromError() {
        return false;
    }

    @Override
    protected String tableAlias(boolean must) {
        if (this.lexer.token() == Token.TABLE) {
            String alias = this.lexer.stringVal();
            this.lexer.nextToken();
            return alias;
        }
        return super.tableAlias(must);
    }
}

