/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.embeddings;

import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class BatchTextEmbeddingParam
extends HalfDuplexServiceParam {
    @NotNull
    private String url;
    private TextType textType;

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("text_type", this.textType.getValue());
        if (this.parameters != null && !this.parameters.isEmpty()) {
            params.putAll(this.parameters);
        }
        return params;
    }

    @Override
    public JsonObject getHttpBody() {
        JsonObject requestObject = new JsonObject();
        requestObject.addProperty("model", this.getModel());
        requestObject.add("input", (JsonElement)this.getInput());
        if (this.getParameters() != null && !this.getParameters().isEmpty()) {
            requestObject.add("parameters", (JsonElement)JsonUtils.parametersToJsonObject(this.getParameters()));
        }
        return requestObject;
    }

    public JsonObject getInput() {
        JsonObject input = new JsonObject();
        input.addProperty("url", this.url);
        return input;
    }

    @Override
    public ByteBuffer getBinaryData() {
        throw new UnsupportedOperationException("Unimplemented method 'getBinaryData'");
    }

    @Override
    public void validate() throws InputRequiredException {
        if (this.url == null) {
            throw new InputRequiredException("texts must not empty");
        }
    }

    private static TextType $default$textType() {
        return TextType.DOCUMENT;
    }

    protected BatchTextEmbeddingParam(BatchTextEmbeddingParamBuilder<?, ?> b) {
        super((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<?, ?>)b);
        this.url = ((BatchTextEmbeddingParamBuilder)b).url;
        if (this.url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.textType = ((BatchTextEmbeddingParamBuilder)b).textType$set ? ((BatchTextEmbeddingParamBuilder)b).textType$value : BatchTextEmbeddingParam.$default$textType();
    }

    public static BatchTextEmbeddingParamBuilder<?, ?> builder() {
        return new BatchTextEmbeddingParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BatchTextEmbeddingParam)) {
            return false;
        }
        BatchTextEmbeddingParam other = (BatchTextEmbeddingParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$url = this.url;
        String other$url = other.url;
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        TextType this$textType = this.textType;
        TextType other$textType = other.textType;
        return !(this$textType == null ? other$textType != null : !((Object)((Object)this$textType)).equals((Object)other$textType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BatchTextEmbeddingParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $url = this.url;
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        TextType $textType = this.textType;
        result = result * 59 + ($textType == null ? 43 : ((Object)((Object)$textType)).hashCode());
        return result;
    }

    private static final class BatchTextEmbeddingParamBuilderImpl
    extends BatchTextEmbeddingParamBuilder<BatchTextEmbeddingParam, BatchTextEmbeddingParamBuilderImpl> {
        private BatchTextEmbeddingParamBuilderImpl() {
        }

        @Override
        protected BatchTextEmbeddingParamBuilderImpl self() {
            return this;
        }

        @Override
        public BatchTextEmbeddingParam build() {
            return new BatchTextEmbeddingParam(this);
        }
    }

    public static abstract class BatchTextEmbeddingParamBuilder<C extends BatchTextEmbeddingParam, B extends BatchTextEmbeddingParamBuilder<C, B>>
    extends HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<C, B> {
        private String url;
        private boolean textType$set;
        private TextType textType$value;

        public B url(@NotNull String url) {
            this.url = url;
            return (B)this.self();
        }

        public B textType(TextType textType) {
            this.textType$value = textType;
            this.textType$set = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "BatchTextEmbeddingParam.BatchTextEmbeddingParamBuilder(super=" + super.toString() + ", url=" + this.url + ", textType$value=" + (Object)((Object)this.textType$value) + ")";
        }
    }

    public static enum TextType {
        QUERY("query"),
        DOCUMENT("document");

        private final String value;

        private TextType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

