/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.omni;

import com.alibaba.dashscope.audio.omni.OmniRealtimeAudioFormat;
import com.alibaba.dashscope.audio.omni.OmniRealtimeModality;
import com.alibaba.dashscope.audio.omni.OmniRealtimeTranscriptionParam;
import com.alibaba.dashscope.audio.omni.OmniRealtimeTranslationParam;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class OmniRealtimeConfig {
    @NonNull
    List<OmniRealtimeModality> modalities;
    String voice;
    OmniRealtimeAudioFormat inputAudioFormat;
    OmniRealtimeAudioFormat outputAudioFormat;
    boolean enableInputAudioTranscription;
    String InputAudioTranscription;
    boolean enableTurnDetection;
    String turnDetectionType;
    float turnDetectionThreshold;
    int prefixPaddingMs;
    int turnDetectionSilenceDurationMs;
    Map<String, Object> turnDetectionParam;
    Map<String, Object> parameters;
    OmniRealtimeTranslationParam translationConfig;
    OmniRealtimeTranscriptionParam transcriptionConfig;

    public JsonObject getConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("modalities", this.modalities);
        config.put("voice", this.voice);
        config.put("input_audio_format", (Object)this.inputAudioFormat);
        config.put("output_audio_format", (Object)this.outputAudioFormat);
        if (this.enableInputAudioTranscription) {
            HashMap<String, String> inputTranscriptionConfig = new HashMap<String, String>();
            inputTranscriptionConfig.put("model", this.InputAudioTranscription);
            config.put("input_audio_transcription", inputTranscriptionConfig);
        } else {
            config.put("input_audio_transcription", null);
        }
        if (this.enableTurnDetection) {
            HashMap<String, Object> turnDetectionConfig = new HashMap<String, Object>();
            turnDetectionConfig.put("type", this.turnDetectionType);
            turnDetectionConfig.put("threshold", Float.valueOf(this.turnDetectionThreshold));
            turnDetectionConfig.put("prefix_padding_ms", this.prefixPaddingMs);
            turnDetectionConfig.put("silence_duration_ms", this.turnDetectionSilenceDurationMs);
            if (this.turnDetectionParam != null) {
                for (Map.Entry<String, Object> entry : this.turnDetectionParam.entrySet()) {
                    turnDetectionConfig.put(entry.getKey(), entry.getValue());
                }
            }
            config.put("turn_detection", turnDetectionConfig);
        } else {
            config.put("turn_detection", null);
        }
        if (this.translationConfig != null) {
            HashMap<String, String> translationConfig = new HashMap<String, String>();
            translationConfig.put("language", this.translationConfig.getLanguage());
            config.put("translation", translationConfig);
        } else {
            config.put("translation", null);
        }
        if (this.transcriptionConfig != null) {
            HashMap transcriptionConfig = new HashMap();
            if (this.transcriptionConfig.getInputSampleRate() != null) {
                config.put("sample_rate", this.transcriptionConfig.getInputSampleRate());
            }
            if (this.transcriptionConfig.getInputAudioFormat() != null) {
                config.put("input_audio_format", this.transcriptionConfig.getInputAudioFormat());
            }
            if (this.transcriptionConfig.getLanguage() != null) {
                transcriptionConfig.put("language", this.transcriptionConfig.getLanguage());
            }
            if (this.transcriptionConfig.getCorpus() != null) {
                transcriptionConfig.put("corpus", this.transcriptionConfig.getCorpus());
            }
            config.put("input_audio_transcription", transcriptionConfig);
        }
        if (this.parameters != null) {
            for (Map.Entry entry : this.parameters.entrySet()) {
                config.put((String)entry.getKey(), entry.getValue());
            }
        }
        GsonBuilder builder = new GsonBuilder();
        builder.serializeNulls();
        Gson gson = builder.create();
        JsonObject jsonObject = gson.toJsonTree(config).getAsJsonObject();
        return jsonObject;
    }

    private static String $default$voice() {
        return null;
    }

    private static OmniRealtimeAudioFormat $default$inputAudioFormat() {
        return OmniRealtimeAudioFormat.PCM_16000HZ_MONO_16BIT;
    }

    private static OmniRealtimeAudioFormat $default$outputAudioFormat() {
        return OmniRealtimeAudioFormat.PCM_24000HZ_MONO_16BIT;
    }

    private static boolean $default$enableInputAudioTranscription() {
        return true;
    }

    private static String $default$InputAudioTranscription() {
        return null;
    }

    private static boolean $default$enableTurnDetection() {
        return true;
    }

    private static String $default$turnDetectionType() {
        return "server_vad";
    }

    private static float $default$turnDetectionThreshold() {
        return 0.2f;
    }

    private static int $default$prefixPaddingMs() {
        return 300;
    }

    private static int $default$turnDetectionSilenceDurationMs() {
        return 800;
    }

    private static Map<String, Object> $default$turnDetectionParam() {
        return null;
    }

    private static Map<String, Object> $default$parameters() {
        return null;
    }

    private static OmniRealtimeTranslationParam $default$translationConfig() {
        return null;
    }

    private static OmniRealtimeTranscriptionParam $default$transcriptionConfig() {
        return null;
    }

    protected OmniRealtimeConfig(OmniRealtimeConfigBuilder<?, ?> b) {
        this.modalities = ((OmniRealtimeConfigBuilder)b).modalities;
        if (this.modalities == null) {
            throw new NullPointerException("modalities is marked non-null but is null");
        }
        this.voice = ((OmniRealtimeConfigBuilder)b).voice$set ? ((OmniRealtimeConfigBuilder)b).voice$value : OmniRealtimeConfig.$default$voice();
        this.inputAudioFormat = ((OmniRealtimeConfigBuilder)b).inputAudioFormat$set ? ((OmniRealtimeConfigBuilder)b).inputAudioFormat$value : OmniRealtimeConfig.$default$inputAudioFormat();
        this.outputAudioFormat = ((OmniRealtimeConfigBuilder)b).outputAudioFormat$set ? ((OmniRealtimeConfigBuilder)b).outputAudioFormat$value : OmniRealtimeConfig.$default$outputAudioFormat();
        this.enableInputAudioTranscription = ((OmniRealtimeConfigBuilder)b).enableInputAudioTranscription$set ? ((OmniRealtimeConfigBuilder)b).enableInputAudioTranscription$value : OmniRealtimeConfig.$default$enableInputAudioTranscription();
        this.InputAudioTranscription = ((OmniRealtimeConfigBuilder)b).InputAudioTranscription$set ? ((OmniRealtimeConfigBuilder)b).InputAudioTranscription$value : OmniRealtimeConfig.$default$InputAudioTranscription();
        this.enableTurnDetection = ((OmniRealtimeConfigBuilder)b).enableTurnDetection$set ? ((OmniRealtimeConfigBuilder)b).enableTurnDetection$value : OmniRealtimeConfig.$default$enableTurnDetection();
        this.turnDetectionType = ((OmniRealtimeConfigBuilder)b).turnDetectionType$set ? ((OmniRealtimeConfigBuilder)b).turnDetectionType$value : OmniRealtimeConfig.$default$turnDetectionType();
        this.turnDetectionThreshold = ((OmniRealtimeConfigBuilder)b).turnDetectionThreshold$set ? ((OmniRealtimeConfigBuilder)b).turnDetectionThreshold$value : OmniRealtimeConfig.$default$turnDetectionThreshold();
        this.prefixPaddingMs = ((OmniRealtimeConfigBuilder)b).prefixPaddingMs$set ? ((OmniRealtimeConfigBuilder)b).prefixPaddingMs$value : OmniRealtimeConfig.$default$prefixPaddingMs();
        this.turnDetectionSilenceDurationMs = ((OmniRealtimeConfigBuilder)b).turnDetectionSilenceDurationMs$set ? ((OmniRealtimeConfigBuilder)b).turnDetectionSilenceDurationMs$value : OmniRealtimeConfig.$default$turnDetectionSilenceDurationMs();
        this.turnDetectionParam = ((OmniRealtimeConfigBuilder)b).turnDetectionParam$set ? ((OmniRealtimeConfigBuilder)b).turnDetectionParam$value : OmniRealtimeConfig.$default$turnDetectionParam();
        this.parameters = ((OmniRealtimeConfigBuilder)b).parameters$set ? ((OmniRealtimeConfigBuilder)b).parameters$value : OmniRealtimeConfig.$default$parameters();
        this.translationConfig = ((OmniRealtimeConfigBuilder)b).translationConfig$set ? ((OmniRealtimeConfigBuilder)b).translationConfig$value : OmniRealtimeConfig.$default$translationConfig();
        this.transcriptionConfig = ((OmniRealtimeConfigBuilder)b).transcriptionConfig$set ? ((OmniRealtimeConfigBuilder)b).transcriptionConfig$value : OmniRealtimeConfig.$default$transcriptionConfig();
    }

    public static OmniRealtimeConfigBuilder<?, ?> builder() {
        return new OmniRealtimeConfigBuilderImpl();
    }

    @NonNull
    public List<OmniRealtimeModality> getModalities() {
        return this.modalities;
    }

    public String getVoice() {
        return this.voice;
    }

    public OmniRealtimeAudioFormat getInputAudioFormat() {
        return this.inputAudioFormat;
    }

    public OmniRealtimeAudioFormat getOutputAudioFormat() {
        return this.outputAudioFormat;
    }

    public boolean isEnableInputAudioTranscription() {
        return this.enableInputAudioTranscription;
    }

    public String getInputAudioTranscription() {
        return this.InputAudioTranscription;
    }

    public boolean isEnableTurnDetection() {
        return this.enableTurnDetection;
    }

    public String getTurnDetectionType() {
        return this.turnDetectionType;
    }

    public float getTurnDetectionThreshold() {
        return this.turnDetectionThreshold;
    }

    public int getPrefixPaddingMs() {
        return this.prefixPaddingMs;
    }

    public int getTurnDetectionSilenceDurationMs() {
        return this.turnDetectionSilenceDurationMs;
    }

    public Map<String, Object> getTurnDetectionParam() {
        return this.turnDetectionParam;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public OmniRealtimeTranslationParam getTranslationConfig() {
        return this.translationConfig;
    }

    public OmniRealtimeTranscriptionParam getTranscriptionConfig() {
        return this.transcriptionConfig;
    }

    public void setModalities(@NonNull List<OmniRealtimeModality> modalities) {
        if (modalities == null) {
            throw new NullPointerException("modalities is marked non-null but is null");
        }
        this.modalities = modalities;
    }

    public void setVoice(String voice) {
        this.voice = voice;
    }

    public void setInputAudioFormat(OmniRealtimeAudioFormat inputAudioFormat) {
        this.inputAudioFormat = inputAudioFormat;
    }

    public void setOutputAudioFormat(OmniRealtimeAudioFormat outputAudioFormat) {
        this.outputAudioFormat = outputAudioFormat;
    }

    public void setEnableInputAudioTranscription(boolean enableInputAudioTranscription) {
        this.enableInputAudioTranscription = enableInputAudioTranscription;
    }

    public void setInputAudioTranscription(String InputAudioTranscription) {
        this.InputAudioTranscription = InputAudioTranscription;
    }

    public void setEnableTurnDetection(boolean enableTurnDetection) {
        this.enableTurnDetection = enableTurnDetection;
    }

    public void setTurnDetectionType(String turnDetectionType) {
        this.turnDetectionType = turnDetectionType;
    }

    public void setTurnDetectionThreshold(float turnDetectionThreshold) {
        this.turnDetectionThreshold = turnDetectionThreshold;
    }

    public void setPrefixPaddingMs(int prefixPaddingMs) {
        this.prefixPaddingMs = prefixPaddingMs;
    }

    public void setTurnDetectionSilenceDurationMs(int turnDetectionSilenceDurationMs) {
        this.turnDetectionSilenceDurationMs = turnDetectionSilenceDurationMs;
    }

    public void setTurnDetectionParam(Map<String, Object> turnDetectionParam) {
        this.turnDetectionParam = turnDetectionParam;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setTranslationConfig(OmniRealtimeTranslationParam translationConfig) {
        this.translationConfig = translationConfig;
    }

    public void setTranscriptionConfig(OmniRealtimeTranscriptionParam transcriptionConfig) {
        this.transcriptionConfig = transcriptionConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OmniRealtimeConfig)) {
            return false;
        }
        OmniRealtimeConfig other = (OmniRealtimeConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnableInputAudioTranscription() != other.isEnableInputAudioTranscription()) {
            return false;
        }
        if (this.isEnableTurnDetection() != other.isEnableTurnDetection()) {
            return false;
        }
        if (Float.compare(this.getTurnDetectionThreshold(), other.getTurnDetectionThreshold()) != 0) {
            return false;
        }
        if (this.getPrefixPaddingMs() != other.getPrefixPaddingMs()) {
            return false;
        }
        if (this.getTurnDetectionSilenceDurationMs() != other.getTurnDetectionSilenceDurationMs()) {
            return false;
        }
        List<OmniRealtimeModality> this$modalities = this.getModalities();
        List<OmniRealtimeModality> other$modalities = other.getModalities();
        if (this$modalities == null ? other$modalities != null : !((Object)this$modalities).equals(other$modalities)) {
            return false;
        }
        String this$voice = this.getVoice();
        String other$voice = other.getVoice();
        if (this$voice == null ? other$voice != null : !this$voice.equals(other$voice)) {
            return false;
        }
        OmniRealtimeAudioFormat this$inputAudioFormat = this.getInputAudioFormat();
        OmniRealtimeAudioFormat other$inputAudioFormat = other.getInputAudioFormat();
        if (this$inputAudioFormat == null ? other$inputAudioFormat != null : !((Object)((Object)this$inputAudioFormat)).equals((Object)other$inputAudioFormat)) {
            return false;
        }
        OmniRealtimeAudioFormat this$outputAudioFormat = this.getOutputAudioFormat();
        OmniRealtimeAudioFormat other$outputAudioFormat = other.getOutputAudioFormat();
        if (this$outputAudioFormat == null ? other$outputAudioFormat != null : !((Object)((Object)this$outputAudioFormat)).equals((Object)other$outputAudioFormat)) {
            return false;
        }
        String this$InputAudioTranscription = this.getInputAudioTranscription();
        String other$InputAudioTranscription = other.getInputAudioTranscription();
        if (this$InputAudioTranscription == null ? other$InputAudioTranscription != null : !this$InputAudioTranscription.equals(other$InputAudioTranscription)) {
            return false;
        }
        String this$turnDetectionType = this.getTurnDetectionType();
        String other$turnDetectionType = other.getTurnDetectionType();
        if (this$turnDetectionType == null ? other$turnDetectionType != null : !this$turnDetectionType.equals(other$turnDetectionType)) {
            return false;
        }
        Map<String, Object> this$turnDetectionParam = this.getTurnDetectionParam();
        Map<String, Object> other$turnDetectionParam = other.getTurnDetectionParam();
        if (this$turnDetectionParam == null ? other$turnDetectionParam != null : !((Object)this$turnDetectionParam).equals(other$turnDetectionParam)) {
            return false;
        }
        Map<String, Object> this$parameters = this.getParameters();
        Map<String, Object> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        OmniRealtimeTranslationParam this$translationConfig = this.getTranslationConfig();
        OmniRealtimeTranslationParam other$translationConfig = other.getTranslationConfig();
        if (this$translationConfig == null ? other$translationConfig != null : !((Object)this$translationConfig).equals(other$translationConfig)) {
            return false;
        }
        OmniRealtimeTranscriptionParam this$transcriptionConfig = this.getTranscriptionConfig();
        OmniRealtimeTranscriptionParam other$transcriptionConfig = other.getTranscriptionConfig();
        return !(this$transcriptionConfig == null ? other$transcriptionConfig != null : !((Object)this$transcriptionConfig).equals(other$transcriptionConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OmniRealtimeConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnableInputAudioTranscription() ? 79 : 97);
        result = result * 59 + (this.isEnableTurnDetection() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getTurnDetectionThreshold());
        result = result * 59 + this.getPrefixPaddingMs();
        result = result * 59 + this.getTurnDetectionSilenceDurationMs();
        List<OmniRealtimeModality> $modalities = this.getModalities();
        result = result * 59 + ($modalities == null ? 43 : ((Object)$modalities).hashCode());
        String $voice = this.getVoice();
        result = result * 59 + ($voice == null ? 43 : $voice.hashCode());
        OmniRealtimeAudioFormat $inputAudioFormat = this.getInputAudioFormat();
        result = result * 59 + ($inputAudioFormat == null ? 43 : ((Object)((Object)$inputAudioFormat)).hashCode());
        OmniRealtimeAudioFormat $outputAudioFormat = this.getOutputAudioFormat();
        result = result * 59 + ($outputAudioFormat == null ? 43 : ((Object)((Object)$outputAudioFormat)).hashCode());
        String $InputAudioTranscription = this.getInputAudioTranscription();
        result = result * 59 + ($InputAudioTranscription == null ? 43 : $InputAudioTranscription.hashCode());
        String $turnDetectionType = this.getTurnDetectionType();
        result = result * 59 + ($turnDetectionType == null ? 43 : $turnDetectionType.hashCode());
        Map<String, Object> $turnDetectionParam = this.getTurnDetectionParam();
        result = result * 59 + ($turnDetectionParam == null ? 43 : ((Object)$turnDetectionParam).hashCode());
        Map<String, Object> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        OmniRealtimeTranslationParam $translationConfig = this.getTranslationConfig();
        result = result * 59 + ($translationConfig == null ? 43 : ((Object)$translationConfig).hashCode());
        OmniRealtimeTranscriptionParam $transcriptionConfig = this.getTranscriptionConfig();
        result = result * 59 + ($transcriptionConfig == null ? 43 : ((Object)$transcriptionConfig).hashCode());
        return result;
    }

    public String toString() {
        return "OmniRealtimeConfig(modalities=" + this.getModalities() + ", voice=" + this.getVoice() + ", inputAudioFormat=" + (Object)((Object)this.getInputAudioFormat()) + ", outputAudioFormat=" + (Object)((Object)this.getOutputAudioFormat()) + ", enableInputAudioTranscription=" + this.isEnableInputAudioTranscription() + ", InputAudioTranscription=" + this.getInputAudioTranscription() + ", enableTurnDetection=" + this.isEnableTurnDetection() + ", turnDetectionType=" + this.getTurnDetectionType() + ", turnDetectionThreshold=" + this.getTurnDetectionThreshold() + ", prefixPaddingMs=" + this.getPrefixPaddingMs() + ", turnDetectionSilenceDurationMs=" + this.getTurnDetectionSilenceDurationMs() + ", turnDetectionParam=" + this.getTurnDetectionParam() + ", parameters=" + this.getParameters() + ", translationConfig=" + this.getTranslationConfig() + ", transcriptionConfig=" + this.getTranscriptionConfig() + ")";
    }

    private static final class OmniRealtimeConfigBuilderImpl
    extends OmniRealtimeConfigBuilder<OmniRealtimeConfig, OmniRealtimeConfigBuilderImpl> {
        private OmniRealtimeConfigBuilderImpl() {
        }

        @Override
        protected OmniRealtimeConfigBuilderImpl self() {
            return this;
        }

        @Override
        public OmniRealtimeConfig build() {
            return new OmniRealtimeConfig(this);
        }
    }

    public static abstract class OmniRealtimeConfigBuilder<C extends OmniRealtimeConfig, B extends OmniRealtimeConfigBuilder<C, B>> {
        private List<OmniRealtimeModality> modalities;
        private boolean voice$set;
        private String voice$value;
        private boolean inputAudioFormat$set;
        private OmniRealtimeAudioFormat inputAudioFormat$value;
        private boolean outputAudioFormat$set;
        private OmniRealtimeAudioFormat outputAudioFormat$value;
        private boolean enableInputAudioTranscription$set;
        private boolean enableInputAudioTranscription$value;
        private boolean InputAudioTranscription$set;
        private String InputAudioTranscription$value;
        private boolean enableTurnDetection$set;
        private boolean enableTurnDetection$value;
        private boolean turnDetectionType$set;
        private String turnDetectionType$value;
        private boolean turnDetectionThreshold$set;
        private float turnDetectionThreshold$value;
        private boolean prefixPaddingMs$set;
        private int prefixPaddingMs$value;
        private boolean turnDetectionSilenceDurationMs$set;
        private int turnDetectionSilenceDurationMs$value;
        private boolean turnDetectionParam$set;
        private Map<String, Object> turnDetectionParam$value;
        private boolean parameters$set;
        private Map<String, Object> parameters$value;
        private boolean translationConfig$set;
        private OmniRealtimeTranslationParam translationConfig$value;
        private boolean transcriptionConfig$set;
        private OmniRealtimeTranscriptionParam transcriptionConfig$value;

        public B modalities(@NonNull List<OmniRealtimeModality> modalities) {
            if (modalities == null) {
                throw new NullPointerException("modalities is marked non-null but is null");
            }
            this.modalities = modalities;
            return this.self();
        }

        public B voice(String voice) {
            this.voice$value = voice;
            this.voice$set = true;
            return this.self();
        }

        public B inputAudioFormat(OmniRealtimeAudioFormat inputAudioFormat) {
            this.inputAudioFormat$value = inputAudioFormat;
            this.inputAudioFormat$set = true;
            return this.self();
        }

        public B outputAudioFormat(OmniRealtimeAudioFormat outputAudioFormat) {
            this.outputAudioFormat$value = outputAudioFormat;
            this.outputAudioFormat$set = true;
            return this.self();
        }

        public B enableInputAudioTranscription(boolean enableInputAudioTranscription) {
            this.enableInputAudioTranscription$value = enableInputAudioTranscription;
            this.enableInputAudioTranscription$set = true;
            return this.self();
        }

        public B InputAudioTranscription(String InputAudioTranscription) {
            this.InputAudioTranscription$value = InputAudioTranscription;
            this.InputAudioTranscription$set = true;
            return this.self();
        }

        public B enableTurnDetection(boolean enableTurnDetection) {
            this.enableTurnDetection$value = enableTurnDetection;
            this.enableTurnDetection$set = true;
            return this.self();
        }

        public B turnDetectionType(String turnDetectionType) {
            this.turnDetectionType$value = turnDetectionType;
            this.turnDetectionType$set = true;
            return this.self();
        }

        public B turnDetectionThreshold(float turnDetectionThreshold) {
            this.turnDetectionThreshold$value = turnDetectionThreshold;
            this.turnDetectionThreshold$set = true;
            return this.self();
        }

        public B prefixPaddingMs(int prefixPaddingMs) {
            this.prefixPaddingMs$value = prefixPaddingMs;
            this.prefixPaddingMs$set = true;
            return this.self();
        }

        public B turnDetectionSilenceDurationMs(int turnDetectionSilenceDurationMs) {
            this.turnDetectionSilenceDurationMs$value = turnDetectionSilenceDurationMs;
            this.turnDetectionSilenceDurationMs$set = true;
            return this.self();
        }

        public B turnDetectionParam(Map<String, Object> turnDetectionParam) {
            this.turnDetectionParam$value = turnDetectionParam;
            this.turnDetectionParam$set = true;
            return this.self();
        }

        public B parameters(Map<String, Object> parameters) {
            this.parameters$value = parameters;
            this.parameters$set = true;
            return this.self();
        }

        public B translationConfig(OmniRealtimeTranslationParam translationConfig) {
            this.translationConfig$value = translationConfig;
            this.translationConfig$set = true;
            return this.self();
        }

        public B transcriptionConfig(OmniRealtimeTranscriptionParam transcriptionConfig) {
            this.transcriptionConfig$value = transcriptionConfig;
            this.transcriptionConfig$set = true;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "OmniRealtimeConfig.OmniRealtimeConfigBuilder(modalities=" + this.modalities + ", voice$value=" + this.voice$value + ", inputAudioFormat$value=" + (Object)((Object)this.inputAudioFormat$value) + ", outputAudioFormat$value=" + (Object)((Object)this.outputAudioFormat$value) + ", enableInputAudioTranscription$value=" + this.enableInputAudioTranscription$value + ", InputAudioTranscription$value=" + this.InputAudioTranscription$value + ", enableTurnDetection$value=" + this.enableTurnDetection$value + ", turnDetectionType$value=" + this.turnDetectionType$value + ", turnDetectionThreshold$value=" + this.turnDetectionThreshold$value + ", prefixPaddingMs$value=" + this.prefixPaddingMs$value + ", turnDetectionSilenceDurationMs$value=" + this.turnDetectionSilenceDurationMs$value + ", turnDetectionParam$value=" + this.turnDetectionParam$value + ", parameters$value=" + this.parameters$value + ", translationConfig$value=" + this.translationConfig$value + ", transcriptionConfig$value=" + this.transcriptionConfig$value + ")";
        }
    }
}

