/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.protocol;

import io.reactivex.Observable;
import io.reactivex.functions.Function;
import java.util.concurrent.TimeUnit;

public class RetryWithDelay
implements Function<Observable<? extends Throwable>, Observable<?>> {
    private final int maxRetries;
    private final int retryDelayMillis;
    private int retryCount;

    public RetryWithDelay(int maxRetries, int retryDelayMillis) {
        this.maxRetries = maxRetries;
        this.retryDelayMillis = retryDelayMillis;
        this.retryCount = 0;
    }

    public Observable<?> apply(Observable<? extends Throwable> attempts) {
        return attempts.flatMap(new Function<Throwable, Observable<?>>(){

            public Observable<?> apply(Throwable throwable) {
                if (++RetryWithDelay.this.retryCount < RetryWithDelay.this.maxRetries) {
                    return Observable.timer((long)RetryWithDelay.this.retryDelayMillis, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                return Observable.error((Throwable)throwable);
            }
        });
    }
}

