/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.utils;

import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalMessageItemBase;
import com.alibaba.dashscope.common.MultiModalMessage;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.exception.UploadFileException;
import com.alibaba.dashscope.utils.OSSUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PreprocessMessageInput {
    public static boolean isValidPath(String pathString) {
        try {
            Paths.get(pathString, new String[0]);
            return true;
        }
        catch (InvalidPathException e) {
            return false;
        }
    }

    public static boolean checkAndUpload(String model, MultiModalMessageItemBase message, String apiKey) throws NoApiKeyException, UploadFileException {
        File f;
        boolean isUpload = false;
        if (!message.getModal().equals("text") && message.getContent().startsWith("file://")) {
            try {
                String fileUrl;
                URI fileURI = new URI(message.getContent());
                File f2 = new File(fileURI);
                if (f2.exists()) {
                    fileUrl = OSSUtils.upload(model, f2.getAbsolutePath(), apiKey);
                    if (fileUrl == null) {
                        throw new UploadFileException(String.format("Uploading file: %s failed", message.getContent()));
                    }
                } else {
                    throw new UploadFileException(String.format("Local file: %s not exists.", message.getContent()));
                }
                message.setContent(fileUrl);
                isUpload = true;
            }
            catch (URISyntaxException e) {
                throw new UploadFileException(e.getMessage());
            }
        } else if (!message.getModal().equals("text") && !message.getContent().startsWith("http") && PreprocessMessageInput.isValidPath(message.getContent()) && (f = new File(message.getContent())).exists()) {
            String fileUrl = OSSUtils.upload(model, f.getAbsolutePath(), apiKey);
            if (fileUrl == null) {
                throw new UploadFileException(String.format("Uploading file: %s failed", message.getContent()));
            }
            message.setContent(fileUrl);
            isUpload = true;
        }
        return isUpload;
    }

    public static <T extends MultiModalMessageItemBase> boolean preProcessMessageInputs(String model, List<T> messages, String apiKey) throws NoApiKeyException, UploadFileException {
        boolean hasUpload = false;
        for (MultiModalMessageItemBase elem : messages) {
            boolean isUpload = PreprocessMessageInput.checkAndUpload(model, elem, apiKey);
            if (!isUpload || hasUpload) continue;
            hasUpload = true;
        }
        return hasUpload;
    }

    public static String checkAndUploadOneMultiModalMessage(String model, String apiKey, String key, String value) throws NoApiKeyException, UploadFileException {
        File f;
        String dstValue = value;
        if (value.startsWith("file://")) {
            try {
                String fileUrl;
                URI fileURI = new URI(value);
                File f2 = new File(fileURI);
                if (f2.exists()) {
                    fileUrl = OSSUtils.upload(model, f2.getAbsolutePath(), apiKey);
                    if (fileUrl == null) {
                        throw new UploadFileException(String.format("Uploading file: %s failed", value));
                    }
                } else {
                    throw new UploadFileException(String.format("Local file: %s not exists.", value));
                }
                dstValue = fileUrl;
            }
            catch (URISyntaxException e) {
                throw new UploadFileException(e.getMessage());
            }
        } else if (!key.equals("text") && !value.startsWith("http") && PreprocessMessageInput.isValidPath(value) && (f = new File(value)).exists()) {
            String fileUrl = OSSUtils.upload(model, f.getAbsolutePath(), apiKey);
            if (fileUrl == null) {
                throw new UploadFileException(String.format("Uploading file: %s failed", value));
            }
            dstValue = fileUrl;
        }
        return dstValue;
    }

    public static boolean checkAndUploadMultiModalMessage(String model, Map.Entry<String, Object> entry, String apiKey) throws NoApiKeyException, UploadFileException {
        String dstValue;
        boolean isUpload = false;
        String key = entry.getKey();
        Object value = entry.getValue();
        if (value instanceof List) {
            List dstValue2 = (List)value;
            for (int i = 0; i < dstValue2.size(); ++i) {
                String dstV;
                Object v = dstValue2.get(i);
                if (!(v instanceof String) || (dstV = PreprocessMessageInput.checkAndUploadOneMultiModalMessage(model, apiKey, key, (String)v)).equals(v)) continue;
                isUpload = true;
                dstValue2.set(i, dstV);
            }
            entry.setValue(dstValue2);
        } else if (value instanceof String && !(dstValue = PreprocessMessageInput.checkAndUploadOneMultiModalMessage(model, apiKey, key, (String)value)).equals(value)) {
            isUpload = true;
            entry.setValue(dstValue);
        }
        return isUpload;
    }

    public static boolean preProcessMultiModalMessageInputs(String model, MultiModalMessage messages, String apiKey) throws NoApiKeyException, UploadFileException {
        boolean hasUpload = false;
        ArrayList<Map<String, Object>> content = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> item : messages.getContent()) {
            content.add(new HashMap<String, Object>(item));
        }
        for (Map<String, Object> item : content) {
            for (Map.Entry<String, Object> entry : item.entrySet()) {
                boolean isUpload = PreprocessMessageInput.checkAndUploadMultiModalMessage(model, entry, apiKey);
                if (!isUpload || hasUpload) continue;
                hasUpload = true;
            }
        }
        messages.setContent(content);
        return hasUpload;
    }
}

