/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.asr.vocabulary;

import com.alibaba.dashscope.audio.asr.vocabulary.VocabularyOperationType;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.security.InvalidParameterException;

public class VocabularyParam
extends HalfDuplexServiceParam {
    private String prefix;
    private String targetModel;
    private VocabularyOperationType operationType;
    private JsonArray vocabulary;
    private String vocabularyId;
    private int pageIndex;
    private int pageSize;

    protected VocabularyParam(HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<?, ?> b) {
        super(b);
    }

    @Override
    public JsonObject getHttpBody() {
        JsonObject body = new JsonObject();
        body.add("input", (JsonElement)this.getInput());
        body.addProperty("model", this.getModel());
        return body;
    }

    public JsonObject getInput() {
        JsonObject input = new JsonObject();
        switch (this.operationType) {
            case CREATE: {
                input.addProperty("action", this.operationType.getValue());
                input.addProperty("target_model", this.targetModel);
                input.addProperty("prefix", this.prefix);
                input.add("vocabulary", (JsonElement)this.vocabulary);
                break;
            }
            case LIST: {
                input.addProperty("action", this.operationType.getValue());
                if (this.prefix != null) {
                    input.addProperty("prefix", this.prefix);
                }
                input.addProperty("page_index", (Number)this.pageIndex);
                input.addProperty("page_size", (Number)this.pageSize);
                break;
            }
            case QUERY: {
                input.addProperty("action", this.operationType.getValue());
                input.addProperty("vocabulary_id", this.vocabularyId);
                break;
            }
            case UPDATE: {
                input.addProperty("action", this.operationType.getValue());
                input.addProperty("vocabulary_id", this.vocabularyId);
                input.add("vocabulary", (JsonElement)this.vocabulary);
                break;
            }
            case DELETE: {
                input.addProperty("action", this.operationType.getValue());
                input.addProperty("vocabulary_id", this.vocabularyId);
                break;
            }
            default: {
                throw new InvalidParameterException("operationType is not supported, should not be here.");
            }
        }
        return input;
    }

    @Override
    public ByteBuffer getBinaryData() {
        throw new UnsupportedOperationException("Unimplemented method 'getBinaryData'");
    }

    @Override
    public void validate() throws InputRequiredException {
        if (this.operationType == null) {
            throw new InputRequiredException("operationType is required");
        }
        switch (this.operationType) {
            case CREATE: {
                if (this.vocabulary == null) {
                    throw new InputRequiredException("vocabulary is required when Create Vocabulary");
                }
                if (this.prefix == null) {
                    throw new InputRequiredException("prefix is required");
                }
                if (this.targetModel != null) break;
                throw new InputRequiredException("targetModel is required");
            }
            case LIST: {
                if (this.pageIndex < 0) {
                    throw new InputRequiredException("pageIndexs should be greater or equal to 0");
                }
                if (this.pageSize >= 1) break;
                throw new InputRequiredException("pageSize should be greater or equal to 1");
            }
            case QUERY: {
                if (this.vocabularyId != null) break;
                throw new InputRequiredException("vocabulary id is required when Query Vocabulary");
            }
            case UPDATE: {
                if (this.vocabularyId == null) {
                    throw new InputRequiredException("vocabulary id is required when Update Vocabulary");
                }
                if (this.vocabulary != null) break;
                throw new InputRequiredException("vocabulary is required when Update Vocabulary");
            }
            case DELETE: {
                if (this.vocabularyId != null) break;
                throw new InputRequiredException("vocabulary id is required when Delete Voice");
            }
            default: {
                throw new InvalidParameterException("operationType is not supported, should not be here.");
            }
        }
    }

    protected VocabularyParam(VocabularyParamBuilder<?, ?> b) {
        super((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<?, ?>)b);
        this.prefix = ((VocabularyParamBuilder)b).prefix;
        this.targetModel = ((VocabularyParamBuilder)b).targetModel;
        this.operationType = ((VocabularyParamBuilder)b).operationType;
        this.vocabulary = ((VocabularyParamBuilder)b).vocabulary;
        this.vocabularyId = ((VocabularyParamBuilder)b).vocabularyId;
        this.pageIndex = ((VocabularyParamBuilder)b).pageIndex;
        this.pageSize = ((VocabularyParamBuilder)b).pageSize;
    }

    public static VocabularyParamBuilder<?, ?> builder() {
        return new VocabularyParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VocabularyParam)) {
            return false;
        }
        VocabularyParam other = (VocabularyParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageIndex() != other.getPageIndex()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$targetModel = this.getTargetModel();
        String other$targetModel = other.getTargetModel();
        if (this$targetModel == null ? other$targetModel != null : !this$targetModel.equals(other$targetModel)) {
            return false;
        }
        VocabularyOperationType this$operationType = this.getOperationType();
        VocabularyOperationType other$operationType = other.getOperationType();
        if (this$operationType == null ? other$operationType != null : !((Object)((Object)this$operationType)).equals((Object)other$operationType)) {
            return false;
        }
        JsonArray this$vocabulary = this.getVocabulary();
        JsonArray other$vocabulary = other.getVocabulary();
        if (this$vocabulary == null ? other$vocabulary != null : !this$vocabulary.equals(other$vocabulary)) {
            return false;
        }
        String this$vocabularyId = this.getVocabularyId();
        String other$vocabularyId = other.getVocabularyId();
        return !(this$vocabularyId == null ? other$vocabularyId != null : !this$vocabularyId.equals(other$vocabularyId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VocabularyParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageIndex();
        result = result * 59 + this.getPageSize();
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $targetModel = this.getTargetModel();
        result = result * 59 + ($targetModel == null ? 43 : $targetModel.hashCode());
        VocabularyOperationType $operationType = this.getOperationType();
        result = result * 59 + ($operationType == null ? 43 : ((Object)((Object)$operationType)).hashCode());
        JsonArray $vocabulary = this.getVocabulary();
        result = result * 59 + ($vocabulary == null ? 43 : $vocabulary.hashCode());
        String $vocabularyId = this.getVocabularyId();
        result = result * 59 + ($vocabularyId == null ? 43 : $vocabularyId.hashCode());
        return result;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getTargetModel() {
        return this.targetModel;
    }

    public VocabularyOperationType getOperationType() {
        return this.operationType;
    }

    public JsonArray getVocabulary() {
        return this.vocabulary;
    }

    public String getVocabularyId() {
        return this.vocabularyId;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setTargetModel(String targetModel) {
        this.targetModel = targetModel;
    }

    public void setOperationType(VocabularyOperationType operationType) {
        this.operationType = operationType;
    }

    public void setVocabulary(JsonArray vocabulary) {
        this.vocabulary = vocabulary;
    }

    public void setVocabularyId(String vocabularyId) {
        this.vocabularyId = vocabularyId;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public String toString() {
        return "VocabularyParam(prefix=" + this.getPrefix() + ", targetModel=" + this.getTargetModel() + ", operationType=" + (Object)((Object)this.getOperationType()) + ", vocabulary=" + this.getVocabulary() + ", vocabularyId=" + this.getVocabularyId() + ", pageIndex=" + this.getPageIndex() + ", pageSize=" + this.getPageSize() + ")";
    }

    private static final class VocabularyParamBuilderImpl
    extends VocabularyParamBuilder<VocabularyParam, VocabularyParamBuilderImpl> {
        private VocabularyParamBuilderImpl() {
        }

        @Override
        protected VocabularyParamBuilderImpl self() {
            return this;
        }

        @Override
        public VocabularyParam build() {
            return new VocabularyParam(this);
        }
    }

    public static abstract class VocabularyParamBuilder<C extends VocabularyParam, B extends VocabularyParamBuilder<C, B>>
    extends HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<C, B> {
        private String prefix;
        private String targetModel;
        private VocabularyOperationType operationType;
        private JsonArray vocabulary;
        private String vocabularyId;
        private int pageIndex;
        private int pageSize;

        public B prefix(String prefix) {
            this.prefix = prefix;
            return (B)this.self();
        }

        public B targetModel(String targetModel) {
            this.targetModel = targetModel;
            return (B)this.self();
        }

        public B operationType(VocabularyOperationType operationType) {
            this.operationType = operationType;
            return (B)this.self();
        }

        public B vocabulary(JsonArray vocabulary) {
            this.vocabulary = vocabulary;
            return (B)this.self();
        }

        public B vocabularyId(String vocabularyId) {
            this.vocabularyId = vocabularyId;
            return (B)this.self();
        }

        public B pageIndex(int pageIndex) {
            this.pageIndex = pageIndex;
            return (B)this.self();
        }

        public B pageSize(int pageSize) {
            this.pageSize = pageSize;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "VocabularyParam.VocabularyParamBuilder(super=" + super.toString() + ", prefix=" + this.prefix + ", targetModel=" + this.targetModel + ", operationType=" + (Object)((Object)this.operationType) + ", vocabulary=" + this.vocabulary + ", vocabularyId=" + this.vocabularyId + ", pageIndex=" + this.pageIndex + ", pageSize=" + this.pageSize + ")";
        }
    }
}

