/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.asr.recognition;

import com.alibaba.dashscope.audio.asr.recognition.RecognitionUsage;
import com.alibaba.dashscope.audio.asr.recognition.timestamp.Sentence;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;

public class RecognitionResult {
    @SerializedName(value="request_id")
    private String requestId;
    private Sentence sentence;
    private RecognitionUsage usage;
    private boolean isCompleteResult = false;

    public boolean isSentenceEnd() {
        return this.sentence.getEndTime() != null;
    }

    public static boolean IsSentenceEnd(Sentence sentence) {
        return sentence != null && sentence.getEndTime() != null;
    }

    public static RecognitionResult fromDashScopeResult(DashScopeResult dashScopeResult) throws ApiException {
        JsonObject jsonDashScopeResult;
        RecognitionResult result = new RecognitionResult();
        result.setRequestId(dashScopeResult.getRequestId());
        if (dashScopeResult.getUsage() != null) {
            result.setUsage(JsonUtils.fromJsonObject((JsonElement)dashScopeResult.getUsage().getAsJsonObject(), RecognitionUsage.class));
        }
        if ((jsonDashScopeResult = (JsonObject)dashScopeResult.getOutput()).has("sentence")) {
            JsonObject timestampObject = jsonDashScopeResult.getAsJsonObject("sentence");
            if (timestampObject != null) {
                result.sentence = Sentence.from(timestampObject);
            } else {
                result.isCompleteResult = true;
            }
        } else {
            result.isCompleteResult = true;
            result.sentence = new Sentence();
        }
        return result;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Sentence getSentence() {
        return this.sentence;
    }

    public RecognitionUsage getUsage() {
        return this.usage;
    }

    public boolean isCompleteResult() {
        return this.isCompleteResult;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setSentence(Sentence sentence) {
        this.sentence = sentence;
    }

    public void setUsage(RecognitionUsage usage) {
        this.usage = usage;
    }

    public void setCompleteResult(boolean isCompleteResult) {
        this.isCompleteResult = isCompleteResult;
    }

    public String toString() {
        return "RecognitionResult(requestId=" + this.getRequestId() + ", sentence=" + this.getSentence() + ", usage=" + this.getUsage() + ", isCompleteResult=" + this.isCompleteResult() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecognitionResult)) {
            return false;
        }
        RecognitionResult other = (RecognitionResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCompleteResult() != other.isCompleteResult()) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        Sentence this$sentence = this.getSentence();
        Sentence other$sentence = other.getSentence();
        if (this$sentence == null ? other$sentence != null : !((Object)this$sentence).equals(other$sentence)) {
            return false;
        }
        RecognitionUsage this$usage = this.getUsage();
        RecognitionUsage other$usage = other.getUsage();
        return !(this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecognitionResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCompleteResult() ? 79 : 97);
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        Sentence $sentence = this.getSentence();
        result = result * 59 + ($sentence == null ? 43 : ((Object)$sentence).hashCode());
        RecognitionUsage $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        return result;
    }
}

