/*
 * Decompiled with CFR 0.152.
 */
import com.alibaba.dashscope.app.Application;
import com.alibaba.dashscope.app.ApplicationOutput;
import com.alibaba.dashscope.app.ApplicationParam;
import com.alibaba.dashscope.app.ApplicationResult;
import com.alibaba.dashscope.app.ApplicationUsage;
import com.alibaba.dashscope.app.RagOptions;
import com.alibaba.dashscope.base.HalfDuplexParamBase;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonObject;
import io.reactivex.Flowable;
import java.util.Collections;
import java.util.List;

public class ApplicationCalls {
    private static final String WORKSPACE = System.getenv("WORKSPACE_ID");
    private static final String APP_ID = System.getenv("APP_ID");

    public static void ragCall() throws ApiException, NoApiKeyException, InputRequiredException {
        HalfDuplexParamBase param = ((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)ApplicationParam.builder().appId(APP_ID)).prompt("API\u63a5\u53e3\u8bf4\u660e\u4e2d, TopP\u53c2\u6570\u6539\u5982\u4f55\u4f20\u9012?")).topP(0.2)).build();
        Application application = new Application();
        ApplicationResult result = application.call((ApplicationParam)param);
        System.out.printf("requestId: %s, text: %s, finishReason: %s\n", result.getRequestId(), result.getOutput().getText(), result.getOutput().getFinishReason());
        if (result.getUsage() != null && result.getUsage().getModels() != null) {
            for (ApplicationUsage.ModelUsage usage : result.getUsage().getModels()) {
                System.out.printf("modelId: %s, inputTokens: %d, outputTokens: %d\n", usage.getModelId(), usage.getInputTokens(), usage.getOutputTokens());
            }
        }
    }

    public static void ragCallWithTags() throws ApiException, NoApiKeyException, InputRequiredException {
        HalfDuplexParamBase param = ((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)ApplicationParam.builder().appId(APP_ID)).prompt("API\u63a5\u53e3\u8bf4\u660e\u4e2d, TopP\u53c2\u6570\u6539\u5982\u4f55\u4f20\u9012?")).topP(0.2)).hasThoughts(true)).build();
        Application application = new Application();
        ApplicationResult result = application.call((ApplicationParam)param);
        System.out.printf("requestId: %s, text: %s, finishReason: %s\n", result.getRequestId(), result.getOutput().getText(), result.getOutput().getFinishReason());
        List<ApplicationOutput.Thought> thoughts = result.getOutput().getThoughts();
        if (thoughts != null && !thoughts.isEmpty()) {
            for (ApplicationOutput.Thought thought : thoughts) {
                System.out.printf("thought: %s\n", thought);
            }
        }
    }

    public static void flowCall() throws ApiException, NoApiKeyException, InputRequiredException {
        HalfDuplexParamBase param = ((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)ApplicationParam.builder().appId(APP_ID)).prompt("\u676d\u5dde\u7684\u5929\u6c14\u600e\u4e48\u6837")).topP(0.2)).build();
        Application application = new Application();
        ApplicationResult result = application.call((ApplicationParam)param);
        System.out.printf("requestId: %s, text: %s, finishReason: %s\n", result.getRequestId(), result.getOutput().getText(), result.getOutput().getFinishReason());
    }

    public static void flowCallWithParam() throws ApiException, NoApiKeyException, InputRequiredException {
        String bizParams = "{\"date\": \"\u4eca\u5929\"}";
        HalfDuplexParamBase param = ((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)ApplicationParam.builder().appId(APP_ID)).prompt("\u676d\u5dde\u7684\u5929\u6c14\u600e\u4e48\u6837")).bizParams(JsonUtils.parse(bizParams))).hasThoughts(true)).topP(0.2)).build();
        Application application = new Application();
        ApplicationResult result = application.call((ApplicationParam)param);
        System.out.printf("requestId: %s, text: %s, finishReason: %s\n", result.getRequestId(), result.getOutput().getText(), result.getOutput().getFinishReason());
        List<ApplicationOutput.Thought> thoughts = result.getOutput().getThoughts();
        if (thoughts != null && !thoughts.isEmpty()) {
            for (ApplicationOutput.Thought thought : thoughts) {
                System.out.printf("thought: %s\n", thought);
            }
        }
    }

    public static void callWithSession() throws ApiException, NoApiKeyException, InputRequiredException {
        HalfDuplexParamBase param = ((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)ApplicationParam.builder().appId(APP_ID)).prompt("\u6211\u60f3\u53bb\u65b0\u7586")).topP(0.2)).build();
        Application application = new Application();
        ApplicationResult result = application.call((ApplicationParam)param);
        ((ApplicationParam)param).setSessionId(result.getOutput().getSessionId());
        ((ApplicationParam)param).setPrompt("\u90a3\u8fb9\u6709\u4ec0\u4e48\u65c5\u6e38\u666f\u70b9\u6216\u8005\u7f8e\u98df?");
        result = application.call((ApplicationParam)param);
        System.out.printf("requestId: %s, text: %s, finishReason: %s\n", result.getRequestId(), result.getOutput().getText(), result.getOutput().getFinishReason());
    }

    public static void streamCall() throws NoApiKeyException, InputRequiredException {
        HalfDuplexParamBase param = ((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)ApplicationParam.builder().appId(APP_ID)).prompt("\u5982\u4f55\u505a\u571f\u8c46\u7096\u732a\u811a?")).topP(0.8)).incrementalOutput(true)).build();
        Application application = new Application();
        Flowable<ApplicationResult> result = application.streamCall((ApplicationParam)param);
        result.blockingForEach(data -> System.out.printf(data.getOutput().getText(), new Object[0]));
        System.out.print("\n");
    }

    public static void callWithWorkspace() throws NoApiKeyException, InputRequiredException {
        HalfDuplexParamBase param = ((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)ApplicationParam.builder().workspace(WORKSPACE)).appId(APP_ID)).prompt("\u5982\u4f55\u505a\u571f\u8c46\u7096\u732a\u811a?")).topP(0.8)).build();
        Application application = new Application();
        ApplicationResult result = application.call((ApplicationParam)param);
        System.out.printf("requestId: %s, text: %s, finishReason: %s\n", result.getRequestId(), result.getOutput().getText(), result.getOutput().getFinishReason());
    }

    public static void callWithMemory() throws ApiException, NoApiKeyException, InputRequiredException {
        HalfDuplexParamBase param = ((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)ApplicationParam.builder().appId(APP_ID)).prompt("\u6211\u60f3\u53bb\u65b0\u7586")).memoryId("mem_123")).topP(0.2)).build();
        Application application = new Application();
        ApplicationResult result = application.call((ApplicationParam)param);
        System.out.printf("requestId: %s, text: %s\n", result.getRequestId(), result.getOutput().getText());
    }

    public static void callWithAssistantServing() throws NoApiKeyException, InputRequiredException {
        JsonObject metadataFilter = new JsonObject();
        metadataFilter.addProperty("key", "meta123");
        JsonObject structureFilter = new JsonObject();
        structureFilter.addProperty("key", "structured123");
        HalfDuplexParamBase param = ((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)ApplicationParam.builder().appId(APP_ID)).prompt("\u6211\u60f3\u53bb\u65b0\u7586")).images(Collections.singletonList("img_123"))).ragOptions((RagOptions)((RagOptions.RagOptionsBuilder)((RagOptions.RagOptionsBuilder)((RagOptions.RagOptionsBuilder)((RagOptions.RagOptionsBuilder)((RagOptions.RagOptionsBuilder)RagOptions.builder().tags(Collections.singletonList("tag_123"))).pipelineIds(Collections.singletonList("pipeline_123"))).fileIds(Collections.singletonList("files_123"))).metadataFilter(metadataFilter)).structuredFilter(structureFilter)).build())).build();
        Application application = new Application();
        ApplicationResult result = application.call((ApplicationParam)param);
        System.out.printf("requestId: %s, text: %s\n", result.getRequestId(), result.getOutput().getText());
    }

    public static void ragCallWithDocReference() throws ApiException, NoApiKeyException, InputRequiredException {
        HalfDuplexParamBase param = ((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)((ApplicationParam.ApplicationParamBuilder)ApplicationParam.builder().appId(APP_ID)).prompt("ChatDev\u7684\u4eae\u70b9\u662f\u4ec0\u4e48\uff1f")).topP(0.2)).build();
        Application application = new Application();
        ApplicationResult result = application.call((ApplicationParam)param);
        System.out.printf("requestId: %s, text: %s, finishReason: %s\n", result.getRequestId(), result.getOutput().getText(), result.getOutput().getFinishReason());
        if (result.getOutput().getDocReferences() != null && !result.getOutput().getDocReferences().isEmpty()) {
            for (ApplicationOutput.DocReference docReference : result.getOutput().getDocReferences()) {
                System.out.println(docReference.toString());
            }
        }
    }

    public static void main(String[] args) {
        try {
            ApplicationCalls.ragCallWithDocReference();
        }
        catch (ApiException | InputRequiredException | NoApiKeyException e) {
            System.out.printf("Exception: %s", e.getMessage());
        }
        System.exit(0);
    }
}

