/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.common;

import com.alibaba.dashscope.common.MultiModalMessage;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MultiModalMessageAdapter
extends TypeAdapter<MultiModalMessage> {
    private void writeMapObject(JsonWriter out, Map<String, Object> mapObject) throws IOException {
        if (mapObject != null) {
            out.beginObject();
            for (Map.Entry<String, Object> entry : mapObject.entrySet()) {
                out.name(entry.getKey());
                if (entry.getValue() instanceof String) {
                    out.value((String)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof Integer) {
                    out.value((Number)((Integer)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof Double) {
                    out.value((Number)((Double)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof Boolean) {
                    out.value((Boolean)entry.getValue());
                    continue;
                }
                if (!(entry.getValue() instanceof Character)) continue;
                out.value((long)((Character)entry.getValue()).charValue());
            }
            out.endObject();
        }
    }

    public void write(JsonWriter out, MultiModalMessage value) throws IOException {
        out.beginObject();
        out.name("role");
        out.value(value.getRole());
        out.name("content");
        out.beginArray();
        for (Map<String, Object> item : value.getContent()) {
            this.writeMapObject(out, item);
        }
        out.endArray();
        out.endObject();
    }

    public MultiModalMessage read(JsonReader in) throws IOException {
        Map objectMap = (Map)JsonUtils.gson.fromJson(in, Map.class);
        MultiModalMessage msg = new MultiModalMessage();
        if (objectMap.containsKey("role")) {
            msg.setRole((String)objectMap.get("role"));
            objectMap.remove("role");
        }
        if (objectMap.containsKey("content")) {
            Object content = objectMap.get("content");
            if (content instanceof String) {
                msg.setContent(Arrays.asList(Collections.singletonMap("text", (String)content)));
            } else {
                msg.setContent((List)content);
            }
            objectMap.remove("content");
        }
        return msg;
    }
}

