/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.param;

public class ParamFlowItem {
    private String object;
    private Integer count;
    private String classType;

    public ParamFlowItem() {
    }

    public ParamFlowItem(String object, Integer count, String classType) {
        this.object = object;
        this.count = count;
        this.classType = classType;
    }

    public static <T> ParamFlowItem newItem(T object, Integer count) {
        if (object == null) {
            throw new IllegalArgumentException("Invalid object: null");
        }
        return new ParamFlowItem(object.toString(), count, object.getClass().getName());
    }

    public String getObject() {
        return this.object;
    }

    public ParamFlowItem setObject(String object) {
        this.object = object;
        return this;
    }

    public Integer getCount() {
        return this.count;
    }

    public ParamFlowItem setCount(Integer count) {
        this.count = count;
        return this;
    }

    public String getClassType() {
        return this.classType;
    }

    public ParamFlowItem setClassType(String classType) {
        this.classType = classType;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParamFlowItem item = (ParamFlowItem)o;
        if (this.object != null ? !this.object.equals(item.object) : item.object != null) {
            return false;
        }
        if (this.count != null ? !this.count.equals(item.count) : item.count != null) {
            return false;
        }
        return this.classType != null ? this.classType.equals(item.classType) : item.classType == null;
    }

    public int hashCode() {
        int result = this.object != null ? this.object.hashCode() : 0;
        result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
        result = 31 * result + (this.classType != null ? this.classType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ParamFlowItem{object=" + this.object + ", count=" + this.count + ", classType='" + this.classType + '\'' + '}';
    }
}

