/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.parser;

import com.alibaba.cloud.nacos.parser.AbstractPropertySourceLoader;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;

public class NacosJsonPropertySourceLoader
extends AbstractPropertySourceLoader {
    private static final String VALUE = "value";

    public String[] getFileExtensions() {
        return new String[]{"json"};
    }

    @Override
    protected List<PropertySource<?>> doLoad(String name, Resource resource) throws IOException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(32);
        ObjectMapper mapper = new ObjectMapper();
        Map nacosDataMap = (Map)mapper.readValue(resource.getInputStream(), LinkedHashMap.class);
        this.flattenedMap(result, nacosDataMap, null);
        return Collections.singletonList(new OriginTrackedMapPropertySource(name, this.reloadMap(result), true));
    }

    protected Map<String, Object> reloadMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(map);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            int idx;
            String suffix;
            String key = entry.getKey();
            if (!key.contains(".") || !VALUE.equalsIgnoreCase(suffix = key.substring((idx = key.lastIndexOf(".")) + 1))) continue;
            result.put(key.substring(0, idx), entry.getValue());
        }
        return result;
    }
}

