/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm;

import com.alibaba.bytekit.asm.TryCatchBlock;
import com.alibaba.bytekit.asm.location.filter.DefaultLocationFilter;
import com.alibaba.bytekit.asm.location.filter.LocationFilter;
import com.alibaba.bytekit.utils.AsmOpUtils;
import com.alibaba.bytekit.utils.AsmUtils;
import com.alibaba.deps.org.objectweb.asm.Type;
import com.alibaba.deps.org.objectweb.asm.commons.Method;
import com.alibaba.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.ClassNode;
import com.alibaba.deps.org.objectweb.asm.tree.FrameNode;
import com.alibaba.deps.org.objectweb.asm.tree.IincInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.InsnList;
import com.alibaba.deps.org.objectweb.asm.tree.InsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.IntInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.JumpInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.LabelNode;
import com.alibaba.deps.org.objectweb.asm.tree.LdcInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.LocalVariableNode;
import com.alibaba.deps.org.objectweb.asm.tree.MethodInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.MethodNode;
import com.alibaba.deps.org.objectweb.asm.tree.TryCatchBlockNode;
import com.alibaba.deps.org.objectweb.asm.tree.TypeInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.VarInsnNode;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class MethodProcessor {
    private String owner;
    private ClassNode classNode;
    private MethodNode methodNode;
    private final Type[] argumentTypes;
    private final Type returnType;
    private int nextLocals;
    private static final Type BYTE_TYPE = Type.getObjectType((String)"java/lang/Byte");
    private static final Type BOOLEAN_TYPE = Type.getObjectType((String)"java/lang/Boolean");
    private static final Type SHORT_TYPE = Type.getObjectType((String)"java/lang/Short");
    private static final Type CHARACTER_TYPE = Type.getObjectType((String)"java/lang/Character");
    private static final Type INTEGER_TYPE = Type.getObjectType((String)"java/lang/Integer");
    private static final Type FLOAT_TYPE = Type.getObjectType((String)"java/lang/Float");
    private static final Type LONG_TYPE = Type.getObjectType((String)"java/lang/Long");
    private static final Type DOUBLE_TYPE = Type.getObjectType((String)"java/lang/Double");
    private static final Type OBJECT_TYPE = Type.getObjectType((String)"java/lang/Object");
    private static final Type STRING_TYPE = Type.getObjectType((String)"java/lang/String");
    private static final Type THROWABLE_TYPE = Type.getObjectType((String)"java/lang/Throwable");
    private static final Type NUMBER_TYPE = Type.getObjectType((String)"java/lang/Number");
    private static final Type OBJECT_ARRAY_TYPE = Type.getType(Object[].class);
    private static final Method BOOLEAN_VALUE = Method.getMethod((String)"boolean booleanValue()");
    private static final Method CHAR_VALUE = Method.getMethod((String)"char charValue()");
    private static final Method INT_VALUE = Method.getMethod((String)"int intValue()");
    private static final Method FLOAT_VALUE = Method.getMethod((String)"float floatValue()");
    private static final Method LONG_VALUE = Method.getMethod((String)"long longValue()");
    private static final Method DOUBLE_VALUE = Method.getMethod((String)"double doubleValue()");
    public static final String DEFAULT_INNER_VARIABLE_PREFIX = "_$bytekit$_";
    private final LabelNode interceptorVariableStartLabelNode = new LabelNode();
    private final LabelNode interceptorVariableEndLabelNode = new LabelNode();
    private AbstractInsnNode enterInsnNode;
    private AbstractInsnNode lastInsnNode;
    private boolean keepLocalVariableNames;
    private String innerVariablePrefix;
    private String returnVariableName;
    private String throwVariableName;
    private String invokeArgsVariableName;
    private String monitorVariableName;
    private LocalVariableNode returnVariableNode = null;
    private LocalVariableNode throwVariableNode = null;
    private LocalVariableNode invokeArgsVariableNode = null;
    private LocalVariableNode monitorVariableNode = null;
    private String invokeReturnVariablePrefix;
    private Map<String, LocalVariableNode> invokeReturnVariableNodeMap = new HashMap<String, LocalVariableNode>();
    private TryCatchBlock tryCatchBlock = null;
    private LocationFilter locationFilter = new DefaultLocationFilter();

    public MethodProcessor(ClassNode classNode, MethodNode methodNode) {
        this(classNode, methodNode, false);
    }

    public MethodProcessor(ClassNode classNode, MethodNode methodNode, LocationFilter locationFilter) {
        this(classNode, methodNode, false);
        this.locationFilter = locationFilter;
    }

    public MethodProcessor(ClassNode classNode, MethodNode methodNode, boolean keepLocalVariableNames) {
        this(classNode.name, methodNode, keepLocalVariableNames);
        this.classNode = classNode;
    }

    public MethodProcessor(String owner, MethodNode methodNode, boolean keepLocalVariableNames) {
        this.owner = owner;
        this.methodNode = methodNode;
        this.nextLocals = methodNode.maxLocals;
        this.argumentTypes = Type.getArgumentTypes((String)methodNode.desc);
        this.returnType = Type.getReturnType((String)methodNode.desc);
        this.keepLocalVariableNames = keepLocalVariableNames;
        this.enterInsnNode = this.isConstructor() ? this.findInitConstructorInstruction() : methodNode.instructions.getFirst();
        this.lastInsnNode = methodNode.instructions.getLast();
        this.methodNode.instructions.insertBefore(this.enterInsnNode, (AbstractInsnNode)this.interceptorVariableStartLabelNode);
        this.methodNode.instructions.insert(this.lastInsnNode, (AbstractInsnNode)this.interceptorVariableEndLabelNode);
        this.initInnerVariablePrefix();
    }

    public MethodProcessor(String owner, MethodNode methodNode) {
        this(owner, methodNode, false);
    }

    private void initInnerVariablePrefix() {
        String prefix = DEFAULT_INNER_VARIABLE_PREFIX;
        int count = 0;
        while (this.existLocalVariableWithPrefix(prefix)) {
            prefix = DEFAULT_INNER_VARIABLE_PREFIX + count + "_";
            ++count;
        }
        this.innerVariablePrefix = prefix;
        this.returnVariableName = this.innerVariablePrefix + "_return";
        this.throwVariableName = this.innerVariablePrefix + "_throw";
        this.invokeArgsVariableName = this.innerVariablePrefix + "_invokeArgs";
        this.monitorVariableName = this.innerVariablePrefix + "_monitor";
        this.invokeReturnVariablePrefix = this.innerVariablePrefix + "_invokeReturn_";
    }

    private boolean existLocalVariableWithPrefix(String prefix) {
        for (LocalVariableNode variableNode : this.methodNode.localVariables) {
            if (!variableNode.name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public LocalVariableNode initMonitorVariableNode() {
        if (this.monitorVariableNode == null) {
            this.monitorVariableNode = this.addInterceptorLocalVariable(this.monitorVariableName, OBJECT_TYPE.getDescriptor());
        }
        return this.monitorVariableNode;
    }

    public LocalVariableNode initThrowVariableNode() {
        if (this.throwVariableNode == null) {
            this.throwVariableNode = this.addInterceptorLocalVariable(this.throwVariableName, THROWABLE_TYPE.getDescriptor());
        }
        return this.throwVariableNode;
    }

    public LocalVariableNode initInvokeArgsVariableNode() {
        if (this.invokeArgsVariableNode == null) {
            this.invokeArgsVariableNode = this.addInterceptorLocalVariable(this.invokeArgsVariableName, OBJECT_ARRAY_TYPE.getDescriptor());
        }
        return this.invokeArgsVariableNode;
    }

    public LocalVariableNode initReturnVariableNode() {
        if (this.returnVariableNode == null) {
            this.returnVariableNode = this.addInterceptorLocalVariable(this.returnVariableName, this.returnType.getDescriptor());
        }
        return this.returnVariableNode;
    }

    public LocalVariableNode initInvokeReturnVariableNode(String name, Type type) {
        String key = this.invokeReturnVariablePrefix + name;
        LocalVariableNode variableNode = this.invokeReturnVariableNodeMap.get(key);
        if (variableNode == null) {
            variableNode = this.addInterceptorLocalVariable(key, type.getDescriptor());
            this.invokeReturnVariableNodeMap.put(key, variableNode);
        }
        return variableNode;
    }

    public TryCatchBlock initTryCatchBlock() {
        return this.initTryCatchBlock(THROWABLE_TYPE.getInternalName());
    }

    public TryCatchBlock initTryCatchBlock(String exception) {
        if (this.tryCatchBlock == null) {
            this.tryCatchBlock = new TryCatchBlock(this.methodNode, exception);
            this.methodNode.instructions.insertBefore(this.getEnterInsnNode(), (AbstractInsnNode)this.tryCatchBlock.getStartLabelNode());
            this.methodNode.instructions.insert(this.getLastInsnNode(), (AbstractInsnNode)this.tryCatchBlock.getEndLabelNode());
            InsnList instructions = new InsnList();
            AsmOpUtils.throwException(instructions);
            this.methodNode.instructions.insert((AbstractInsnNode)this.tryCatchBlock.getEndLabelNode(), instructions);
            this.tryCatchBlock.sort();
        }
        return this.tryCatchBlock;
    }

    AbstractInsnNode findInitConstructorInstruction() {
        int nested = 0;
        for (AbstractInsnNode insnNode = this.methodNode.instructions.getFirst(); insnNode != null; insnNode = insnNode.getNext()) {
            MethodInsnNode methodInsnNode;
            if (insnNode instanceof TypeInsnNode) {
                if (insnNode.getOpcode() != 187) continue;
                ++nested;
                continue;
            }
            if (!(insnNode instanceof MethodInsnNode) || (methodInsnNode = (MethodInsnNode)insnNode).getOpcode() != 183 || !methodInsnNode.name.equals("<init>") || --nested >= 0) continue;
            return insnNode.getNext();
        }
        return null;
    }

    public AbstractInsnNode getEnterInsnNode() {
        return this.enterInsnNode;
    }

    public AbstractInsnNode getLastInsnNode() {
        return this.lastInsnNode;
    }

    public String[] getParameterTypes() {
        String[] parameterTypes = new String[this.argumentTypes.length];
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            parameterTypes[i] = this.argumentTypes[i].getClassName();
        }
        return parameterTypes;
    }

    public String[] getParameterNames() {
        if (this.argumentTypes.length == 0) {
            return new String[0];
        }
        List localVariableNodes = this.methodNode.localVariables;
        int localVariableStartIndex = 1;
        if (this.isStatic()) {
            localVariableStartIndex = 0;
        }
        if (localVariableNodes == null || localVariableNodes.size() <= localVariableStartIndex || this.argumentTypes.length + localVariableStartIndex > localVariableNodes.size()) {
            String[] names = new String[this.argumentTypes.length];
            for (int i = 0; i < this.argumentTypes.length; ++i) {
                String className = this.argumentTypes[i].getClassName();
                if (className != null) {
                    int findIndex = className.lastIndexOf(46);
                    if (findIndex == -1) {
                        names[i] = className;
                        continue;
                    }
                    names[i] = className.substring(findIndex + 1);
                    continue;
                }
                names[i] = this.argumentTypes[i].getDescriptor();
            }
            return names;
        }
        Collections.sort(localVariableNodes, new Comparator<LocalVariableNode>(){

            @Override
            public int compare(LocalVariableNode o1, LocalVariableNode o2) {
                return o1.index - o2.index;
            }
        });
        String[] names = new String[this.argumentTypes.length];
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            String name = ((LocalVariableNode)localVariableNodes.get((int)localVariableStartIndex++)).name;
            names[i] = name != null ? name : "";
        }
        return names;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    private boolean hasLocalVariable(String name) {
        List localVariableNodes = this.methodNode.localVariables;
        if (localVariableNodes == null) {
            return false;
        }
        for (LocalVariableNode node : localVariableNodes) {
            if (!node.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public void loadThis(InsnList instructions) {
        if (this.isConstructor()) {
            this.loadVar(instructions, 0);
        } else if (this.isStatic()) {
            this.loadNull(instructions);
        } else {
            this.loadVar(instructions, 0);
        }
    }

    void storeVar(InsnList instructions, int index) {
        instructions.add((AbstractInsnNode)new VarInsnNode(58, index));
    }

    void storeInt(InsnList instructions, int index) {
        instructions.add((AbstractInsnNode)new VarInsnNode(54, index));
    }

    void loadNull(InsnList instructions) {
        instructions.add((AbstractInsnNode)new InsnNode(1));
    }

    void loadVar(InsnList instructions, int index) {
        instructions.add((AbstractInsnNode)new VarInsnNode(25, index));
    }

    void loadInt(InsnList instructions, int index) {
        instructions.add((AbstractInsnNode)new VarInsnNode(21, index));
    }

    boolean isReturnCode(int opcode) {
        return opcode == 172 || opcode == 173 || opcode == 174 || opcode == 175 || opcode == 176 || opcode == 177;
    }

    Type getBoxedType(Type type) {
        switch (type.getSort()) {
            case 3: {
                return BYTE_TYPE;
            }
            case 1: {
                return BOOLEAN_TYPE;
            }
            case 4: {
                return SHORT_TYPE;
            }
            case 2: {
                return CHARACTER_TYPE;
            }
            case 5: {
                return INTEGER_TYPE;
            }
            case 6: {
                return FLOAT_TYPE;
            }
            case 7: {
                return LONG_TYPE;
            }
            case 8: {
                return DOUBLE_TYPE;
            }
        }
        return type;
    }

    void push(InsnList insnList, int value) {
        if (value >= -1 && value <= 5) {
            insnList.add((AbstractInsnNode)new InsnNode(3 + value));
        } else if (value >= -128 && value <= 127) {
            insnList.add((AbstractInsnNode)new IntInsnNode(16, value));
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            insnList.add((AbstractInsnNode)new IntInsnNode(17, value));
        } else {
            insnList.add((AbstractInsnNode)new LdcInsnNode((Object)value));
        }
    }

    void push(InsnList insnList, String value) {
        if (value == null) {
            insnList.add((AbstractInsnNode)new InsnNode(1));
        } else {
            insnList.add((AbstractInsnNode)new LdcInsnNode((Object)value));
        }
    }

    void newArray(InsnList insnList, Type type) {
        insnList.add((AbstractInsnNode)new TypeInsnNode(189, type.getInternalName()));
    }

    void dup(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(89));
    }

    void dup2(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(92));
    }

    void dupX1(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(90));
    }

    void dupX2(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(91));
    }

    void pop(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(87));
    }

    void swap(InsnList insnList) {
        insnList.add((AbstractInsnNode)new InsnNode(95));
    }

    void loadArgsVar(InsnList instructions) {
        if (this.argumentTypes.length == 0) {
            this.loadNull(instructions);
            return;
        }
        this.push(instructions, this.argumentTypes.length);
        this.newArray(instructions, OBJECT_TYPE);
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            Type type = this.argumentTypes[i];
            this.dup(instructions);
            this.push(instructions, i);
            this.loadArg(instructions, this.argumentTypes, i);
            this.box(instructions, type);
            this.arrayStore(instructions, OBJECT_TYPE);
        }
    }

    void loadArgs(InsnList instructions) {
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            this.loadArg(instructions, this.argumentTypes, i);
        }
    }

    void loadArg(InsnList instructions, Type[] argumentTypes, int i) {
        int index = this.getArgIndex(argumentTypes, i);
        Type type = argumentTypes[i];
        instructions.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(21), index));
    }

    int getArgIndex(Type[] argumentTypes, int arg) {
        int index = this.isStatic() ? 0 : 1;
        for (int i = 0; i < arg; ++i) {
            index += argumentTypes[i].getSize();
        }
        return index;
    }

    void box(InsnList instructions, Type type) {
        if (type.getSort() == 10 || type.getSort() == 9) {
            return;
        }
        if (type == Type.VOID_TYPE) {
            instructions.add((AbstractInsnNode)new InsnNode(1));
        } else {
            Type boxed = this.getBoxedType(type);
            this.newInstance(instructions, boxed);
            if (type.getSize() == 2) {
                this.dupX2(instructions);
                this.dupX2(instructions);
                this.pop(instructions);
            } else {
                this.dupX1(instructions);
                this.swap(instructions);
            }
            this.invokeConstructor(instructions, boxed, new Method("<init>", Type.VOID_TYPE, new Type[]{type}));
        }
    }

    void unbox(InsnList instructions, Type type) {
        Type t = NUMBER_TYPE;
        Method sig = null;
        switch (type.getSort()) {
            case 0: {
                return;
            }
            case 2: {
                t = CHARACTER_TYPE;
                sig = CHAR_VALUE;
                break;
            }
            case 1: {
                t = BOOLEAN_TYPE;
                sig = BOOLEAN_VALUE;
                break;
            }
            case 8: {
                sig = DOUBLE_VALUE;
                break;
            }
            case 6: {
                sig = FLOAT_VALUE;
                break;
            }
            case 7: {
                sig = LONG_VALUE;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                sig = INT_VALUE;
            }
        }
        if (sig == null) {
            instructions.add((AbstractInsnNode)new TypeInsnNode(192, type.getInternalName()));
        } else {
            instructions.add((AbstractInsnNode)new TypeInsnNode(192, t.getInternalName()));
            instructions.add((AbstractInsnNode)new MethodInsnNode(182, t.getInternalName(), sig.getName(), sig.getDescriptor(), false));
        }
    }

    void arrayStore(InsnList instructions, Type type) {
        instructions.add((AbstractInsnNode)new InsnNode(type.getOpcode(79)));
    }

    void arrayLoad(InsnList instructions, Type type) {
        instructions.add((AbstractInsnNode)new InsnNode(type.getOpcode(46)));
    }

    void newInstance(InsnList instructions, Type type) {
        instructions.add((AbstractInsnNode)new TypeInsnNode(187, type.getInternalName()));
    }

    void invokeConstructor(InsnList instructions, Type type, Method method) {
        String owner = type.getSort() == 9 ? type.getDescriptor() : type.getInternalName();
        instructions.add((AbstractInsnNode)new MethodInsnNode(183, owner, method.getName(), method.getDescriptor(), false));
    }

    LocalVariableNode addInterceptorLocalVariable(String name, String desc) {
        return this.addLocalVariable(name, desc, this.interceptorVariableStartLabelNode, this.interceptorVariableEndLabelNode);
    }

    LocalVariableNode addLocalVariable(String name, String desc, LabelNode start, LabelNode end) {
        Type type = Type.getType((String)desc);
        int index = this.nextLocals;
        this.nextLocals += type.getSize();
        this.methodNode.maxLocals = this.nextLocals;
        LocalVariableNode node = new LocalVariableNode(name, desc, null, start, end, index);
        if (this.keepLocalVariableNames) {
            this.methodNode.localVariables.add(node);
        }
        return node;
    }

    public void returnValue(InsnList instructions) {
        instructions.add((AbstractInsnNode)new InsnNode(this.returnType.getOpcode(172)));
    }

    public boolean isStatic() {
        return (this.methodNode.access & 8) != 0;
    }

    public boolean isConstructor() {
        return this.methodNode.name != null && this.methodNode.name.equals("<init>");
    }

    public MethodNode getMethodNode() {
        return this.methodNode;
    }

    public void setMethodNode(MethodNode methodNode) {
        this.methodNode = methodNode;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public ClassNode getClassNode() {
        return this.classNode;
    }

    public void setClassNode(ClassNode classNode) {
        this.classNode = classNode;
    }

    public LocationFilter getLocationFilter() {
        return this.locationFilter;
    }

    public void inline(String owner, MethodNode toInlineMethodNode) {
        ListIterator originMethodIter = this.methodNode.instructions.iterator();
        while (originMethodIter.hasNext()) {
            int i;
            AbstractInsnNode originMethodInsnNode = (AbstractInsnNode)originMethodIter.next();
            if (!(originMethodInsnNode instanceof MethodInsnNode)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)originMethodInsnNode;
            if (!methodInsnNode.owner.equals(owner) || !methodInsnNode.name.equals(toInlineMethodNode.name) || !methodInsnNode.desc.equals(toInlineMethodNode.desc)) continue;
            MethodNode tmpToInlineMethodNode = AsmUtils.copy(toInlineMethodNode);
            LabelNode end = new LabelNode();
            this.methodNode.instructions.insert((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)end);
            InsnList instructions = new InsnList();
            int currentMaxLocals = this.nextLocals;
            int off = (tmpToInlineMethodNode.access & 8) != 0 ? 0 : 1;
            Type[] args = Type.getArgumentTypes((String)tmpToInlineMethodNode.desc);
            int argsOff = off;
            for (i = 0; i < args.length; ++i) {
                argsOff += args[i].getSize();
            }
            this.nextLocals += argsOff;
            this.methodNode.maxLocals = this.nextLocals;
            for (i = args.length - 1; i >= 0; --i) {
                AsmOpUtils.storeVar(instructions, args[i], currentMaxLocals + (argsOff -= args[i].getSize()));
            }
            if (off > 0) {
                AsmOpUtils.storeVar(instructions, OBJECT_TYPE, currentMaxLocals);
            }
            ListIterator inlineIterator = tmpToInlineMethodNode.instructions.iterator();
            while (inlineIterator.hasNext()) {
                AbstractInsnNode abstractInsnNode = (AbstractInsnNode)inlineIterator.next();
                if (abstractInsnNode instanceof FrameNode) continue;
                if (abstractInsnNode instanceof VarInsnNode) {
                    VarInsnNode varInsnNode = (VarInsnNode)abstractInsnNode;
                    varInsnNode.var += currentMaxLocals;
                } else if (abstractInsnNode instanceof IincInsnNode) {
                    IincInsnNode iincInsnNode = (IincInsnNode)abstractInsnNode;
                    iincInsnNode.var += currentMaxLocals;
                }
                int opcode = abstractInsnNode.getOpcode();
                if (opcode >= 172 && opcode <= 177) {
                    inlineIterator.remove();
                    instructions.add((AbstractInsnNode)new JumpInsnNode(167, end));
                    continue;
                }
                inlineIterator.remove();
                instructions.add(abstractInsnNode);
            }
            this.methodNode.instructions.insertBefore((AbstractInsnNode)methodInsnNode, instructions);
            originMethodIter.remove();
            if (this.methodNode.tryCatchBlocks != null && tmpToInlineMethodNode.tryCatchBlocks != null) {
                this.methodNode.tryCatchBlocks.addAll(tmpToInlineMethodNode.tryCatchBlocks);
            }
            this.sortTryCatchBlock();
        }
    }

    public void sortTryCatchBlock() {
        if (this.methodNode.tryCatchBlocks == null) {
            return;
        }
        Collections.sort(this.methodNode.tryCatchBlocks, new Comparator<TryCatchBlockNode>(){

            @Override
            public int compare(TryCatchBlockNode t1, TryCatchBlockNode t2) {
                int len1 = this.blockLength(t1);
                int len2 = this.blockLength(t2);
                return len1 - len2;
            }

            private int blockLength(TryCatchBlockNode block) {
                int startidx = ((MethodProcessor)MethodProcessor.this).methodNode.instructions.indexOf((AbstractInsnNode)block.start);
                int endidx = ((MethodProcessor)MethodProcessor.this).methodNode.instructions.indexOf((AbstractInsnNode)block.end);
                return endidx - startidx;
            }
        });
        for (int i = 0; i < this.methodNode.tryCatchBlocks.size(); ++i) {
            ((TryCatchBlockNode)this.methodNode.tryCatchBlocks.get(i)).updateIndex(i);
        }
    }
}

