/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.arouter.core;

import android.content.Context;
import android.util.LruCache;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.facade.service.AutowiredService;
import com.alibaba.android.arouter.facade.template.ISyringe;
import java.util.ArrayList;
import java.util.List;

@Route(path="/arouter/service/autowired")
public class AutowiredServiceImpl
implements AutowiredService {
    private LruCache<String, ISyringe> classCache;
    private List<String> blackList;

    @Override
    public void init(Context context) {
        this.classCache = new LruCache(66);
        this.blackList = new ArrayList<String>();
    }

    @Override
    public void autowire(Object instance) {
        String className = instance.getClass().getName();
        try {
            if (!this.blackList.contains(className)) {
                ISyringe autowiredHelper = (ISyringe)this.classCache.get((Object)className);
                if (null == autowiredHelper) {
                    autowiredHelper = (ISyringe)Class.forName(instance.getClass().getName() + "$$ARouter$$Autowired").getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                autowiredHelper.inject(instance);
                this.classCache.put((Object)className, (Object)autowiredHelper);
            }
        }
        catch (Exception ex) {
            this.blackList.add(className);
        }
    }
}

