/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.arouter.core;

import android.content.Context;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.facade.service.AutowiredService;
import com.alibaba.android.arouter.facade.template.ISyringe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;

@Route(path="/arouter/service/autowired")
public class AutowiredServiceImpl
implements AutowiredService {
    private Map<String, ISyringe> classCache;
    private List<String> blackList;

    @Override
    public void init(Context context) {
        this.classCache = new LRUMap();
        this.blackList = new ArrayList<String>();
    }

    @Override
    public void autowire(Object instance) {
        String className = instance.getClass().getName();
        try {
            if (!this.blackList.contains(className)) {
                ISyringe autowiredHelper = this.classCache.get(className);
                if (null == autowiredHelper) {
                    autowiredHelper = (ISyringe)Class.forName(instance.getClass().getName() + "$$ARouter$$Autowired").getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                autowiredHelper.inject(instance);
                this.classCache.put(className, autowiredHelper);
            }
        }
        catch (Exception ex) {
            this.blackList.add(className);
        }
    }
}

