/*
 * Decompiled with CFR 0.152.
 */
package com.tmall.ultraviewpager;

import android.os.Handler;
import android.os.Message;
import android.util.SparseIntArray;

public class TimerHandler
extends Handler {
    SparseIntArray specialInterval;
    long interval;
    boolean isStopped = true;
    TimerHandlerListener listener;
    static final int MSG_TIMER_ID = 87108;

    public TimerHandler(TimerHandlerListener listener, long interval) {
        this.listener = listener;
        this.interval = interval;
    }

    public void handleMessage(Message msg) {
        if (87108 == msg.what && this.listener != null) {
            int nextIndex = this.listener.getNextItem();
            this.listener.callBack();
            this.tick(nextIndex);
        }
    }

    public void tick(int index) {
        this.sendEmptyMessageDelayed(87108, this.getNextInterval(index));
    }

    private long getNextInterval(int index) {
        long has;
        long next = this.interval;
        if (this.specialInterval != null && (has = (long)this.specialInterval.get(index, -1)) > 0L) {
            next = has;
        }
        return next;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void setStopped(boolean stopped) {
        this.isStopped = stopped;
    }

    public void setListener(TimerHandlerListener listener) {
        this.listener = listener;
    }

    public void setSpecialInterval(SparseIntArray specialInterval) {
        this.specialInterval = specialInterval;
    }

    public static interface TimerHandlerListener {
        public int getNextItem();

        public void callBack();
    }
}

