/*
 * Decompiled with CFR 0.152.
 */
package com.tmall.ultraviewpager;

import android.database.DataSetObserver;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

class UltraViewPagerAdapter
extends PagerAdapter {
    private static final int INFINITE_RATIO = 4;
    public static final String MULTISCR_TAG = "multi_scr_tag_";
    private PagerAdapter adapter;
    private boolean enableLoop;
    private float multiScrRatio = Float.NaN;
    private boolean hasCentered;
    private int scrWidth;
    private UltraViewPagerCenterListener centerListener;
    private SparseArray viewArray = new SparseArray();

    public UltraViewPagerAdapter(PagerAdapter adapter) {
        this.adapter = adapter;
    }

    public int getCount() {
        int count = this.enableLoop ? (this.adapter.getCount() == 0 ? 0 : this.adapter.getCount() * 4) : this.adapter.getCount();
        return count;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        int realPosition = position;
        if (this.enableLoop && this.adapter.getCount() != 0) {
            realPosition = position % this.adapter.getCount();
        }
        Object item = this.adapter.instantiateItem(container, realPosition);
        View childView = null;
        if (item instanceof View) {
            childView = (View)item;
        }
        if (item instanceof RecyclerView.ViewHolder) {
            childView = ((RecyclerView.ViewHolder)item).itemView;
        }
        ViewPager viewPager = (ViewPager)container;
        int childCount = viewPager.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = viewPager.getChildAt(i);
            if (!this.isViewFromObject(child, item)) continue;
            this.viewArray.put(realPosition, (Object)child);
            break;
        }
        if (this.isEnableMultiScr()) {
            if (this.scrWidth == 0) {
                this.scrWidth = container.getResources().getDisplayMetrics().widthPixels;
            }
            RelativeLayout relativeLayout = new RelativeLayout(container.getContext());
            if (childView.getLayoutParams() != null) {
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams((int)((float)this.scrWidth * this.multiScrRatio), -1);
                layoutParams.addRule(13, -1);
                childView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
            container.removeView(childView);
            relativeLayout.addView(childView);
            container.addView((View)relativeLayout);
            return relativeLayout;
        }
        return item;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        int realPosition = position;
        if (this.enableLoop && this.adapter.getCount() != 0) {
            realPosition = position % this.adapter.getCount();
        }
        if (this.isEnableMultiScr() && object instanceof RelativeLayout) {
            View child = ((RelativeLayout)object).getChildAt(0);
            ((RelativeLayout)object).removeAllViews();
            this.adapter.destroyItem(container, realPosition, (Object)child);
        } else {
            this.adapter.destroyItem(container, realPosition, object);
        }
        this.viewArray.remove(realPosition);
    }

    public View getViewAtPosition(int position) {
        return (View)this.viewArray.get(position);
    }

    public void finishUpdate(ViewGroup container) {
        if (!this.hasCentered && this.adapter.getCount() > 0 && this.getCount() > this.adapter.getCount()) {
            this.centerListener.center();
        }
        this.hasCentered = true;
        this.adapter.finishUpdate(container);
    }

    public boolean isViewFromObject(View view, Object object) {
        return this.adapter.isViewFromObject(view, object);
    }

    public void restoreState(Parcelable bundle, ClassLoader classLoader) {
        this.adapter.restoreState(bundle, classLoader);
    }

    public Parcelable saveState() {
        return this.adapter.saveState();
    }

    public void startUpdate(ViewGroup container) {
        this.adapter.startUpdate(container);
    }

    public CharSequence getPageTitle(int position) {
        int virtualPosition = position % this.adapter.getCount();
        return this.adapter.getPageTitle(virtualPosition);
    }

    public float getPageWidth(int position) {
        return this.adapter.getPageWidth(position);
    }

    public void setPrimaryItem(ViewGroup container, int position, Object object) {
        this.adapter.setPrimaryItem(container, position, object);
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.adapter.unregisterDataSetObserver(observer);
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        this.adapter.registerDataSetObserver(observer);
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.adapter.notifyDataSetChanged();
    }

    public int getItemPosition(Object object) {
        return this.adapter.getItemPosition(object);
    }

    public PagerAdapter getAdapter() {
        return this.adapter;
    }

    public int getRealCount() {
        return this.adapter.getCount();
    }

    void setEnableLoop(boolean status) {
        this.enableLoop = status;
        this.notifyDataSetChanged();
        if (!status) {
            this.centerListener.resetPosition();
        } else {
            try {
                this.centerListener.center();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    boolean isEnableLoop() {
        return this.enableLoop;
    }

    void setMultiScrRatio(float ratio) {
        this.multiScrRatio = ratio;
    }

    boolean isEnableMultiScr() {
        return !Float.isNaN(this.multiScrRatio) && this.multiScrRatio < 1.0f;
    }

    void setCenterListener(UltraViewPagerCenterListener listener) {
        this.centerListener = listener;
    }

    static interface UltraViewPagerCenterListener {
        public void center();

        public void resetPosition();
    }
}

