/*
 * Decompiled with CFR 0.152.
 */
package com.preference.ui.activity.preference;

import android.os.Bundle;
import android.view.MenuItem;
import com.preference.PowerPreference;
import com.preference.Preference;
import com.preference.model.PreferenceItem;
import com.preference.model.PreferenceObject;
import com.preference.ui.activity.preference.PreferenceAdapter;
import com.preference.ui.activity.preference.PreferenceView;
import java.util.ArrayList;
import java.util.List;

class PreferencePresenter {
    private final PreferenceView view;
    private boolean editable;

    PreferencePresenter(PreferenceView view) {
        this.view = view;
    }

    void getExtras(Bundle extras) {
        if (extras != null) {
            this.editable = extras.getBoolean("editable", false);
        }
    }

    void getData() {
        ArrayList<PreferenceAdapter.PreferenceGroup> list = new ArrayList<PreferenceAdapter.PreferenceGroup>();
        List<PreferenceObject> data = PowerPreference.getAllData();
        for (PreferenceObject object : data) {
            PreferenceAdapter.PreferenceGroup group = new PreferenceAdapter.PreferenceGroup(object.name, object.items);
            list.add(group);
        }
        this.view.updateView(list, this.editable);
    }

    void onBooleanPreferenceClicked(PreferenceItem item, boolean isChecked) {
        PowerPreference.getFileByName(item.parentName).put(item.key, isChecked);
        item.value = isChecked;
    }

    void onDefaultPreferenceClicked(PreferenceItem item) {
        this.view.showEditValueDialog(item);
    }

    void onSavePreferenceClicked(PreferenceItem item, String newValue) throws NumberFormatException {
        Preference preference = PowerPreference.getFileByName(item.parentName);
        switch (item.type) {
            case Integer: {
                preference.put(item.key, Integer.parseInt(newValue));
                item.value = Integer.parseInt(newValue);
                break;
            }
            case Float: {
                preference.put(item.key, Float.parseFloat(newValue));
                item.value = Float.valueOf(Float.parseFloat(newValue));
                break;
            }
            case Long: {
                preference.put(item.key, Long.parseLong(newValue));
                item.value = Long.parseLong(newValue);
                break;
            }
            case Boolean: {
                preference.put(item.key, Boolean.parseBoolean(newValue));
                item.value = Boolean.parseBoolean(newValue);
                break;
            }
            case String: {
                preference.put(item.key, newValue);
                item.value = newValue;
            }
        }
        this.view.refreshView();
    }

    public void onExpandClicked(MenuItem item) {
        this.view.onExpandClicked(item);
    }

    public void onCollapseClicked(MenuItem item) {
        this.view.onCollapseClicked(item);
    }

    public void onBackButtonClicked() {
        this.view.onBackButtonClicked();
    }
}

