/*
 * Decompiled with CFR 0.152.
 */
package com.preference;

import android.content.Context;
import android.support.annotation.NonNull;
import com.preference.Preference;
import com.preference.PreferenceManager;
import com.preference.model.PreferenceObject;
import java.util.List;

public class PowerPreference {
    private Context context;

    private PowerPreference(Context context) {
        this.context = context;
    }

    public static Preference getDefaultFile() {
        return PreferenceManager.get().getDefaultPreference();
    }

    public static Preference getFileByName(String name) {
        return PreferenceManager.get().getPreferenceByName(name);
    }

    public static void setSingletonInstance(PowerPreference instance) {
        PreferenceManager.setSingletonInstance(new PreferenceManager.Builder(instance.context).build());
    }

    public static List<PreferenceObject> getAllData() {
        return PreferenceManager.get().getData();
    }

    public static void clearAllData() {
        PowerPreference.getDefaultFile().clear();
        for (String filename : PreferenceManager.get().getFilesName()) {
            PreferenceManager.get().getPreferenceByName(filename).clear();
        }
    }

    public static void showDebugScreen(boolean editable) {
        PreferenceManager.get().showPreferenceScreen(editable);
    }

    public static class Builder {
        private final Context context;

        public Builder(@NonNull Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null.");
            }
            this.context = context.getApplicationContext();
        }

        public PowerPreference build() {
            return new PowerPreference(this.context);
        }
    }
}

