/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.insights;

import android.util.Log;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005R&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/algolia/instantsearch/insights/InsightsLogger;", "", "()V", "enabled", "", "", "", "getEnabled", "()Ljava/util/Map;", "setEnabled", "(Ljava/util/Map;)V", "tag", "log", "", "message", "indexName", "com.algolia.instantsearch-android.insights"})
public final class InsightsLogger {
    private static final String tag = "Algolia Insights";
    @NotNull
    private static Map<String, Boolean> enabled;
    public static final InsightsLogger INSTANCE;

    @NotNull
    public final Map<String, Boolean> getEnabled() {
        return enabled;
    }

    public final void setEnabled(@NotNull Map<String, Boolean> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        enabled = map;
    }

    public final void log(@NotNull String indexName, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)indexName, (String)"indexName");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (enabled.getOrDefault(indexName, false).booleanValue()) {
            Log.d((String)tag, (String)("Index=" + indexName + ": " + message));
        }
    }

    public final void log(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Log.d((String)tag, (String)message);
    }

    private InsightsLogger() {
    }

    static {
        InsightsLogger insightsLogger;
        INSTANCE = insightsLogger = new InsightsLogger();
        enabled = new LinkedHashMap();
    }
}

