/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.controllers;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingClient;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.polestar.helpers.Log;
import com.polestar.helpers.PrefHelper;
import com.polestar.helpers.i;
import com.polestar.models.GeofenceTransition;
import com.polestar.naosdk.api.GeofencePDB;
import com.polestar.naosdk.api.IGPSGeofencingManager;
import com.polestar.naosdk.api.external.NAOWakeUpRegistrationListener;
import com.polestar.naosdk.api.external.TNAOWAKEUP_REGISTER_STATUS;
import com.polestar.naosdk.managers.NaoContext;
import java.util.ArrayList;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class a
extends IGPSGeofencingManager {
    private Context a;
    private GeofencingClient a;
    private ArrayList<Geofence> a;
    NAOWakeUpRegistrationListener a;

    public a(Context context) {
        this.a = context.getApplicationContext();
        this.a = new ArrayList();
        this.a = LocationServices.getGeofencingClient((Context)context);
    }

    @Override
    public void registerGPSGeofences(ArrayList<GeofencePDB> arrayList) {
        this.a(arrayList);
    }

    public void a(String string2) {
        if (string2 != null && string2.length() > 2) {
            List<GeofencePDB> list = this.a(string2);
            if (!list.isEmpty()) {
                this.c(list);
                this.a();
            } else {
                String string3 = "No GPS geofences to add found, app.json might be missing";
                this.a(TNAOWAKEUP_REGISTER_STATUS.REGISTER_ERROR, string3);
                Log.alwaysWarn(this.getClass().getName(), string3);
            }
        }
    }

    public void a(List<GeofencePDB> list) {
        if (list.isEmpty()) {
            String string2 = "No GPS Geofences to register ...";
            this.a(TNAOWAKEUP_REGISTER_STATUS.REGISTER_ERROR, string2);
            Log.alwaysWarn(this.getClass().getName(), string2);
            return;
        }
        this.c(list);
        this.a();
    }

    public void b(String string2) {
        if (string2 != null && string2.length() > 2) {
            List<GeofencePDB> list = this.a(string2);
            if (!list.isEmpty()) {
                this.b(list);
            } else {
                String string3 = "No GPS geofences to delete found , app.json might be missing";
                this.a(TNAOWAKEUP_REGISTER_STATUS.UNREGISTER_ERROR, string3);
                Log.alwaysWarn(this.getClass().getName(), string3);
            }
        }
    }

    public void b(List<GeofencePDB> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GeofencePDB geofencePDB : list) {
            arrayList.add(geofencePDB.getName());
        }
        this.a.removeGeofences(arrayList).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

            public void a(Void void_) {
                PrefHelper.put(a.this.a, "android_geofencing_registered", false);
                String string2 = "Geofences removed";
                a.this.a(TNAOWAKEUP_REGISTER_STATUS.UNREGISTERED, string2);
                Log.alwaysWarn(this.getClass().getName(), string2);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception exception) {
                String string2 = "Removing geofencesGPS failed !";
                a.this.a(TNAOWAKEUP_REGISTER_STATUS.UNREGISTER_ERROR, string2);
                Log.alwaysError(this.getClass().getName(), string2);
            }
        });
    }

    public void a(NAOWakeUpRegistrationListener nAOWakeUpRegistrationListener) {
        this.a = nAOWakeUpRegistrationListener;
    }

    public boolean a() {
        return i.a(this.a, "com.polestar.naosdk.controllers.AndroidGeofencingService");
    }

    public boolean b() {
        return PrefHelper.get(this.a, "android_geofencing_registered", false);
    }

    private void a() {
        if (!this.c()) {
            String string2 = "Geofencing registration needs ACCESS_FINE_LOCATION permission ";
            Log.alwaysWarn(this.getClass().getName(), string2);
            this.a(TNAOWAKEUP_REGISTER_STATUS.REGISTER_ERROR, string2);
            return;
        }
        if (!this.a()) {
            String string3 = "AndroidGeofencingService must be declared in the application Manifest.xml";
            Log.alwaysWarn(this.getClass().getName(), string3);
            this.a(TNAOWAKEUP_REGISTER_STATUS.REGISTER_ERROR, string3);
            return;
        }
        if (this.a.isEmpty()) {
            String string4 = "No GPS Geofences to register ...";
            this.a(TNAOWAKEUP_REGISTER_STATUS.REGISTER_ERROR, string4);
            Log.alwaysWarn(this.getClass().getName(), string4);
        }
        this.a.addGeofences(this.a(), this.a()).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

            public void a(Void void_) {
                PrefHelper.put(a.this.a, "android_geofencing_registered", true);
                String string2 = "Android geofencing registered!";
                a.this.a(TNAOWAKEUP_REGISTER_STATUS.REGISTERED, string2);
                Log.alwaysWarn(this.getClass().getName(), string2);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception exception) {
                String string2 = "Registering failed: " + exception.getMessage();
                a.this.a(TNAOWAKEUP_REGISTER_STATUS.REGISTER_ERROR, string2);
                Log.alwaysError(this.getClass().getName(), string2);
            }
        });
    }

    private void c(List<GeofencePDB> list) {
        for (GeofencePDB geofencePDB : list) {
            this.a.add(new Geofence.Builder().setRequestId(geofencePDB.getName()).setCircularRegion((double)geofencePDB.getLat(), (double)geofencePDB.getLon(), (float)geofencePDB.getRadius()).setTransitionTypes(3).setExpirationDuration(-1L).build());
        }
    }

    private void a(TNAOWAKEUP_REGISTER_STATUS tNAOWAKEUP_REGISTER_STATUS, String string2) {
        if (this.a != null) {
            this.a.onStatusChanged(tNAOWAKEUP_REGISTER_STATUS, string2);
        }
    }

    private PendingIntent a() {
        Intent intent = new Intent(this.a, GeofenceTransition.class);
        return PendingIntent.getService((Context)this.a, (int)0, (Intent)intent, (int)0x8000000);
    }

    private GeofencingRequest a() {
        GeofencingRequest.Builder builder = new GeofencingRequest.Builder();
        builder.setInitialTrigger(1).addGeofences((List)this.a);
        return builder.build();
    }

    private List<GeofencePDB> a(String string2) {
        ArrayList<GeofencePDB> arrayList = new ArrayList<GeofencePDB>();
        if (string2 != null && string2.length() > 2) {
            try {
                if (this.a.getExternalFilesDir(".nao") != null) {
                    arrayList.addAll(NaoContext.getGeofenceGPS(this.a.getExternalFilesDir(".nao").getAbsolutePath(), string2));
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Log.alwaysWarn(this.getClass().getName(), "UnsatisfiedLinkError   getGeofenceGPS");
            }
            catch (Exception exception) {
                Log.alwaysWarn(this.getClass().getName(), "Exception thrown on context.getExternalFilesDir(Constants.NAO_ROOT_DIRECTORY).getAbsolutePath()");
            }
        }
        return arrayList;
    }

    private boolean c() {
        return com.polestar.helpers.a.a(this.a, "android.permission.ACCESS_FINE_LOCATION");
    }
}

