/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.gatt;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.polestar.naosdk.gatt.GattInterface;
import com.polestar.naosdk.gatt.INAOGattListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@RequiresApi(api=18)
public class GattManager
extends GattInterface {
    private static final String TAG = "GattManager";
    private Context a;
    private a a;
    private INAOGattListener a;
    private BluetoothAdapter a;
    private BluetoothManager a;
    private Handler a;
    private ConcurrentHashMap<String, BluetoothGatt> a = new Handler(Looper.getMainLooper());
    private ConcurrentHashMap<String, HashMap<UUID, UUID>> b;
    private final BluetoothGattCallback mGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(final BluetoothGatt bluetoothGatt, final int n, int n2) {
            Thread thread;
            Log.i((String)GattManager.TAG, (String)("OnConnectionStateChange: " + bluetoothGatt.getDevice().getAddress() + " Status: " + n));
            if (n == 133) {
                GattManager.this.a(bluetoothGatt.getDevice().getAddress());
                thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GattManager.this.a.onGattError(bluetoothGatt.getDevice().getAddress(), n);
                    }
                });
                thread.start();
            }
            if (n2 == 2 && n == 0) {
                if (Build.VERSION.SDK_INT >= 21) {
                    bluetoothGatt.requestConnectionPriority(1);
                }
                Log.d((String)GattManager.TAG, (String)("Device" + bluetoothGatt.getDevice().getAddress() + "connected!"));
                GattManager.this.a.put(bluetoothGatt.getDevice().getAddress(), bluetoothGatt);
                Log.d((String)GattManager.TAG, (String)("Connection size: " + GattManager.this.a.size()));
                thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GattManager.this.a.onConnected(bluetoothGatt.getDevice().getAddress());
                    }
                });
                thread.start();
            } else if (n2 == 0) {
                GattManager.this.a(bluetoothGatt.getDevice().getAddress());
                Log.i((String)GattManager.TAG, (String)("Disconnected: " + bluetoothGatt.getDevice().getAddress()));
                Log.d((String)GattManager.TAG, (String)("Connection size: " + GattManager.this.a.size()));
                thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            GattManager.this.a.onDisconnected(bluetoothGatt.getDevice().getAddress());
                        }
                        catch (Exception exception) {
                            Log.e((String)GattManager.TAG, (String)exception.getMessage());
                        }
                    }
                });
                thread.start();
            } else if (n2 == 1) {
                Log.d((String)GattManager.TAG, (String)("Connecting: " + bluetoothGatt.getDevice().getAddress()));
            } else {
                Log.i((String)GattManager.TAG, (String)"onGattError");
                thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GattManager.this.a.onGattError(bluetoothGatt.getDevice().getAddress(), n);
                    }
                });
                thread.start();
            }
        }

        public void onServicesDiscovered(final BluetoothGatt bluetoothGatt, final int n) {
            Log.i((String)GattManager.TAG, (String)("onService discovered status: " + n));
            if (n == 0) {
                Log.i((String)GattManager.TAG, (String)(bluetoothGatt.getServices().size() + " services discovered"));
                final HashSet<String> hashSet = new HashSet<String>();
                HashMap<UUID, UUID> hashMap = new HashMap<UUID, UUID>();
                for (BluetoothGattService bluetoothGattService : bluetoothGatt.getServices()) {
                    for (BluetoothGattCharacteristic bluetoothGattCharacteristic : bluetoothGattService.getCharacteristics()) {
                        hashMap.put(bluetoothGattCharacteristic.getUuid(), bluetoothGattService.getUuid());
                        hashSet.add(bluetoothGattCharacteristic.getUuid().toString().toUpperCase());
                    }
                }
                GattManager.this.b.put(bluetoothGatt.getDevice().getAddress(), hashMap);
                Log.i((String)GattManager.TAG, (String)(hashSet.size() + " characteristics found"));
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GattManager.this.a.onServicesDiscovered(bluetoothGatt.getDevice().getAddress(), hashSet);
                    }
                });
                thread.start();
            } else {
                Log.w((String)GattManager.TAG, (String)("onServicesDiscovered received: " + n));
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GattManager.this.a.onGattError(bluetoothGatt.getDevice().getAddress(), n);
                    }
                });
                thread.start();
            }
        }

        public void onCharacteristicRead(final BluetoothGatt bluetoothGatt, final BluetoothGattCharacteristic bluetoothGattCharacteristic, final int n) {
            Log.d((String)GattManager.TAG, (String)("onCharacteristicRead :" + n));
            if (n == 0 && null != bluetoothGattCharacteristic.getValue()) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GattManager.this.a.onReadAttribute(bluetoothGatt.getDevice().getAddress(), bluetoothGattCharacteristic.getUuid().toString().toUpperCase(), bluetoothGattCharacteristic.getValue());
                    }
                });
                thread.start();
            } else {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GattManager.this.a.onGattError(bluetoothGatt.getDevice().getAddress(), n);
                    }
                });
                thread.start();
            }
        }

        public void onCharacteristicWrite(final BluetoothGatt bluetoothGatt, final BluetoothGattCharacteristic bluetoothGattCharacteristic, final int n) {
            Log.d((String)GattManager.TAG, (String)("onCharacteristicWrite :" + n));
            if (n == 0) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GattManager.this.a.onWriteAttribute(bluetoothGatt.getDevice().getAddress(), bluetoothGattCharacteristic.getUuid().toString().toUpperCase());
                    }
                });
                thread.start();
            } else {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        GattManager.this.a.onGattError(bluetoothGatt.getDevice().getAddress(), n);
                    }
                });
                thread.start();
            }
        }

        public void onCharacteristicChanged(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
            super.onCharacteristicChanged(bluetoothGatt, bluetoothGattCharacteristic);
        }

        public void onDescriptorRead(BluetoothGatt bluetoothGatt, BluetoothGattDescriptor bluetoothGattDescriptor, int n) {
            super.onDescriptorRead(bluetoothGatt, bluetoothGattDescriptor, n);
        }

        public void onDescriptorWrite(BluetoothGatt bluetoothGatt, BluetoothGattDescriptor bluetoothGattDescriptor, int n) {
            super.onDescriptorWrite(bluetoothGatt, bluetoothGattDescriptor, n);
        }

        public void onReliableWriteCompleted(BluetoothGatt bluetoothGatt, int n) {
            super.onReliableWriteCompleted(bluetoothGatt, n);
        }

        public void onReadRemoteRssi(BluetoothGatt bluetoothGatt, int n, int n2) {
            super.onReadRemoteRssi(bluetoothGatt, n, n2);
        }

        public void onMtuChanged(BluetoothGatt bluetoothGatt, int n, int n2) {
            super.onMtuChanged(bluetoothGatt, n, n2);
        }
    };

    public GattManager(Context context, INAOGattListener iNAOGattListener) {
        this.a = context;
        this.a = iNAOGattListener;
        this.a = new ConcurrentHashMap();
        this.b = new ConcurrentHashMap();
        this.initBluetoothAdapter();
        this.a = new a(context);
    }

    @RequiresApi(api=18)
    public void initBluetoothAdapter() {
        if (this.a == null) {
            this.a = (BluetoothManager)this.a.getSystemService("bluetooth");
            if (this.a == null) {
                Log.e((String)this.getClass().getSimpleName(), (String)"Unable to initialize BluetoothManager.");
                return;
            }
        }
        this.a = this.a.getAdapter();
        if (this.a == null) {
            Log.e((String)this.getClass().getSimpleName(), (String)"Unable to obtain a BluetoothAdapter.");
            return;
        }
    }

    @Override
    @RequiresApi(api=18)
    public boolean connect(String string2, boolean bl) {
        BluetoothDevice bluetoothDevice2;
        if (this.a.containsKey(string2) && this.a.get(string2) != null) {
            Log.e((String)this.getClass().getSimpleName(), (String)(string2 + "already connected !"));
            return false;
        }
        for (BluetoothDevice bluetoothDevice2 : this.a.getConnectedDevices(7)) {
            if (bluetoothDevice2.getAddress() != string2) continue;
            Log.e((String)this.getClass().getSimpleName(), (String)(string2 + "already connected but can't be used !"));
            return false;
        }
        BluetoothDevice bluetoothDevice3 = this.a.getRemoteDevice(string2);
        bluetoothDevice2 = this.a.a(bluetoothDevice3, bl, this.mGattCallback);
        try {
            this.a((BluetoothGatt)bluetoothDevice2);
        }
        catch (Exception exception) {
            Log.e((String)this.getClass().getSimpleName(), (String)"Reflection error: cannot call refreshDeviceCache");
        }
        if (null != bluetoothDevice2) {
            this.a.put(bluetoothDevice3.getAddress(), bluetoothDevice2);
            return true;
        }
        return false;
    }

    @Override
    @RequiresApi(api=18)
    public void disconnect(String string2) {
        Log.i((String)this.getClass().getSimpleName(), (String)("call disconnect on: " + string2));
        if (!this.a.containsKey(string2)) {
            Log.e((String)this.getClass().getSimpleName(), (String)(string2 + "already disconnected !"));
            return;
        }
        this.a(string2);
    }

    @RequiresApi(api=18)
    private void a(String string2) {
        if (this.a.containsKey(string2)) {
            ((BluetoothGatt)this.a.get(string2)).close();
            ((BluetoothGatt)this.a.get(string2)).disconnect();
            this.a.remove(string2);
        }
    }

    @Override
    public boolean discoverServices(String string2) {
        BluetoothGatt bluetoothGatt = (BluetoothGatt)this.a.get(string2);
        if (null == bluetoothGatt) {
            Log.e((String)TAG, (String)"discoverServices Gatt null");
            return false;
        }
        boolean bl = ((BluetoothGatt)this.a.get(string2)).discoverServices();
        Log.i((String)this.getClass().getSimpleName(), (String)("discover services: " + bl));
        return bl;
    }

    @Override
    public boolean read(String string2, String string3, String string4) {
        BluetoothGatt bluetoothGatt = (BluetoothGatt)this.a.get(string2);
        if (null == bluetoothGatt) {
            return false;
        }
        UUID uUID = UUID.fromString(string4);
        UUID uUID2 = this.b.get(string2).get(uUID);
        BluetoothGattService bluetoothGattService = bluetoothGatt.getService(uUID2);
        BluetoothGattCharacteristic bluetoothGattCharacteristic = bluetoothGattService.getCharacteristic(uUID);
        boolean bl = bluetoothGatt.readCharacteristic(bluetoothGattCharacteristic);
        return bl;
    }

    @Override
    public boolean write(String string2, String string3, String string4, byte[] byArray) {
        Log.d((String)this.getClass().getSimpleName(), (String)string4);
        BluetoothGatt bluetoothGatt = (BluetoothGatt)this.a.get(string2);
        if (null == bluetoothGatt) {
            return false;
        }
        BluetoothGattService bluetoothGattService = bluetoothGatt.getService(this.b.get(string2).get(UUID.fromString(string4)));
        BluetoothGattCharacteristic bluetoothGattCharacteristic = bluetoothGattService.getCharacteristic(UUID.fromString(string4));
        bluetoothGattCharacteristic.setValue(byArray);
        boolean bl = bluetoothGatt.writeCharacteristic(bluetoothGattCharacteristic);
        return bl;
    }

    @Override
    public void clearGatt() {
        for (BluetoothGatt bluetoothGatt : this.a.values()) {
            bluetoothGatt.close();
            bluetoothGatt.disconnect();
        }
        this.a.clear();
    }

    private boolean a(BluetoothGatt bluetoothGatt) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Log.v((String)this.getClass().getSimpleName(), (String)"Trying to refresh device cache");
        BluetoothGatt bluetoothGatt2 = bluetoothGatt;
        Method method = bluetoothGatt2.getClass().getDeclaredMethod("refresh", new Class[0]);
        method.setAccessible(true);
        return (Boolean)method.invoke((Object)bluetoothGatt2, new Object[0]);
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private class a {
        private final Context a;

        public a(Context context) {
            this.a = context;
        }

        public BluetoothGatt a(BluetoothDevice bluetoothDevice, boolean bl, BluetoothGattCallback bluetoothGattCallback) {
            if (bluetoothDevice == null) {
                return null;
            }
            if (Build.VERSION.SDK_INT >= 24 || !bl) {
                return this.a(bluetoothGattCallback, bluetoothDevice, bl);
            }
            try {
                Log.v((String)this.getClass().getSimpleName(), (String)"Trying to connectGatt using reflection.");
                Object object = this.a(this.a());
                if (object == null) {
                    Log.w((String)this.getClass().getSimpleName(), (String)"Couldn't get iBluetoothGatt object");
                    return this.a(bluetoothGattCallback, bluetoothDevice, true);
                }
                BluetoothGatt bluetoothGatt = this.a(object, bluetoothDevice);
                if (bluetoothGatt == null) {
                    Log.w((String)this.getClass().getSimpleName(), (String)"Couldn't create BluetoothGatt object");
                    return this.a(bluetoothGattCallback, bluetoothDevice, true);
                }
                boolean bl2 = this.a(bluetoothGatt, bluetoothGattCallback, true);
                if (!bl2) {
                    Log.w((String)this.getClass().getSimpleName(), (String)"Connection using reflection failed, closing gatt");
                    bluetoothGatt.close();
                }
                return bluetoothGatt;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException exception) {
                Log.w((String)this.getClass().getSimpleName(), (String)("Error during reflection" + exception));
                return this.a(bluetoothGattCallback, bluetoothDevice, true);
            }
        }

        private BluetoothGatt a(BluetoothGattCallback bluetoothGattCallback, BluetoothDevice bluetoothDevice, boolean bl) {
            Log.v((String)this.getClass().getSimpleName(), (String)"Connecting without reflection");
            if (Build.VERSION.SDK_INT >= 23) {
                return bluetoothDevice.connectGatt(this.a, bl, bluetoothGattCallback, 2);
            }
            return bluetoothDevice.connectGatt(this.a, bl, bluetoothGattCallback);
        }

        private boolean a(BluetoothGatt bluetoothGatt, BluetoothGattCallback bluetoothGattCallback, boolean bl) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException {
            Log.v((String)this.getClass().getSimpleName(), (String)"Connecting using reflection");
            this.a(bluetoothGatt, bl);
            Method method = bluetoothGatt.getClass().getDeclaredMethod("connect", Boolean.class, BluetoothGattCallback.class);
            method.setAccessible(true);
            return (Boolean)method.invoke((Object)bluetoothGatt, true, bluetoothGattCallback);
        }

        @TargetApi(value=23)
        private BluetoothGatt a(Object object, BluetoothDevice bluetoothDevice) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            Constructor<?> constructor = BluetoothGatt.class.getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            Log.v((String)this.getClass().getSimpleName(), (String)("Found constructor with args count = " + constructor.getParameterTypes().length));
            if (constructor.getParameterTypes().length == 4) {
                return (BluetoothGatt)constructor.newInstance(this.a, object, bluetoothDevice, 2);
            }
            return (BluetoothGatt)constructor.newInstance(this.a, object, bluetoothDevice);
        }

        private Object a(Object object) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            if (object == null) {
                return null;
            }
            Method method = this.a(object.getClass(), "getBluetoothGatt");
            return method.invoke(object, new Object[0]);
        }

        private Object a() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            if (bluetoothAdapter == null) {
                return null;
            }
            Method method = this.a(bluetoothAdapter.getClass(), "getBluetoothManager");
            return method.invoke((Object)bluetoothAdapter, new Object[0]);
        }

        private Method a(Class<?> clazz, String string2) throws NoSuchMethodException {
            Method method = clazz.getDeclaredMethod(string2, new Class[0]);
            method.setAccessible(true);
            return method;
        }

        private void a(BluetoothGatt bluetoothGatt, boolean bl) throws NoSuchFieldException, IllegalAccessException {
            Field field = bluetoothGatt.getClass().getDeclaredField("mAutoConnect");
            field.setAccessible(true);
            field.setBoolean(bluetoothGatt, bl);
        }
    }
}

